# CZ:ATC Audit Event Content Profiles (ATNA) - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **CZ:ATC Audit Event Content Profiles (ATNA)**

## CZ:ATC Audit Event Content Profiles (ATNA)

There are four different categories of Audit Events in the context of the EPR:

1. Document management (e.g. a document has been uploaded to the EPR of a patient or a list of document metadata has been retrieved)
1. Policy management (e.g. a patient has given a healthcare professional access rights to his EPR)
1. Access Patient Audit Record Repository by a patient or representative (a patient viewed the Audit Trail for the Audit Record Repository)
1. Notification of the patient about the entry of healthcare professionals into a group

Each category is described as a content profile. These content profiles are based on the AuditEvent Resource, [http://hl7.org/fhir/R4/auditevent.html](http://hl7.org/fhir/R4/auditevent.html).

The AuditEvent Resource has [mapping rules to the DICOM audit message format](http://hl7.org/fhir/R4/auditevent-mappings.html#dicom), which allows to map to ATNA.

### Audit Trail Consumption Event Types

The following Audit Trail Consumption Event Types are defined and shall be supported.

| | | | |
| :--- | :--- | :--- | :--- |
| ATC_DOC_CREATE | Document upload | [Document Audit Event Content Profile](#document-audit-event-content-profile) | R |
| ATC_DOC_READ | Document retrieval | [Document Audit Event Content Profile](#document-audit-event-content-profile) | R |
| ATC_DOC_UPDATE | Document or Document Metadata update | [Document Audit Event Content Profile](#document-audit-event-content-profile) | R |
| ATC_DOC_DELETE | Document removal | [Document Audit Event Content Profile](#document-audit-event-content-profile) | R |
| ATC_DOC_SEARCH | Document search | [Document Audit Event Content Profile](#document-audit-event-content-profile) | R |
| ATC_POL_CREATE_AUT_PART_AL | Authorize participants to access level/date | [Policy Audit Event Content Profile](#policy-audit-event-content-profile) | R, (NP if not reference community) |
| ATC_POL_UPDATE_AUT_PART_AL | Update access level/date of authorized participants | [Policy Audit Event Content Profile](#policy-audit-event-content-profile) | R, (NP: if not reference community) |
| ATC_POL_REMOVE_AUT_PART_AL | Remove authorization for participants | [Policy Audit Event Content Profile](#policy-audit-event-content-profile) | R, (NP: if not reference community) |
| ATC_POL_DEF_CONFLEVEL | Set or update default Confidentiality Level | [Policy Audit Event Content Profile](#policy-audit-event-content-profile) | R, (NP: if not reference community) |
| ATC_POL_DIS_EMER_USE | Disabling Emergency Access | [Policy Audit Event Content Profile](#policy-audit-event-content-profile) | R, (NP: if not reference community) |
| ATC_POL_ENA_EMER_USE | Enabling Emergency Access | [Policy Audit Event Content Profile](#policy-audit-event-content-profile) | R, (NP: if not reference community) |
| ATC_POL_INCL_BLACKLIST | Assign Healthcare Professional to Blacklist | [Policy Audit Event Content Profile](#policy-audit-event-content-profile) | R, (NP: if not reference community) |
| ATC_POL_EXL_BLACKLIST | Exclude Healthcare Professional from Blacklist | [Policy Audit Event Content Profile](#policy-audit-event-content-profile) | R, (NP: if not reference community) |
| ATC_LOG_READ | Accessing Patient Audit Record Repository | [Access Audit Trail Content Profile](#access-audit-trail-content-profile) | R |
| ATC_HPD_GROUP_ENTRY_NOTIFY | Entry of healthcare professionals into a group | [HPD Group Entry Audit Event Content Profile](#hpd-group-entry-audit-event-content-profile) | R, (NP: if not reference community) |

**Table 1: Audit Trail Consumption Event Types**

### Document Audit Event Content Profile

This content profile describes Audit Event related to Document Management. The following Data Elements shall be provided:

| | | |
| :--- | :--- | :--- |
| **Data Element** | **Description** | **Property/Value** |
| Event Type | Document uploadDocument retrievalDocument or Document Metadata updateDocument removalDocument search | |
| Event Date and Time |   | FHIR instant |
| Participants |   |   |
| Initiator | Patient | NameRID |
| Representative of patient | NameRID | |
| Authorized Healthcare Professional | NameKRPZ | |
| Assistant of a Healthcare Professional | NameKRPZ | |
| Technical User | NameIdentifier | |
| Document Administrator | NameKRPZ | |
| Responsible[[2.1]](#_ftn2.1) | Patient | NameRID |
| Healthcare Professional | NameKRPZ | |
| Groups where Healthcare Professional is member |   | Name of GroupKRPZS |
| Purpose of Use |   | NORM, EMER, AUTO, DICOM_AUTO |
| Patient | Involved patient | RID |
| Document[[2.2]](#_ftn2.2) | type of document | typeCode (SNOMED CT code) |
| reference to document | uniqueIdrepositoryUniqueIdhomeCommunityID | |
| title of document | title | |

[[2.1]](#_ftnref2.1) If different from Initiator (Representative of patient acting on behalf of a patient then patient is responsible).

[[2.2]](#_ftnref2.2) Required for Document upload, Document retrieval, Document or Document Metadata update and Document removal but not for Document search.

**Table 2: Document Audit Event Data Elements**

This profile defines the content of the document audit events which a community has to provide for a patient's audit trail. This profile builds on AuditEvent ([http://hl7.org/fhir/R4/auditevent.html](http://hl7.org/fhir/R4/auditevent.html)).

#### Examples

It will be added

### Policy Audit Event Content Profile

This content profile describes Audit Events related to Policy Management. The following Data Elements shall be provided:

| | | |
| :--- | :--- | :--- |
| **Data Element** | **Description** | **Property/Value** |
| Event Type | Authorize participants to access level/date | |
| Update access level/date of authorized participants | | |
| Remove authorization for participants to access level/date | | |
| Set or update the default Confidentiality Level for new documents | | |
| Disabling Emergency Access | | |
| Enabling Emergency Access | | |
| Exclude a Healthcare Professional from accessing the EPR | | |
| Revoke the exclusion of a Healthcare Professional from accessing the EPR | | |
| Event Date Time |   | FHIR instant |
| Participants |   |   |
| Initiator | Patient | NameRID |
| Representative of patient | NameRID | |
| Authorized Healthcare Professional[[3.1]](#_ftn3.1) | NameKRPZ | |
| Assistant of a Healthcare Professional | NameKRPZ | |
| Policy Administrator | NameKRPZ | |
| Responsible | Patient | NameRID |
| Healthcare Professional | NameKRPZ | |
| Patient | Involved patient | RID |
| Resource | Resource Role | HCP, GRP or REP |
| Healthcare Professional | NameKRPZ | |
| Group of Healthcare Professional | Name of GroupKRPZS | |
| Representative of patient | NameRID | |
| AccessLevel[[3.2]](#_ftn3.2) | one of urn:e-health-suisse:2015:policies:access-level:normal, restricted, delegation-and-restricted, delegation-and-normal, full | |
| AccessLimitedToDate[[3.2]](#_ftn3.2) | Date | |
| ProvideLevel[[3.3]](#_ftn3.3) | one of urn:e-health-suisse:2015:policies:provide-level:normal, restricted, secret | |

[[3.1]](#_ftnref3.1) Healthcare Professional or Assistant of Healthcare Professional can only be a participant for the first Event Type (Authorize participants to access level).

[[3.2]](#_ftnref3.2) Access Level and the date if the access is limited (AccessLimitedToDate) are required for the first two Event Types (Authorize, update Authorization participants to access level/date), for the other Event Types these parameters do not need to be specified.

[[3.3]](#_ftnref3.3) Provide Level is only relevant for the Event Type Default Confidentiality Level for new Documents.

**Table 3: Policy Audit Event Data Elements**

This content profile defines the document audit events which a community has to provide for a patients audit trail. This profile builds on AuditEvent ([http://hl7.org/fhir/R4/auditevent.html](http://hl7.org/fhir/R4/auditevent.html)).

#### Examples

It will be added

### Access Audit Trail Content Profile

This content profile describes Audit Event related to Accessing the Audit Trail of a Patient from a Patient Audit Record Repository. The following Data Elements shall be provided:

| | | |
| :--- | :--- | :--- |
| **Data Element** | **Description** | **Property/Value** |
| Event Type |   | Access Audit Trail |
| Event Date and Time |   | FHIR instant |
| Participants |   |   |
| Initiator | Patient | NameRID |
| Representative of patient | NameRID | |
| Responsible | Patient | NameRID |
| Patient | Involved patient | RID |

**Table 11: Access Audit Trail Data Elements**

This content profile defines the access audit trail event, which a community has to provide for a patient’s audit trail. This profile builds on AuditEvent ([http://hl7.org/fhir/R4/auditevent.html](http://hl7.org/fhir/R4/auditevent.html)).

#### Example

It will be added

### HPD Group Entry Audit Event Content Profile

This content profile describe the Audit Event related to the entry of a healthcare professional into a HPD group for which the patient is notified. The following Data Elements shall be provided:

| | | |
| :--- | :--- | :--- |
| **Data Element** | **Description** | **Property/Value** |
| Event Type | Patient notified of Healthcare Professionals added to a group | |
| Event Date and Time |   | FHIR instant |
| Notification Service |   | NameRID |
| Patient | Notified patient | RID |
| Healthcare Professionals | Healthcare professionals | NameKRPZ |
| Group | Group where Healthcare Professionals are added as members | Name of GroupKRPZS |

**Table 13: HPD Group Entry Audit Event Elements**

This profile defines the content of the HPD group entry audit event. This profile builds on AuditEvent ([http://hl7.org/fhir/R4/auditevent.html](http://hl7.org/fhir/R4/auditevent.html)).

#### Example

It will be added

