# CZ:ATC Audit Event Content Profiles (ATNA) - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **CZ:ATC Audit Event Content Profiles (ATNA)**

## CZ:ATC Audit Event Content Profiles (ATNA)

V kontextu HIE existují čtyři různé kategorie Auditních Událostí:

1. Správa dokumentů (např. dokument pacienta byl nahrán nebo byl vyhledán seznam metadat dokumentů).
1. Správa politik (např. pacient udělil zdravotnickému pracovníkovi přístupová práva ke svému záznamu).
1. Přístup k Repozitáři Auditních Záznamů Pacienta pacientem nebo jeho zástupcem (pacient si zobrazil Auditní Stopu Repozitáře Auditních Záznamů).
1. Notifikace pacienta o vstupu zdravotnických pracovníků do skupiny.

Každá kategorie je popsána jako profil obsahu. Tyto profily obsahu vycházejí ze zdrojového objektu AuditEvent (Auditní Událost) [http://hl7.org/fhir/R4/auditevent.html](http://hl7.org/fhir/R4/auditevent.html).

Zdrojový objekt AuditEvent má [mapovací pravidla na formát DICOM auditní zprávy](http://hl7.org/fhir/R4/auditevent-mappings.html#dicom), což umožňuje mapování na ATNA.

### Typy Událostí Konzumace Auditní Stopy

Následující Typy Událostí Konzumace Auditní Stopy (Audit Trail Consumption Event Types) jsou definovány a musí být podporovány.

| | | | |
| :--- | :--- | :--- | :--- |
| ATC_DOC_CREATE | Nahrání dokumentu | [Profil Obsahu Auditních Událostí Dokumentů](#profil-obsahu-auditních-událostí-dokumentů) | R (Vyžadováno) |
| ATC_DOC_READ | Získání dokumentu | [Profil Obsahu Auditních Událostí Dokumentů](#profil-obsahu-auditních-událostí-dokumentů) | R (Vyžadováno) |
| ATC_DOC_UPDATE | Aktualizace dokumentu nebo metadat dokumentu | [Profil Obsahu Auditních Událostí Dokumentů](#profil-obsahu-auditních-událostí-dokumentů) | R (Vyžadováno) |
| ATC_DOC_DELETE | Odstranění dokumentu | [Profil Obsahu Auditních Událostí Dokumentů](#profil-obsahu-auditních-událostí-dokumentů) | R (Vyžadováno) |
| ATC_DOC_SEARCH | Vyhledávání dokumentů | [Profil Obsahu Auditních Událostí Dokumentů](#profil-obsahu-auditních-událostí-dokumentů) | R (Vyžadováno) |
| ATC_POL_CREATE_AUT_PART_AL | ATC_POL_CREATE_AUT_PART_AL Autorizovat účastníky pro úroveň/datum přístupu | [Profil Obsahu Auditních Událostí Politik](#profil-obsahu-auditních-událostí-politik) | R, (NP, pokud se nejedná o referenční komunitu) |
| ATC_POL_UPDATE_AUT_PART_AL | Aktualizovat úroveň/datum přístupu autorizovaných účastníků | [Profil Obsahu Auditních Událostí Politik](#profil-obsahu-auditních-událostí-politik) | R, (NP, pokud se nejedná o referenční komunitu) |
| ATC_POL_REMOVE_AUT_PART_AL | Odebrat autorizaci pro účastníky | [Profil Obsahu Auditních Událostí Politik](#profil-obsahu-auditních-událostí-politik) | R, (NP, pokud se nejedná o referenční komunitu) |
| ATC_POL_DEF_CONFLEVEL | Nastavit nebo aktualizovat výchozí Úroveň Důvěrnosti | [Profil Obsahu Auditních Událostí Politik](#profil-obsahu-auditních-událostí-politik) | R, (NP, pokud se nejedná o referenční komunitu) |
| ATC_POL_DIS_EMER_USE | Zakázání Nouzového Přístupu | [Profil Obsahu Auditních Událostí Politik](#profil-obsahu-auditních-událostí-politik) | R, (NP, pokud se nejedná o referenční komunitu) |
| ATC_POL_ENA_EMER_USE | Povolení Nouzového Přístupu | [Profil Obsahu Auditních Událostí Politik](#profil-obsahu-auditních-událostí-politik) | R, (NP, pokud se nejedná o referenční komunitu) |
| ATC_POL_INCL_BLACKLIST | Přiřadit Zdravotnického Pracovníka na Černou Listinu | [Profil Obsahu Auditních Událostí Politik](#profil-obsahu-auditních-událostí-politik) | R, (NP, pokud se nejedná o referenční komunitu) |
| ATC_POL_EXL_BLACKLIST | Vyloučit Zdravotnického Pracovníka z Černé Listiny | [Profil Obsahu Auditních Událostí Politik](#profil-obsahu-auditních-událostí-politik) | R, (NP, pokud se nejedná o referenční komunitu) |
| ATC_LOG_READ | Přístup k Repozitáři Auditních Záznamů Pacienta | [Access Audit Trail Content Profile](#profil-obsahu-auditních-událostí-politik) | R |
| ATC_HPD_GROUP_ENTRY_NOTIFY | Vstup zdravotnických pracovníků do skupiny | [HPD Group Entry Audit Event Content Profile](#profil-obsahu-přístupu-k-auditní-stopě) | R, (NP, pokud se nejedná o referenční komunituy) |

_Tabulka 1: Typy Událostí Konzumace Auditní Stopy

### Profil Obsahu Auditních Událostí Dokumentů

Tento profil obsahu popisuje Auditní Události související se Správou Dokumentů. Musí být poskytnuty následující datové prvky:

| | | |
| :--- | :--- | :--- |
| **Datový Prvek** | **Popis** | **Vlastnost/Hodnota** |
| Typ události | Nahrání dokumentu, Získání dokumentu, Aktualizace dokumentu nebo metadat dokumentu, Odstranění dokumentu, Vyhledávání dokumentů | |
| Datum a Čas Události |   | FHIR instant |
| Účastníci |   |   |
| Iniciátor | Pacient | JménoRID |
| Zástupce pacienta | JménoRID | |
| Autorizovaný Zdravotnický Pracovník | JménoKRZP | |
| Asistent Zdravotnického Pracovníka | JménoKRZP | |
| Technický Uživatel | JménoIdentifikátor | |
| Administrátor dokumentu | JménoKRZP | |
| Odpovědná osoba[[2.1]](#_ftn2.1) | Pacient | JménoRID |
| Zdravotnický Pracovník | JménoKRZP | |
| Skupiny, kde je Zdravotnický Pracovník členem |   | Jméno skupinyKRPZS |
| Účel Použití |   | NORM, EMER, AUTO, DICOM_AUTO |
| Pacient | Dotčený pacient | RID |
| Dokument[[2.2]](#_ftn2.2) | Typ dokumentu | typeCode (SNOMED CT code) |
| Odkaz na dokument | uniqueIdrepositoryUniqueIdhomeCommunityID | |
| Název dokumentu | title | |

[[2.1]](#_ftnref2.1) Pokud se liší od Iniciátora (např. Zástupce pacienta jedná jménem pacienta, pak je pacient Odpovědnou stranou).

[[2.2]](#_ftnref2.2) Vyžadováno pro nahrání dokumentu, získání dokumentu, aktualizaci dokumentu nebo metadat dokumentu a odstranění dokumentu, ale ne pro vyhledávání dokumentů.

**Tabulka 2: Datové Prvky Auditní Události Dokumentů**

Tento profil definuje obsah auditních událostí dokumentů, které musí komunita poskytovat pro auditní stopu pacienta. Vychází ze zdrojového objektu AuditEvent. ([http://hl7.org/fhir/R4/auditevent.html](http://hl7.org/fhir/R4/auditevent.html)).

#### Příklady

Budou dodány

### Profil Obsahu Auditních Událostí Politik

Tento profil obsahu popisuje Auditní Události související se Správou Politik (Policy Management). Musí být poskytnuty následující datové prvky:

| | | |
| :--- | :--- | :--- |
| **Datový Prvek** | **Popis** | **Vlastnost/Hodnota** |
| Typ Události | Autorizovat účastníky pro úroveň/datum přístupu | |
| Aktualizovat úroveň/datum přístupu autorizovaných účastníků | | |
| Odebrat autorizaci pro účastníky pro úroveň/datum přístupu | | |
| Nastavit nebo aktualizovat výchozí Úroveň Důvěrnosti pro nové dokumenty | | |
| Zakázání Nouzového Přístupu | | |
| Povolení Nouzového Přístupu | | |
| Vyloučit Zdravotnického Pracovníka z přístupu | | |
| Zrušit vyloučení Zdravotnického Pracovníka z přístupu | | |
| Datum a Čas Události |   | FHIR instant |
| Účastníci |   |   |
| Iniciátor | Pacient | Jméno/RID |
| Zástupce pacienta | JménoRID | |
| Autorizovaný Zdravotnický Pracovník[[3.1]](#_ftn3.1) | JménoKRZP | |
| Asistent Zdravotnického Pracovníka | JménoKRZP | |
| Administrátor Politik | JménoKRZP | |
| Odpovědná strana | Pacient | Jméno/RID |
| Zdravotnický Pracovník | JménoKRZP | |
| Pacient | Dotčený pacient | RID |
| Zdroj | Role zdroje | HCP, GRP or REP |
| Zdravotnický pracovník | JménoKRZP | |
| Skupina Zdravotnických Pracovníků | JménoKRPZS | |
| Zástupce pacienta | JménoRID | |
| Úroveň přístupu[[3.2]](#_ftn3.2) | jedna z hodnot úrovně přístupu:normal, restricted, delegation-and-restricted, delegation-and-normal, full | |
| Přístup omezen do data[[3.2]](#_ftn3.2) | Datum | |
| Úroveň poskytnutí[[3.3]](#_ftn3.3) | Jedna z hodnot:normal, restricted, secret | |

[[3.1]](#_ftnref3.1) Zdravotnický Pracovník nebo Asistent Zdravotnického Pracovníka může být účastníkem pouze pro první Typ Události (Autorizovat účastníky pro úroveň přístupu).

[[3.2]](#_ftnref3.2) Úroveň Přístupu a datum, pokud je přístup omezen (AccessLimitedToDate), jsou vyžadovány pro první dva Typy Událostí (Autorizovat, aktualizovat Autorizaci účastníků pro úroveň/datum přístupu); pro ostatní Typy Událostí tyto parametry nemusí být specifikovány.

[[3.3]](#_ftnref3.3) Úroveň Poskytnutí je relevantní pouze pro Typ Události Výchozí Úroveň Důvěrnosti pro nové Dokumenty.

**Tabulka 3: Datové Prvky Auditní Události Politik**

Tento profil definuje obsah auditních událostí politik, které musí komunita poskytovat pro auditní stopu pacienta. Vychází ze zdrojového objektu AuditEvent ([http://hl7.org/fhir/R4/auditevent.html](http://hl7.org/fhir/R4/auditevent.html)).

#### Příklady

Budou dodány

### Profil Obsahu Přístupu k Auditní Stopě

Tento profil obsahu popisuje Auditní Událost související s Přístupem k Auditní Stopě Pacienta z Repozitáře Auditních Záznamů Pacienta. Musí být poskytnuty následující datové prvky:

| | | |
| :--- | :--- | :--- |
| **Datový Prvek** | **Popis** | **Vlastnost/Hodnota** |
| Typ Události |   | Přístup k Auditní Stopě |
| Datum a Čas Události |   | FHIR instant |
| Účastníci |   |   |
| Iniciátor | Pacient | JménoRID |
| Zástupce pacienta | JménoRID | |
| Odpovědná strana | Pacient | JménoRID |
| Pacient | Dotčený pacient | EPR-SPID |

**Table 4: Datové Prvky Přístupu k Auditní Stopě**

Tento profil definuje událost přístupu k auditní stopě, kterou musí komunita poskytovat pro auditní stopu pacienta. Vychází ze zdrojového objektu AuditEvent. ([http://hl7.org/fhir/R4/auditevent.html](http://hl7.org/fhir/R4/auditevent.html)).

#### Příklady

Budou dodány

### Profil Obsahu Auditních Událostí Vstupu do Skupiny HPD

Tento profil obsahu popisuje Auditní Událost související se vstupem zdravotnického pracovníka do skupiny HPD, o čemž je pacient notifikován. Musí být poskytnuty následující datové prvky:

| | | |
| :--- | :--- | :--- |
| **Datový prvek** | **Popis** | **Vlastnost/Hodnota** |
| Typ Události | Pacient notifikován o přidání Zdravotnických Pracovníků do skupiny | |
| Datum a Čas Události |   | FHIR instant |
| Notifikační služba |   | Jméno |
| Pacient | Notifikovaný pacient | RID |
| Zdravotničtí Pracovníci | Zdravotničtí Pracovníci | JménoKRZP |
| Skupina | Skupina, do které jsou Zdravotničtí Pracovníci přidáni jako členové | JménoKRPZS |

**Table 5: Prvky Auditní Události Vstupu do Skupiny HPD**

Tento profil definuje obsah auditní události vstupu do skupiny HPD. Vychází ze zdrojového objektu AuditEvent ([http://hl7.org/fhir/R4/auditevent.html](http://hl7.org/fhir/R4/auditevent.html)).

#### Příklady

Budou doplněny

