# Home - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/ImplementationGuide/hl7.fhir.cz.hie | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:HL7CzHIEImplementationGuide |

### Introduction

This implementation specification focuses on the national implementation of the MHD (Mobile access to Health Documents) profile and Restful ATNA within the environment of Accredited Affinity Domains (AAfD) and the central eHealth services (EZ), based on the national [Standard of Accredited Affinity Domains](https://ncez.mzcr.cz/sites/default/files/media-documents/Standard%20Do%C4%8Dasn%C3%A9%20ulo%C5%BEi%C5%A1t%C4%9B%20v%200.10.pdf).

### Scope

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction and scope for this guide.
* Volume 1: 
* [Mobile Access to Health Documents (MHD)](mhd.md): This section specifies Czech national extensions to the Mobile Access to Health Documents (MHD)
* [Restful ATNA (ATNA)](atna.md): This section specifies Czech national extensions to the Restful ATNA (ATNA)
 
* Volume 2: 
* [Record Audit Event [ITI-20]](iti-20.md): This section describes the additional requirements for the Czech HIE of the Record Audit Event [ITI-20] transaction defined in the Add RESTful ATNA (Query and Feed) supplement published in the IHE ITI Trial Implementation.
* [Provide Document Bundle [ITI-65]](iti-65.md): This section describes the additional requirements for the Czech HIE of the Provide Document Bundle [ITI-65] transaction defined in the MHD Profile published in the IHE ITI Trial Implementation “Mobile Access to Health Documents”.
* [Find Document Lists [ITI-66]](iti-66.md): This section describes the additional requirements for the Czech HIE of the Find Document Lists [ITI-66] transaction defined in the MHD Profile published in the IHE ITI Trial Implementation “Mobile Access to Health Documents”.
* [Find Document References [ITI-67]](iti-67.md): This section describes the additional requirements for the Czech HIE of the Find Document References [ITI-67] transaction defined in the MHD Profile published in the IHE ITI Trial Implementation “Mobile Access to Health Documents”.
* [Retrieve Document [ITI-68]](iti-68.md): This section describes the additional requirements for the Czech HIE of the Retrieve Document [ITI-68] transaction defined in the MHD Profile published in the IHE ITI Trial Implementation “Mobile Access to Health Documents”.
* [Retrieve ATNA Audit Event [ITI-81]](iti-81.md): This section describes the additional requirements for the Czech HIE of the Retrieve ATNA Audit Event [ITI-81] transaction defined in the Add RESTful ATNA (Query and Feed) supplement published in the IHE ITI Trial Implementation.
 
* [Volume 3](volume3.md): This page describes implementation of ATC Audit Event Content Profiles.
* Appendix: 
* [Profiles](profiles.md): This section contains all profiles defined in this implementation guide.
 
* About: 
* [Authors](authors.md): This segment contains informaction about authors.
* [Downloads](downloads.md): This segment contains informaction about downloads.
* [Dependencies](dependencies.md): This segment contains informaction about dependencies.
* [Copyright](copyright.md): This segment contains informaction about copyright.
 
* [Artifacts](artifacts.md): This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Dependencies











### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cz.hie.r4)](package.r4.tgz) and [R4B (hl7.fhir.cz.hie.r4b)](package.r4b.tgz) are available.

### IP statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [CZ_ATCCs](CodeSystem-cz-atc-cs.md), [CZ_ATNA_Audit_Creator](CapabilityStatement-CZ-ATNA-AuditCreator.md)...Show 42 more,[CZ_ATNA_Audit_Record_Repository](CapabilityStatement-CZ-ATNA-AuditRecordRepository.md),[CZ_AuditEvent](StructureDefinition-cz-auditEvent.md),[CZ_AuditEventIti65Recipient](StructureDefinition-cz-auditEventIti65Recipient.md),[CZ_AuditEventIti65Source](StructureDefinition-cz-auditEventIti65Source.md),[CZ_AuditEventIti66Consumer](StructureDefinition-cz-auditEventIti66Consumer.md),[CZ_AuditEventIti66Responder](StructureDefinition-cz-auditEventIti66Responder.md),[CZ_AuditEventIti67Consumer](StructureDefinition-cz-auditEventIti67Consumer.md),[CZ_AuditEventIti67Responder](StructureDefinition-cz-auditEventIti67Responder.md),[CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md),[CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md),[CZ_DocumentAuditEvent](StructureDefinition-cz-documentAuditEvent.md),[CZ_DocumentAuditEventTypeCs](CodeSystem-cz-documentAuditEvent-type-cs.md),[CZ_DocumentAuditEventTypeVs](ValueSet-cz-documentAuditEvent-type-vs.md),[CZ_DocumentEntryAuthorRoleCs](CodeSystem-cz-documentEntry-authorRole-cs.md),[CZ_DocumentEntryAuthorRoleVs](ValueSet-cz-documentEntry-authorRole-vs.md),[CZ_DocumentEntryClassCodeVs](ValueSet-cz-documentEntry-classCode-vs.md),[CZ_DocumentEntryConfidentialityCodeVs](ValueSet-cz-documentEntry-confidentialityCode-vs.md),[CZ_DocumentEntryTypeCodeCs](CodeSystem-cz-documentEntry-typeCode-cs.md),[CZ_DocumentEntryTypeCodeVs](ValueSet-cz-documentEntry-typeCode-vs.md),[CZ_FindDocumentReferencesComprehensiveResponse](StructureDefinition-cz-mhd-finddocumentreference-comprehensive-bundle.md),[CZ_FindListsComprehensiveResponse](StructureDefinition-cz-mhd-finddocumentlists-comprehensive-bundle.md),[CZ_Folder](StructureDefinition-cz-mhd-folder-comprehensive.md),[CZ_HIEPurposeOfUseCs](CodeSystem-cz-purposeOfUse-cs.md),[CZ_HIEPurposeOfUseVs](ValueSet-cz-purposeOfUse-vs.md),[CZ_HPDAuditEvent](StructureDefinition-cz-hpdAuditEvent.md),[CZ_HPDAuditEventTypeCs](CodeSystem-cz-HPDAuditEvent-type-cs.md),[CZ_HPDAuditEventTypeVs](ValueSet-cz-HPDAuditEvent-type-vs.md),[CZ_MHD_DocumentConsumer](CapabilityStatement-CZ-MHD-DocumentConsumer.md),[CZ_MHD_DocumentRecipient](CapabilityStatement-CZ-MHD-DocumentRecipient.md),[CZ_MHD_DocumentResponder](CapabilityStatement-CZ-MHD-DocumentResponder.md),[CZ_MHD_DocumentSource](CapabilityStatement-CZ-MHD-DocumentSource.md),[CZ_MhdDocumentReferenceComprehensive](StructureDefinition-cz-mhd-documentreference-comprehensive.md),[CZ_MhdProvideDocumentBundleComprehensive](StructureDefinition-cz-mhd-providedocumentbundle-comprehensive.md),[CZ_MhdProvideDocumentBundleComprehensiveResponse](StructureDefinition-cz-mhd-providedocumentbundle-comprehensive-response.md),[CZ_MhdSubmissionSetComprehensive](StructureDefinition-cz-mhd-submissionset-comprehensive.md),[CZ_ParticipantsCs](CodeSystem-cz-participants-cs.md),[CZ_ParticipantsVs](ValueSet-cz-participants-vs.md),[CZ_PolicyAuditEventTypeCs](CodeSystem-cz-PolicyAuditEvent-type-cs.md),[CZ_PolicyAuditEventTypeVs](ValueSet-cz-PolicyAuditEvent-type-vs.md),[CZ_PolicytAuditevent](StructureDefinition-cz-policyAuditEvent.md),[CZ_UniqueIDIdentifier](StructureDefinition-cz-uniqueIDIdentifier.md)and[HL7CzHIEImplementationGuide](index.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright © 2011 by the National Electrical Manufacturers Association.

* [Audit Event ID](http://terminology.hl7.org/6.5.0/CodeSystem-audit-event-type.html): [AuditEvent/CZ-AuditEventIti66ConsumerExample](AuditEvent-CZ-AuditEventIti66ConsumerExample.md), [AuditEvent/CZ-AuditEventIti66ResponderExample](AuditEvent-CZ-AuditEventIti66ResponderExample.md)...Show 13 more,[AuditEvent/CZ-AuditEventIti67ConsumerExample](AuditEvent-CZ-AuditEventIti67ConsumerExample.md),[AuditEvent/CZ-AuditEventIti67ResponderExample](AuditEvent-CZ-AuditEventIti67ResponderExample.md),[AuditEvent/CZ-AuditEventIti68ConsumerExample](AuditEvent-CZ-AuditEventIti68ConsumerExample.md),[AuditEvent/CZ-AuditEventIti68ResponderExample](AuditEvent-CZ-AuditEventIti68ResponderExample.md),[CZ_AuditEventIti66Consumer](StructureDefinition-cz-auditEventIti66Consumer.md),[CZ_AuditEventIti66Responder](StructureDefinition-cz-auditEventIti66Responder.md),[CZ_AuditEventIti67Consumer](StructureDefinition-cz-auditEventIti67Consumer.md),[CZ_AuditEventIti67Responder](StructureDefinition-cz-auditEventIti67Responder.md),[CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md),[CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md),[CZ_DocumentAuditEvent](StructureDefinition-cz-documentAuditEvent.md),[CZ_HPDAuditEvent](StructureDefinition-cz-hpdAuditEvent.md)and[CZ_PolicytAuditevent](StructureDefinition-cz-policyAuditEvent.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright Â© 2011 by the National Electrical Manufacturers Association.

* DICOM Controlled Terminology Definitions: [AuditEvent/CZ-AuditEventIti65RecipientExample](AuditEvent-CZ-AuditEventIti65RecipientExample.md), [AuditEvent/CZ-AuditEventIti65SourceExample](AuditEvent-CZ-AuditEventIti65SourceExample.md)...Show 17 more,[AuditEvent/CZ-AuditEventIti66ConsumerExample](AuditEvent-CZ-AuditEventIti66ConsumerExample.md),[AuditEvent/CZ-AuditEventIti66ResponderExample](AuditEvent-CZ-AuditEventIti66ResponderExample.md),[AuditEvent/CZ-AuditEventIti67ConsumerExample](AuditEvent-CZ-AuditEventIti67ConsumerExample.md),[AuditEvent/CZ-AuditEventIti67ResponderExample](AuditEvent-CZ-AuditEventIti67ResponderExample.md),[AuditEvent/CZ-AuditEventIti68ConsumerExample](AuditEvent-CZ-AuditEventIti68ConsumerExample.md),[AuditEvent/CZ-AuditEventIti68ResponderExample](AuditEvent-CZ-AuditEventIti68ResponderExample.md),[CZ_AuditEventIti65Recipient](StructureDefinition-cz-auditEventIti65Recipient.md),[CZ_AuditEventIti65Source](StructureDefinition-cz-auditEventIti65Source.md),[CZ_AuditEventIti66Consumer](StructureDefinition-cz-auditEventIti66Consumer.md),[CZ_AuditEventIti66Responder](StructureDefinition-cz-auditEventIti66Responder.md),[CZ_AuditEventIti67Consumer](StructureDefinition-cz-auditEventIti67Consumer.md),[CZ_AuditEventIti67Responder](StructureDefinition-cz-auditEventIti67Responder.md),[CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md),[CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md),[CZ_DocumentAuditEvent](StructureDefinition-cz-documentAuditEvent.md),[CZ_HPDAuditEvent](StructureDefinition-cz-hpdAuditEvent.md)and[CZ_PolicytAuditevent](StructureDefinition-cz-policyAuditEvent.md)


* These codes are excerpted from ISO Standard, TS 21089-2017 - Health Informatics - Trusted End-to-End Information Flows, Copyright by ISO International. Copies of this standard are available through the ISO Web Site at www.iso.org.

* [ISO 21089 2017 Health Record Lifecycle Events](http://terminology.hl7.org/6.5.0/CodeSystem-iso-21089-lifecycle.html): [CZ_DocumentAuditEvent](StructureDefinition-cz-documentAuditEvent.md), [CZ_HPDAuditEvent](StructureDefinition-cz-hpdAuditEvent.md) and [CZ_PolicytAuditevent](StructureDefinition-cz-policyAuditEvent.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md), [CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md), [CZ_DocumentEntryClassCodeVs](ValueSet-cz-documentEntry-classCode-vs.md), [CZ_DocumentEntryConfidentialityCodeVs](ValueSet-cz-documentEntry-confidentialityCode-vs.md) and [CZ_MhdDocumentReferenceComprehensive](StructureDefinition-cz-mhd-documentreference-comprehensive.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Audit event entity type](http://terminology.hl7.org/6.5.0/CodeSystem-audit-entity-type.html): [AuditEvent/CZ-AuditEventIti65RecipientExample](AuditEvent-CZ-AuditEventIti65RecipientExample.md), [AuditEvent/CZ-AuditEventIti65SourceExample](AuditEvent-CZ-AuditEventIti65SourceExample.md)...Show 14 more,[AuditEvent/CZ-AuditEventIti66ConsumerExample](AuditEvent-CZ-AuditEventIti66ConsumerExample.md),[AuditEvent/CZ-AuditEventIti66ResponderExample](AuditEvent-CZ-AuditEventIti66ResponderExample.md),[AuditEvent/CZ-AuditEventIti67ConsumerExample](AuditEvent-CZ-AuditEventIti67ConsumerExample.md),[AuditEvent/CZ-AuditEventIti67ResponderExample](AuditEvent-CZ-AuditEventIti67ResponderExample.md),[AuditEvent/CZ-AuditEventIti68ConsumerExample](AuditEvent-CZ-AuditEventIti68ConsumerExample.md),[AuditEvent/CZ-AuditEventIti68ResponderExample](AuditEvent-CZ-AuditEventIti68ResponderExample.md),[CZ_AuditEventIti65Recipient](StructureDefinition-cz-auditEventIti65Recipient.md),[CZ_AuditEventIti65Source](StructureDefinition-cz-auditEventIti65Source.md),[CZ_AuditEventIti66Consumer](StructureDefinition-cz-auditEventIti66Consumer.md),[CZ_AuditEventIti66Responder](StructureDefinition-cz-auditEventIti66Responder.md),[CZ_AuditEventIti67Consumer](StructureDefinition-cz-auditEventIti67Consumer.md),[CZ_AuditEventIti67Responder](StructureDefinition-cz-auditEventIti67Responder.md),[CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md)and[CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md)
* [AuditEventEntityRole](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html): [AuditEvent/CZ-AuditEventIti65RecipientExample](AuditEvent-CZ-AuditEventIti65RecipientExample.md), [AuditEvent/CZ-AuditEventIti65SourceExample](AuditEvent-CZ-AuditEventIti65SourceExample.md)...Show 14 more,[AuditEvent/CZ-AuditEventIti66ConsumerExample](AuditEvent-CZ-AuditEventIti66ConsumerExample.md),[AuditEvent/CZ-AuditEventIti66ResponderExample](AuditEvent-CZ-AuditEventIti66ResponderExample.md),[AuditEvent/CZ-AuditEventIti67ConsumerExample](AuditEvent-CZ-AuditEventIti67ConsumerExample.md),[AuditEvent/CZ-AuditEventIti67ResponderExample](AuditEvent-CZ-AuditEventIti67ResponderExample.md),[AuditEvent/CZ-AuditEventIti68ConsumerExample](AuditEvent-CZ-AuditEventIti68ConsumerExample.md),[AuditEvent/CZ-AuditEventIti68ResponderExample](AuditEvent-CZ-AuditEventIti68ResponderExample.md),[CZ_AuditEventIti65Recipient](StructureDefinition-cz-auditEventIti65Recipient.md),[CZ_AuditEventIti65Source](StructureDefinition-cz-auditEventIti65Source.md),[CZ_AuditEventIti66Consumer](StructureDefinition-cz-auditEventIti66Consumer.md),[CZ_AuditEventIti66Responder](StructureDefinition-cz-auditEventIti66Responder.md),[CZ_AuditEventIti67Consumer](StructureDefinition-cz-auditEventIti67Consumer.md),[CZ_AuditEventIti67Responder](StructureDefinition-cz-auditEventIti67Responder.md),[CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md)and[CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md)
* [Confidentiality](http://terminology.hl7.org/6.5.0/CodeSystem-v3-Confidentiality.html): [CZ_MhdDocumentReferenceComprehensive](StructureDefinition-cz-mhd-documentreference-comprehensive.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [AuditEvent/CZ-AuditEventIti65RecipientExample](AuditEvent-CZ-AuditEventIti65RecipientExample.md), [AuditEvent/CZ-AuditEventIti65SourceExample](AuditEvent-CZ-AuditEventIti65SourceExample.md)...Show 14 more,[AuditEvent/CZ-AuditEventIti66ConsumerExample](AuditEvent-CZ-AuditEventIti66ConsumerExample.md),[AuditEvent/CZ-AuditEventIti66ResponderExample](AuditEvent-CZ-AuditEventIti66ResponderExample.md),[AuditEvent/CZ-AuditEventIti67ConsumerExample](AuditEvent-CZ-AuditEventIti67ConsumerExample.md),[AuditEvent/CZ-AuditEventIti67ResponderExample](AuditEvent-CZ-AuditEventIti67ResponderExample.md),[AuditEvent/CZ-AuditEventIti68ConsumerExample](AuditEvent-CZ-AuditEventIti68ConsumerExample.md),[AuditEvent/CZ-AuditEventIti68ResponderExample](AuditEvent-CZ-AuditEventIti68ResponderExample.md),[CZ_AuditEventIti65Recipient](StructureDefinition-cz-auditEventIti65Recipient.md),[CZ_AuditEventIti65Source](StructureDefinition-cz-auditEventIti65Source.md),[CZ_AuditEventIti66Consumer](StructureDefinition-cz-auditEventIti66Consumer.md),[CZ_AuditEventIti66Responder](StructureDefinition-cz-auditEventIti66Responder.md),[CZ_AuditEventIti67Consumer](StructureDefinition-cz-auditEventIti67Consumer.md),[CZ_AuditEventIti67Responder](StructureDefinition-cz-auditEventIti67Responder.md),[CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md)and[CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md)




## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.cz.hie",
  "url" : "https://hl7.cz/fhir/hie/ImplementationGuide/hl7.fhir.cz.hie",
  "version" : "0.0.1",
  "name" : "HL7CzHIEImplementationGuide",
  "title" : "HL7 Czech Health information exchange Implementation Guide",
  "status" : "draft",
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "HL7 Czech Health information exchange Implementation Guide",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.cz.hie",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_uv_ips",
      "uri" : "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
      "packageId" : "hl7.fhir.uv.ips",
      "version" : "1.1.0"
    },
    {
      "id" : "hl7_fhir_cz_core",
      "uri" : "https://fhir.hl7cr.eu/core/ImplementationGuide/hl7.fhir.cz.core",
      "packageId" : "hl7.fhir.cz.core",
      "version" : "current"
    },
    {
      "id" : "hl7_fhir_eu_base",
      "uri" : "http://hl7.eu/fhir/base/ImplementationGuide/hl7.fhir.eu.base",
      "packageId" : "hl7.fhir.eu.base",
      "version" : "0.1.0-ballot"
    },
    {
      "id" : "ihemhdfhir",
      "uri" : "https://profiles.ihe.net/ITI/MHD/ImplementationGuide/ihe.iti.mhd",
      "packageId" : "ihe.iti.mhd",
      "version" : "4.2.2"
    },
    {
      "id" : "hl7_terminology_r4",
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/hie/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/hie/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "ATNA",
        "name" : "ATNA Profiles",
        "description" : "Profiles related to RESTful ATNA"
      },
      {
        "id" : "MHD",
        "name" : "MHD Profiles",
        "description" : "Profiles related to Mobile Access to Health Documents (MHD)"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/CZ-ATNA-AuditCreator"
        },
        "name" : "ATNA Audit Creator (client)",
        "description" : "CapabilityStatement for Client Actor in the IHE IT Infrastructure Technical Framework Supplement Add RESTful ATNA.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/CZ-ATNA-AuditRecordRepository"
        },
        "name" : "ATNA Audit Record Repository (server)",
        "description" : "CapabilityStatement for Server Actor in the IHE IT Infrastructure Technical Framework Supplement Add RESTful ATNA.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-auditEvent"
        },
        "name" : "CZ Audit Event",
        "description" : "CZ FHIR profile on AuditEvent.",
        "exampleBoolean" : false,
        "groupingId" : "ATNA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-auditEventIti65Recipient"
        },
        "name" : "CZ Audit Event for [ITI-65] Document Recipient",
        "description" : "This profile is used to define the CZ Audit Event for the [ITI-65] transaction and the actor 'Document\r\nRecipient'.",
        "exampleBoolean" : false,
        "groupingId" : "ATNA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-auditEventIti65Source"
        },
        "name" : "CZ Audit Event for [ITI-65] Document Source",
        "description" : "This profile is used to define the CZ Audit Event for the [ITI-65] transaction and the actor 'Document\r\nSource'.",
        "exampleBoolean" : false,
        "groupingId" : "ATNA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-auditEventIti66Responder"
        },
        "name" : "CZ Audit Event for [ITI-66] Document List",
        "description" : "This profile is used to define the CZ Audit Event for the [ITI-66] transaction and the actor 'Document\r\nList Responder'.",
        "exampleBoolean" : false,
        "groupingId" : "ATNA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-auditEventIti66Consumer"
        },
        "name" : "CZ Audit Event for [ITI-66] Document List Consumer",
        "description" : "This profile is used to define the CZ Audit Event for the [ITI-66] transaction and the actor 'Document list\r\nConsumer'.",
        "exampleBoolean" : false,
        "groupingId" : "ATNA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-auditEventIti67Consumer"
        },
        "name" : "CZ Audit Event for [ITI-67] Document Consumer",
        "description" : "This profile is used to define the CZ Audit Event for the [ITI-67] transaction and the actor 'Document\r\nConsumer'.",
        "exampleBoolean" : false,
        "groupingId" : "ATNA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-auditEventIti67Responder"
        },
        "name" : "CZ Audit Event for [ITI-67] Document Responder",
        "description" : "This profile is used to define the CZ Audit Event for the [ITI-67] transaction and the actor 'Document\r\nResponder'.",
        "exampleBoolean" : false,
        "groupingId" : "ATNA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-auditEventIti68Consumer"
        },
        "name" : "CZ Audit Event for [ITI-68] Document Consumer",
        "description" : "This profile is used to define the CZ Audit Event for the [ITI-68] transaction and the actor 'Document\r\nConsumer'.",
        "exampleBoolean" : false,
        "groupingId" : "ATNA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-auditEventIti68Responder"
        },
        "name" : "CZ Audit Event for [ITI-68] Document Responder",
        "description" : "This profile is used to define the CZ Audit Event for the [ITI-68] transaction and the actor 'Document\r\nResponder'.",
        "exampleBoolean" : false,
        "groupingId" : "ATNA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-atc-cs"
        },
        "name" : "CZ Audit Trail Consumption Event Types CodeSystem",
        "description" : "Codesystem for Audit Trail Consumption Event Types codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-documentAuditEvent"
        },
        "name" : "CZ Document Audit Event",
        "description" : "CZ FHIR profile on AuditEvent for document.",
        "exampleBoolean" : false,
        "groupingId" : "ATNA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-documentAuditEvent-type-cs"
        },
        "name" : "CZ Document Audit Event Type CodeSystem",
        "description" : "Codesystem for document audit event type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-documentAuditEvent-type-vs"
        },
        "name" : "CZ Document Audit Event Type ValueSet",
        "description" : "Document audit event type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-documentEntry-authorRole-cs"
        },
        "name" : "CZ DocumentEntry AuthorRole CodeSystem",
        "description" : "Codesystem for author role codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-documentEntry-authorRole-vs"
        },
        "name" : "CZ DocumentEntry AuthorRole ValueSet",
        "description" : "Document author role codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-documentEntry-classCode-vs"
        },
        "name" : "CZ DocumentEntry ClassCode ValueSet",
        "description" : "Document classification codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-documentEntry-confidentialityCode-vs"
        },
        "name" : "CZ DocumentEntry Confidentiality ValueSet",
        "description" : "Document confidentiality codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-documentEntry-typeCode-cs"
        },
        "name" : "CZ DocumentEntry TypeCode CodeSystem",
        "description" : "Codesystem for document type codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-documentEntry-typeCode-vs"
        },
        "name" : "CZ DocumentEntry TypeCode ValueSet",
        "description" : "Document type codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-hpdAuditEvent"
        },
        "name" : "CZ HPD Audit Event",
        "description" : "CZ FHIR profile on AuditEvent for HPD event.",
        "exampleBoolean" : false,
        "groupingId" : "ATNA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-HPDAuditEvent-type-cs"
        },
        "name" : "CZ HPD Audit Event Type CodeSystem",
        "description" : "Codesystem for HPD audit event type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-HPDAuditEvent-type-vs"
        },
        "name" : "CZ HPD Audit Event Type ValueSet",
        "description" : "HPD audit event type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-mhd-documentreference-comprehensive"
        },
        "name" : "CZ MHD DocumentReference Comprehensive",
        "description" : "CZ MHD Profile on DocumentReference",
        "exampleBoolean" : false,
        "groupingId" : "MHD"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-mhd-finddocumentlists-comprehensive-bundle"
        },
        "name" : "CZ MHD Find Document Lists Comprehensive Response Message",
        "description" : "A profile on the Find Document Lists Comprehensive Response message (ITI-66)",
        "exampleBoolean" : false,
        "groupingId" : "MHD"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-mhd-finddocumentreference-comprehensive-bundle"
        },
        "name" : "CZ MHD Find Document References Comprehensive Response message",
        "description" : "A profile on the Find Document References Comprehensive Response message (ITI-67)",
        "exampleBoolean" : false,
        "groupingId" : "MHD"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-mhd-folder-comprehensive"
        },
        "name" : "CZ MHD Folder Comprehensive",
        "description" : "A profile on the List resource for MHD use as a Folder with Comprehensive Metadata",
        "exampleBoolean" : false,
        "groupingId" : "MHD"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-mhd-providedocumentbundle-comprehensive"
        },
        "name" : "CZ MHD Provide Document Bundle Comprehensive",
        "description" : "IHE MHD profile on Provide Document Bundle (ITI-65) transaction with Comprehensive Metadata for the Czech national interoperability standards.",
        "exampleBoolean" : false,
        "groupingId" : "MHD"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-mhd-providedocumentbundle-comprehensive-response"
        },
        "name" : "CZ MHD Provide Document Bundle Comprehensive Response",
        "description" : "IHE MHD profile on Response of Provide Document Bundle (ITI-65) transaction with Comprehensive Metadata.",
        "exampleBoolean" : false,
        "groupingId" : "MHD"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-mhd-submissionset-comprehensive"
        },
        "name" : "CZ MHD SubmissionSet Comprehensive",
        "description" : "CZ MHD SubmissionSet Comprehensive",
        "exampleBoolean" : false,
        "groupingId" : "MHD"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-participants-cs"
        },
        "name" : "CZ Participants CodeSystem",
        "description" : "Codesystem for participant code.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-participants-vs"
        },
        "name" : "CZ Participants ValueSet",
        "description" : "Participant codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-policyAuditEvent"
        },
        "name" : "CZ Policy Audit Event",
        "description" : "CZ FHIR profile on AuditEvent for policy.",
        "exampleBoolean" : false,
        "groupingId" : "ATNA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-PolicyAuditEvent-type-cs"
        },
        "name" : "CZ Policy Audit Event Type CodeSystem",
        "description" : "Codesystem for Policy audit event type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-PolicyAuditEvent-type-vs"
        },
        "name" : "CZ Policy Audit Event Type ValueSet",
        "description" : "Policy audit event type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-purposeOfUse-cs"
        },
        "name" : "CZ Purpose of use CodeSystem",
        "description" : "Codesystem for purpose of use codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-purposeOfUse-vs"
        },
        "name" : "CZ Purpose of use ValueSet",
        "description" : "Valueset for Purpose of use codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-uniqueIDIdentifier"
        },
        "name" : "CZ Unique ID Identifier",
        "description" : "CZ FHIR profile holding the XDSDocumentEntry.uniqueId.",
        "exampleBoolean" : false,
        "groupingId" : "ATNA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AuditEvent"
          }
        ],
        "reference" : {
          "reference" : "AuditEvent/CZ-AuditEventIti65RecipientExample"
        },
        "name" : "CZ-AuditEventIti65RecipientExample",
        "description" : "Example of AuditEvent profile CZAuditEventIti65Recipient",
        "exampleCanonical" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti65Recipient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AuditEvent"
          }
        ],
        "reference" : {
          "reference" : "AuditEvent/CZ-AuditEventIti65SourceExample"
        },
        "name" : "CZ-AuditEventIti65SourceExample",
        "description" : "Example of AuditEvent profile CZAuditEventIti65Source",
        "exampleCanonical" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti65Source"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AuditEvent"
          }
        ],
        "reference" : {
          "reference" : "AuditEvent/CZ-AuditEventIti66ConsumerExample"
        },
        "name" : "CZ-AuditEventIti66ConsumerExample",
        "description" : "Example of AuditEvent profile CZ_AuditEventIti66Consumer",
        "exampleCanonical" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti66Consumer"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AuditEvent"
          }
        ],
        "reference" : {
          "reference" : "AuditEvent/CZ-AuditEventIti66ResponderExample"
        },
        "name" : "CZ-AuditEventIti66ResponderExample",
        "description" : "Example of AuditEvent profile CZ_AuditEventIti66Responder",
        "exampleCanonical" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti66Responder"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AuditEvent"
          }
        ],
        "reference" : {
          "reference" : "AuditEvent/CZ-AuditEventIti67ConsumerExample"
        },
        "name" : "CZ-AuditEventIti67ConsumerExample",
        "description" : "Example of AuditEvent profile CZ_AuditEventIti67Consumer",
        "exampleCanonical" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti67Consumer"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AuditEvent"
          }
        ],
        "reference" : {
          "reference" : "AuditEvent/CZ-AuditEventIti67ResponderExample"
        },
        "name" : "CZ-AuditEventIti67ResponderExample",
        "description" : "Example of AuditEvent profile CZ_AuditEventIti67Responder",
        "exampleCanonical" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti67Responder"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AuditEvent"
          }
        ],
        "reference" : {
          "reference" : "AuditEvent/CZ-AuditEventIti68ConsumerExample"
        },
        "name" : "CZ-AuditEventIti68ConsumerExample",
        "description" : "Example of AuditEvent profile CZ_AuditEventIti68Consumer",
        "exampleCanonical" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti68Consumer"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AuditEvent"
          }
        ],
        "reference" : {
          "reference" : "AuditEvent/CZ-AuditEventIti68ResponderExample"
        },
        "name" : "CZ-AuditEventIti68ResponderExample",
        "description" : "Example of AuditEvent profile CZ_AuditEventIti68Responder",
        "exampleCanonical" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti68Responder"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/CZ-MHD-DocumentConsumer"
        },
        "name" : "MHD Document Consumer (client)",
        "description" : "CapabilityStatement for Actor MHD Document Consumer (client).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/CZ-MHD-DocumentRecipient"
        },
        "name" : "MHD Document Recipient (server)",
        "description" : "CapabilityStatement for Actor MHD Document Recipient (server).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/CZ-MHD-DocumentResponder"
        },
        "name" : "MHD Document Responder (server)",
        "description" : "CapabilityStatement for Actor MHD Document Responder (server).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/CZ-MHD-DocumentSource"
        },
        "name" : "MHD Document Source (client)",
        "description" : "CapabilityStatement for Actor MHD Document Source (client).",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index-cs.html"
            }
          ],
          "nameUrl" : "index-cs.html",
          "title" : "Domovská stránka",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "mhd.html"
            }
          ],
          "nameUrl" : "mhd.html",
          "title" : "Mobile Access to Health Documents (MHD)",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "mhd-cs.html"
            }
          ],
          "nameUrl" : "mhd-cs.html",
          "title" : "Mobile Access to Health Documents (MHD)",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "atna.html"
            }
          ],
          "nameUrl" : "atna.html",
          "title" : "RESTful ATNA (ATNA)",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "atna-cs.html"
            }
          ],
          "nameUrl" : "atna-cs.html",
          "title" : "RESTful ATNA (ATNA)",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "volume3.html"
            }
          ],
          "nameUrl" : "volume3.html",
          "title" : "CZ:ATC Audit Event Content Profiles (ATNA)",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "volume3-cs.html"
            }
          ],
          "nameUrl" : "volume3-cs.html",
          "title" : "CZ:ATC Audit Event Content Profiles (ATNA)",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "iti-20.html"
            }
          ],
          "nameUrl" : "iti-20.html",
          "title" : "Record Audit Event [ITI-20]",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "iti-20-cs.html"
            }
          ],
          "nameUrl" : "iti-20-cs.html",
          "title" : "Record Audit Event [ITI-20]",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "iti-66.html"
            }
          ],
          "nameUrl" : "iti-66.html",
          "title" : "Find Document Lists [ITI-66]",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "iti-66-cs.html"
            }
          ],
          "nameUrl" : "iti-66-cs.html",
          "title" : "Find Document Lists [ITI-66]",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "iti-67.html"
            }
          ],
          "nameUrl" : "iti-67.html",
          "title" : "Find Document References [ITI-67]",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "iti-67-cs.html"
            }
          ],
          "nameUrl" : "iti-67-cs.html",
          "title" : "Find Document References [ITI-67]",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "iti-68.html"
            }
          ],
          "nameUrl" : "iti-68.html",
          "title" : "Retrieve Document [ITI-68]",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "iti-68-cs.html"
            }
          ],
          "nameUrl" : "iti-68-cs.html",
          "title" : "Retrieve Document [ITI-68]",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "iti-65.html"
            }
          ],
          "nameUrl" : "iti-65.html",
          "title" : "Provide document bundle [ITI-65]",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "iti-65-cs.html"
            }
          ],
          "nameUrl" : "iti-65-cs.html",
          "title" : "Provide document bundle [ITI-65]",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "iti-81.html"
            }
          ],
          "nameUrl" : "iti-81.html",
          "title" : "Retrieve ATNA Audit Event [ITI-81]",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "iti-81-cs.html"
            }
          ],
          "nameUrl" : "iti-81-cs.html",
          "title" : "Retrieve ATNA Audit Event [ITI-81]",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "profiles.html"
            }
          ],
          "nameUrl" : "profiles.html",
          "title" : "Profiles",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "Artifacts",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors.html"
            }
          ],
          "nameUrl" : "authors.html",
          "title" : "Authors",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors-cs.html"
            }
          ],
          "nameUrl" : "authors-cs.html",
          "title" : "Autoři",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright.html"
            }
          ],
          "nameUrl" : "copyright.html",
          "title" : "Copyright",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright-cs.html"
            }
          ],
          "nameUrl" : "copyright-cs.html",
          "title" : "Autorská práva",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies.html"
            }
          ],
          "nameUrl" : "dependencies.html",
          "title" : "Dependencies",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies-cs.html"
            }
          ],
          "nameUrl" : "dependencies-cs.html",
          "title" : "Závislosti",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads-cs.html"
            }
          ],
          "nameUrl" : "downloads-cs.html",
          "title" : "Ke stažení",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
