# Artifacts - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Artifacts**

## Artifacts

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### ATNA Profiles 

Profiles related to RESTful ATNA

| | |
| :--- | :--- |
| [CZ Audit Event](StructureDefinition-cz-auditEvent.md) | CZ FHIR profile on AuditEvent. |
| [CZ Audit Event for [ITI-65] Document Recipient](StructureDefinition-cz-auditEventIti65Recipient.md) | This profile is used to define the CZ Audit Event for the [ITI-65] transaction and the actor 'Document Recipient'. |
| [CZ Audit Event for [ITI-65] Document Source](StructureDefinition-cz-auditEventIti65Source.md) | This profile is used to define the CZ Audit Event for the [ITI-65] transaction and the actor 'Document Source'. |
| [CZ Audit Event for [ITI-66] Document List](StructureDefinition-cz-auditEventIti66Responder.md) | This profile is used to define the CZ Audit Event for the [ITI-66] transaction and the actor 'Document List Responder'. |
| [CZ Audit Event for [ITI-66] Document List Consumer](StructureDefinition-cz-auditEventIti66Consumer.md) | This profile is used to define the CZ Audit Event for the [ITI-66] transaction and the actor 'Document list Consumer'. |
| [CZ Audit Event for [ITI-67] Document Consumer](StructureDefinition-cz-auditEventIti67Consumer.md) | This profile is used to define the CZ Audit Event for the [ITI-67] transaction and the actor 'Document Consumer'. |
| [CZ Audit Event for [ITI-67] Document Responder](StructureDefinition-cz-auditEventIti67Responder.md) | This profile is used to define the CZ Audit Event for the [ITI-67] transaction and the actor 'Document Responder'. |
| [CZ Audit Event for [ITI-68] Document Consumer](StructureDefinition-cz-auditEventIti68Consumer.md) | This profile is used to define the CZ Audit Event for the [ITI-68] transaction and the actor 'Document Consumer'. |
| [CZ Audit Event for [ITI-68] Document Responder](StructureDefinition-cz-auditEventIti68Responder.md) | This profile is used to define the CZ Audit Event for the [ITI-68] transaction and the actor 'Document Responder'. |
| [CZ Document Audit Event](StructureDefinition-cz-documentAuditEvent.md) | CZ FHIR profile on AuditEvent for document. |
| [CZ HPD Audit Event](StructureDefinition-cz-hpdAuditEvent.md) | CZ FHIR profile on AuditEvent for HPD event. |
| [CZ Policy Audit Event](StructureDefinition-cz-policyAuditEvent.md) | CZ FHIR profile on AuditEvent for policy. |
| [CZ Unique ID Identifier](StructureDefinition-cz-uniqueIDIdentifier.md) | CZ FHIR profile holding the XDSDocumentEntry.uniqueId. |

### MHD Profiles 

Profiles related to Mobile Access to Health Documents (MHD)

| | |
| :--- | :--- |
| [CZ MHD DocumentReference Comprehensive](StructureDefinition-cz-mhd-documentreference-comprehensive.md) | CZ MHD Profile on DocumentReference |
| [CZ MHD Find Document Lists Comprehensive Response Message](StructureDefinition-cz-mhd-finddocumentlists-comprehensive-bundle.md) | A profile on the Find Document Lists Comprehensive Response message (ITI-66) |
| [CZ MHD Find Document References Comprehensive Response message](StructureDefinition-cz-mhd-finddocumentreference-comprehensive-bundle.md) | A profile on the Find Document References Comprehensive Response message (ITI-67) |
| [CZ MHD Folder Comprehensive](StructureDefinition-cz-mhd-folder-comprehensive.md) | A profile on the List resource for MHD use as a Folder with Comprehensive Metadata |
| [CZ MHD Provide Document Bundle Comprehensive](StructureDefinition-cz-mhd-providedocumentbundle-comprehensive.md) | IHE MHD profile on Provide Document Bundle (ITI-65) transaction with Comprehensive Metadata for the Czech national interoperability standards. |
| [CZ MHD Provide Document Bundle Comprehensive Response](StructureDefinition-cz-mhd-providedocumentbundle-comprehensive-response.md) | IHE MHD profile on Response of Provide Document Bundle (ITI-65) transaction with Comprehensive Metadata. |
| [CZ MHD SubmissionSet Comprehensive](StructureDefinition-cz-mhd-submissionset-comprehensive.md) | CZ MHD SubmissionSet Comprehensive |

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [ATNA Audit Creator (client)](CapabilityStatement-CZ-ATNA-AuditCreator.md) | CapabilityStatement for Client Actor in the IHE IT Infrastructure Technical Framework Supplement Add RESTful ATNA. |
| [ATNA Audit Record Repository (server)](CapabilityStatement-CZ-ATNA-AuditRecordRepository.md) | CapabilityStatement for Server Actor in the IHE IT Infrastructure Technical Framework Supplement Add RESTful ATNA. |
| [MHD Document Consumer (client)](CapabilityStatement-CZ-MHD-DocumentConsumer.md) | CapabilityStatement for Actor MHD Document Consumer (client). |
| [MHD Document Recipient (server)](CapabilityStatement-CZ-MHD-DocumentRecipient.md) | CapabilityStatement for Actor MHD Document Recipient (server). |
| [MHD Document Responder (server)](CapabilityStatement-CZ-MHD-DocumentResponder.md) | CapabilityStatement for Actor MHD Document Responder (server). |
| [MHD Document Source (client)](CapabilityStatement-CZ-MHD-DocumentSource.md) | CapabilityStatement for Actor MHD Document Source (client). |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [CZ Document Audit Event Type ValueSet](ValueSet-cz-documentAuditEvent-type-vs.md) | Document audit event type. |
| [CZ DocumentEntry AuthorRole ValueSet](ValueSet-cz-documentEntry-authorRole-vs.md) | Document author role codes. |
| [CZ DocumentEntry ClassCode ValueSet](ValueSet-cz-documentEntry-classCode-vs.md) | Document classification codes. |
| [CZ DocumentEntry Confidentiality ValueSet](ValueSet-cz-documentEntry-confidentialityCode-vs.md) | Document confidentiality codes. |
| [CZ DocumentEntry TypeCode ValueSet](ValueSet-cz-documentEntry-typeCode-vs.md) | Document type codes. |
| [CZ HPD Audit Event Type ValueSet](ValueSet-cz-HPDAuditEvent-type-vs.md) | HPD audit event type. |
| [CZ Participants ValueSet](ValueSet-cz-participants-vs.md) | Participant codes. |
| [CZ Policy Audit Event Type ValueSet](ValueSet-cz-PolicyAuditEvent-type-vs.md) | Policy audit event type. |
| [CZ Purpose of use ValueSet](ValueSet-cz-purposeOfUse-vs.md) | Valueset for Purpose of use codes. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [CZ Audit Trail Consumption Event Types CodeSystem](CodeSystem-cz-atc-cs.md) | Codesystem for Audit Trail Consumption Event Types codes. |
| [CZ Document Audit Event Type CodeSystem](CodeSystem-cz-documentAuditEvent-type-cs.md) | Codesystem for document audit event type. |
| [CZ DocumentEntry AuthorRole CodeSystem](CodeSystem-cz-documentEntry-authorRole-cs.md) | Codesystem for author role codes. |
| [CZ DocumentEntry TypeCode CodeSystem](CodeSystem-cz-documentEntry-typeCode-cs.md) | Codesystem for document type codes. |
| [CZ HPD Audit Event Type CodeSystem](CodeSystem-cz-HPDAuditEvent-type-cs.md) | Codesystem for HPD audit event type. |
| [CZ Participants CodeSystem](CodeSystem-cz-participants-cs.md) | Codesystem for participant code. |
| [CZ Policy Audit Event Type CodeSystem](CodeSystem-cz-PolicyAuditEvent-type-cs.md) | Codesystem for Policy audit event type. |
| [CZ Purpose of use CodeSystem](CodeSystem-cz-purposeOfUse-cs.md) | Codesystem for purpose of use codes. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [CZ-AuditEventIti65RecipientExample](AuditEvent-CZ-AuditEventIti65RecipientExample.md) | Example of AuditEvent profile CZAuditEventIti65Recipient |
| [CZ-AuditEventIti65SourceExample](AuditEvent-CZ-AuditEventIti65SourceExample.md) | Example of AuditEvent profile CZAuditEventIti65Source |
| [CZ-AuditEventIti66ConsumerExample](AuditEvent-CZ-AuditEventIti66ConsumerExample.md) | Example of AuditEvent profile CZ_AuditEventIti66Consumer |
| [CZ-AuditEventIti66ResponderExample](AuditEvent-CZ-AuditEventIti66ResponderExample.md) | Example of AuditEvent profile CZ_AuditEventIti66Responder |
| [CZ-AuditEventIti67ConsumerExample](AuditEvent-CZ-AuditEventIti67ConsumerExample.md) | Example of AuditEvent profile CZ_AuditEventIti67Consumer |
| [CZ-AuditEventIti67ResponderExample](AuditEvent-CZ-AuditEventIti67ResponderExample.md) | Example of AuditEvent profile CZ_AuditEventIti67Responder |
| [CZ-AuditEventIti68ConsumerExample](AuditEvent-CZ-AuditEventIti68ConsumerExample.md) | Example of AuditEvent profile CZ_AuditEventIti68Consumer |
| [CZ-AuditEventIti68ResponderExample](AuditEvent-CZ-AuditEventIti68ResponderExample.md) | Example of AuditEvent profile CZ_AuditEventIti68Responder |

