# CZ Purpose of use ValueSet - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Purpose of use ValueSet**

## ValueSet: CZ Purpose of use ValueSet 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/ValueSet/cz-purposeOfUse-vs | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_HIEPurposeOfUseVs |

 
Valueset for Purpose of use codes. 

 **References** 

* [CZ Audit Event for [ITI-65] Document Recipient](StructureDefinition-cz-auditEventIti65Recipient.md)
* [CZ Audit Event for [ITI-65] Document Source](StructureDefinition-cz-auditEventIti65Source.md)
* [CZ Audit Event for [ITI-66] Document List Consumer](StructureDefinition-cz-auditEventIti66Consumer.md)
* [CZ Audit Event for [ITI-66] Document List](StructureDefinition-cz-auditEventIti66Responder.md)
* [CZ Audit Event for [ITI-67] Document Consumer](StructureDefinition-cz-auditEventIti67Consumer.md)
* [CZ Audit Event for [ITI-67] Document Responder](StructureDefinition-cz-auditEventIti67Responder.md)
* [CZ Audit Event for [ITI-68] Document Consumer](StructureDefinition-cz-auditEventIti68Consumer.md)
* [CZ Audit Event for [ITI-68] Document Responder](StructureDefinition-cz-auditEventIti68Responder.md)
* [CZ Document Audit Event](StructureDefinition-cz-documentAuditEvent.md)

### Logical Definition (CLD)

* Include all codes defined in [`https://hl7.cz/fhir/hie/CodeSystem/cz-purposeOfUse-cs`](CodeSystem-cz-purposeOfUse-cs.md)version 📦0.0.1

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-purposeOfUse-vs",
  "url" : "https://hl7.cz/fhir/hie/ValueSet/cz-purposeOfUse-vs",
  "version" : "0.0.1",
  "name" : "CZ_HIEPurposeOfUseVs",
  "title" : "CZ Purpose of use ValueSet",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Valueset for Purpose of use codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://hl7.cz/fhir/hie/CodeSystem/cz-purposeOfUse-cs"
      }
    ]
  }
}

```
