# CZ DocumentEntry ClassCode ValueSet - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ DocumentEntry ClassCode ValueSet**

## ValueSet: CZ DocumentEntry ClassCode ValueSet 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/ValueSet/cz-documentEntry-classCode-vs | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_DocumentEntryClassCodeVs |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
Document classification codes. 

 **References** 

* [CZ MHD DocumentReference Comprehensive](StructureDefinition-cz-mhd-documentreference-comprehensive.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT International edition 01-Feb 2025

This value set contains 17 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-documentEntry-classCode-vs",
  "url" : "https://hl7.cz/fhir/hie/ValueSet/cz-documentEntry-classCode-vs",
  "version" : "0.0.1",
  "name" : "CZ_DocumentEntryClassCodeVs",
  "title" : "CZ DocumentEntry ClassCode ValueSet",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Document classification codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "371531000",
            "display" : "Encounter report"
          },
          {
            "code" : "721927009",
            "display" : "Referral note"
          },
          {
            "code" : "721963009",
            "display" : "Order"
          },
          {
            "code" : "185349003",
            "display" : "Discharge summary"
          },
          {
            "code" : "422735006",
            "display" : "Summary clinical document"
          },
          {
            "code" : "371525003",
            "display" : "Clinical procedure report"
          },
          {
            "code" : "734163000",
            "display" : "Care Plan"
          },
          {
            "code" : "440545006",
            "display" : "Prescription record"
          },
          {
            "code" : "184216000",
            "display" : "Patient record type"
          },
          {
            "code" : "371537001",
            "display" : "Consent report"
          },
          {
            "code" : "371538006",
            "display" : "Advance directive report"
          },
          {
            "code" : "722160009",
            "display" : "Audit trail report"
          },
          {
            "code" : "722216001",
            "display" : "Emergency medical identification record"
          },
          {
            "code" : "772790007",
            "display" : "Organ donor card"
          },
          {
            "code" : "405624007",
            "display" : "Administrative documentation"
          },
          {
            "code" : "417319006",
            "display" : "Record of health event"
          },
          {
            "code" : "419891008",
            "display" : "Record artifact"
          }
        ]
      }
    ]
  }
}

```
