# CZ DocumentEntry AuthorRole ValueSet - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ DocumentEntry AuthorRole ValueSet**

## ValueSet: CZ DocumentEntry AuthorRole ValueSet 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/ValueSet/cz-documentEntry-authorRole-vs | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_DocumentEntryAuthorRoleVs |

 
Document author role codes. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include all codes defined in [`https://hl7.cz/fhir/hie/CodeSystem/cz-documentEntry-authorRole-cs`](CodeSystem-cz-documentEntry-authorRole-cs.md)version 📦0.0.1

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-documentEntry-authorRole-vs",
  "url" : "https://hl7.cz/fhir/hie/ValueSet/cz-documentEntry-authorRole-vs",
  "version" : "0.0.1",
  "name" : "CZ_DocumentEntryAuthorRoleVs",
  "title" : "CZ DocumentEntry AuthorRole ValueSet",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Document author role codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://hl7.cz/fhir/hie/CodeSystem/cz-documentEntry-authorRole-cs"
      }
    ]
  }
}

```
