# CZ Unique ID Identifier - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Unique ID Identifier**

## Data Type Profile: CZ Unique ID Identifier 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/StructureDefinition/cz-uniqueIDIdentifier | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_UniqueIDIdentifier |

 
CZ FHIR profile holding the XDSDocumentEntry.uniqueId. 

**Usages:**

* Use this DataType Profile: [CZ Document Audit Event](StructureDefinition-cz-documentAuditEvent.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hie|current/StructureDefinition/cz-uniqueIDIdentifier)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-uniqueIDIdentifier.csv), [Excel](StructureDefinition-cz-uniqueIDIdentifier.xlsx), [Schematron](StructureDefinition-cz-uniqueIDIdentifier.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-uniqueIDIdentifier",
  "url" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-uniqueIDIdentifier",
  "version" : "0.0.1",
  "name" : "CZ_UniqueIDIdentifier",
  "title" : "CZ Unique ID Identifier",
  "status" : "draft",
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ FHIR profile holding the XDSDocumentEntry.uniqueId.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Identifier",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Identifier",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Identifier.system",
        "path" : "Identifier.system",
        "min" : 1,
        "patternUri" : "urn:ihe:iti:xds:2013:uniqueId"
      },
      {
        "id" : "Identifier.value",
        "path" : "Identifier.value",
        "short" : "XDSDocumentEntry.uniqueId",
        "min" : 1
      }
    ]
  }
}

```
