# CZ MHD SubmissionSet Comprehensive - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ MHD SubmissionSet Comprehensive**

## Resource Profile: CZ MHD SubmissionSet Comprehensive 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-submissionset-comprehensive | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_MhdSubmissionSetComprehensive |

 
CZ MHD SubmissionSet Comprehensive 

**Usages:**

* Use this Profile: [CZ MHD Find Document Lists Comprehensive Response Message](StructureDefinition-cz-mhd-finddocumentlists-comprehensive-bundle.md) and [CZ MHD Provide Document Bundle Comprehensive](StructureDefinition-cz-mhd-providedocumentbundle-comprehensive.md)
* CapabilityStatements using this Profile: [MHD Document Consumer (client)](CapabilityStatement-CZ-MHD-DocumentConsumer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hie|current/StructureDefinition/cz-mhd-submissionset-comprehensive)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-mhd-submissionset-comprehensive.csv), [Excel](StructureDefinition-cz-mhd-submissionset-comprehensive.xlsx), [Schematron](StructureDefinition-cz-mhd-submissionset-comprehensive.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-mhd-submissionset-comprehensive",
  "url" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-submissionset-comprehensive",
  "version" : "0.0.1",
  "name" : "CZ_MhdSubmissionSetComprehensive",
  "title" : "CZ MHD SubmissionSet Comprehensive",
  "status" : "draft",
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ MHD SubmissionSet Comprehensive",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "SubmissionSet-Mapping",
      "uri" : "XDS",
      "name" : "XDS and MHD Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "List",
  "baseDefinition" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.SubmissionSet",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "List.extension:sourceId",
        "path" : "List.extension",
        "sliceName" : "sourceId",
        "mustSupport" : true
      },
      {
        "id" : "List.identifier",
        "path" : "List.identifier",
        "short" : "identifier, for uniqueID set use to usual"
      },
      {
        "id" : "List.subject",
        "path" : "List.subject",
        "comment" : "Not a contained resource. The identifier points to an existing patient in the XDS Affinity Domain."
      },
      {
        "id" : "List.subject.identifier",
        "path" : "List.subject.identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-rid-identifier"
            ]
          }
        ]
      },
      {
        "id" : "List.source.extension:authorOrg",
        "path" : "List.source.extension",
        "sliceName" : "authorOrg",
        "max" : "0"
      },
      {
        "id" : "List.entry",
        "path" : "List.entry",
        "min" : 1
      },
      {
        "id" : "List.entry.item",
        "path" : "List.entry.item",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-documentreference-comprehensive"
            ],
            "aggregation" : ["referenced", "bundled"]
          }
        ]
      }
    ]
  }
}

```
