# CZ MHD Provide Document Bundle Comprehensive - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ MHD Provide Document Bundle Comprehensive**

## Resource Profile: CZ MHD Provide Document Bundle Comprehensive 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-providedocumentbundle-comprehensive | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_MhdProvideDocumentBundleComprehensive |

 
IHE MHD profile on Provide Document Bundle (ITI-65) transaction with Comprehensive Metadata for the Czech national interoperability standards. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hie|current/StructureDefinition/cz-mhd-providedocumentbundle-comprehensive)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-mhd-providedocumentbundle-comprehensive.csv), [Excel](StructureDefinition-cz-mhd-providedocumentbundle-comprehensive.xlsx), [Schematron](StructureDefinition-cz-mhd-providedocumentbundle-comprehensive.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-mhd-providedocumentbundle-comprehensive",
  "url" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-providedocumentbundle-comprehensive",
  "version" : "0.0.1",
  "name" : "CZ_MhdProvideDocumentBundleComprehensive",
  "title" : "CZ MHD Provide Document Bundle Comprehensive",
  "status" : "draft",
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "IHE MHD profile on Provide Document Bundle (ITI-65) transaction with Comprehensive Metadata for the Czech national interoperability standards.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.ProvideBundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle"
      },
      {
        "id" : "Bundle.meta",
        "path" : "Bundle.meta",
        "min" : 1
      },
      {
        "id" : "Bundle.meta.profile",
        "path" : "Bundle.meta.profile",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Bundle.meta.profile:comprehensiveMetadata",
        "path" : "Bundle.meta.profile",
        "sliceName" : "comprehensiveMetadata",
        "min" : 1,
        "max" : "1",
        "patternCanonical" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.ProvideBundle"
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "min" : 3
      },
      {
        "id" : "Bundle.entry:SubmissionSet",
        "path" : "Bundle.entry",
        "sliceName" : "SubmissionSet"
      },
      {
        "id" : "Bundle.entry:SubmissionSet.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "List",
            "profile" : [
              "https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-submissionset-comprehensive"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:SubmissionSet.request",
        "path" : "Bundle.entry.request",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:SubmissionSet.request.method",
        "path" : "Bundle.entry.request.method",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:DocumentRefs",
        "path" : "Bundle.entry",
        "sliceName" : "DocumentRefs",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:DocumentRefs.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DocumentReference",
            "profile" : [
              "https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-documentreference-comprehensive"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:DocumentRefs.request",
        "path" : "Bundle.entry.request",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:DocumentRefs.request.method",
        "path" : "Bundle.entry.request.method",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:Documents",
        "path" : "Bundle.entry",
        "sliceName" : "Documents",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:Documents.resource",
        "path" : "Bundle.entry.resource",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:Documents.request",
        "path" : "Bundle.entry.request",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:Documents.request.method",
        "path" : "Bundle.entry.request.method",
        "patternCode" : "POST",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:Folders",
        "path" : "Bundle.entry",
        "sliceName" : "Folders",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:Patient",
        "path" : "Bundle.entry",
        "sliceName" : "Patient",
        "max" : "0"
      }
    ]
  }
}

```
