# CZ MHD Find Document References Comprehensive Response message - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ MHD Find Document References Comprehensive Response message**

## Resource Profile: CZ MHD Find Document References Comprehensive Response message 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-finddocumentreference-comprehensive-bundle | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_FindDocumentReferencesComprehensiveResponse |

 
A profile on the Find Document References Comprehensive Response message (ITI-67) 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hie|current/StructureDefinition/cz-mhd-finddocumentreference-comprehensive-bundle)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-mhd-finddocumentreference-comprehensive-bundle.csv), [Excel](StructureDefinition-cz-mhd-finddocumentreference-comprehensive-bundle.xlsx), [Schematron](StructureDefinition-cz-mhd-finddocumentreference-comprehensive-bundle.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-mhd-finddocumentreference-comprehensive-bundle",
  "url" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-finddocumentreference-comprehensive-bundle",
  "version" : "0.0.1",
  "name" : "CZ_FindDocumentReferencesComprehensiveResponse",
  "title" : "CZ MHD Find Document References Comprehensive Response message",
  "status" : "draft",
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "A profile on the Find Document References Comprehensive Response message (ITI-67)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle"
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "fixedCode" : "searchset"
      },
      {
        "id" : "Bundle.total",
        "path" : "Bundle.total",
        "min" : 1
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resource"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1,
        "constraint" : [
          {
            "key" : "cz-mhd-bdl-1",
            "severity" : "error",
            "human" : "The fullUrl must be an absolute URL server address or an URI for UUID/OID",
            "expression" : "startsWith('http') or startsWith('urn:uuid:') = true",
            "source" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-finddocumentreference-comprehensive-bundle"
          }
        ]
      },
      {
        "id" : "Bundle.entry:DocumentReference",
        "path" : "Bundle.entry",
        "sliceName" : "DocumentReference",
        "short" : "DocumentReference",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:DocumentReference.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "DocumentReference",
            "profile" : [
              "https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-documentreference-comprehensive"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:OperationOutcome",
        "path" : "Bundle.entry",
        "sliceName" : "OperationOutcome",
        "short" : "OperationOutcome",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:OperationOutcome.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "OperationOutcome",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/OperationOutcome"]
          }
        ]
      }
    ]
  }
}

```
