# CZ Document Audit Event - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Document Audit Event**

## Resource Profile: CZ Document Audit Event 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/StructureDefinition/cz-documentAuditEvent | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_DocumentAuditEvent |

 
CZ FHIR profile on AuditEvent for document. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hie|current/StructureDefinition/cz-documentAuditEvent)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-documentAuditEvent.csv), [Excel](StructureDefinition-cz-documentAuditEvent.xlsx), [Schematron](StructureDefinition-cz-documentAuditEvent.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-documentAuditEvent",
  "url" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-documentAuditEvent",
  "version" : "0.0.1",
  "name" : "CZ_DocumentAuditEvent",
  "title" : "CZ Document Audit Event",
  "status" : "draft",
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ FHIR profile on AuditEvent for document.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "dicom",
      "uri" : "http://nema.org/dicom",
      "name" : "DICOM Tag Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    },
    {
      "identity" : "fhirprovenance",
      "uri" : "http://hl7.org/fhir/provenance",
      "name" : "FHIR Provenance Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AuditEvent",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/AuditEvent",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AuditEvent",
        "path" : "AuditEvent"
      },
      {
        "id" : "AuditEvent.type",
        "path" : "AuditEvent.type",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/ValueSet/audit-event-type"
        }
      },
      {
        "id" : "AuditEvent.subtype",
        "path" : "AuditEvent.subtype",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "AuditEvent.subtype:DocumentAuditEventType",
        "path" : "AuditEvent.subtype",
        "sliceName" : "DocumentAuditEventType",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/hie/ValueSet/cz-documentAuditEvent-type-vs"
        }
      },
      {
        "id" : "AuditEvent.recorded",
        "path" : "AuditEvent.recorded",
        "short" : "Event Date and Time"
      },
      {
        "id" : "AuditEvent.purposeOfEvent",
        "path" : "AuditEvent.purposeOfEvent",
        "short" : "Purpose of Event",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/hie/ValueSet/cz-purposeOfUse-vs"
        }
      },
      {
        "id" : "AuditEvent.agent",
        "path" : "AuditEvent.agent",
        "short" : "Participants",
        "max" : "1"
      },
      {
        "id" : "AuditEvent.agent.role",
        "path" : "AuditEvent.agent.role",
        "short" : "role (PAT, HCP, GRP)",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/hie/ValueSet/cz-participants-vs"
        }
      },
      {
        "id" : "AuditEvent.agent.who.identifier",
        "path" : "AuditEvent.agent.who.identifier",
        "short" : "Identifier if applicable",
        "min" : 1
      },
      {
        "id" : "AuditEvent.agent.name",
        "path" : "AuditEvent.agent.name",
        "short" : "Name"
      },
      {
        "id" : "AuditEvent.agent.requestor",
        "path" : "AuditEvent.agent.requestor",
        "short" : "If participant is Initiator"
      },
      {
        "id" : "AuditEvent.entity",
        "path" : "AuditEvent.entity",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "role.code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "AuditEvent.entity:Patient",
        "path" : "AuditEvent.entity",
        "sliceName" : "Patient",
        "short" : "Patient",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AuditEvent.entity:Patient.what.identifier",
        "path" : "AuditEvent.entity.what.identifier",
        "short" : "RID",
        "min" : 1
      },
      {
        "id" : "AuditEvent.entity:Document",
        "path" : "AuditEvent.entity",
        "sliceName" : "Document",
        "short" : "Document",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AuditEvent.entity:Document.what.identifier",
        "path" : "AuditEvent.entity.what.identifier",
        "short" : "XDSDocumentEntry.uniqueId",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://hl7.cz/fhir/hie/StructureDefinition/cz-uniqueIDIdentifier"
            ]
          }
        ]
      },
      {
        "id" : "AuditEvent.entity:Document.detail",
        "path" : "AuditEvent.entity.detail",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Title",
        "min" : 3
      },
      {
        "id" : "AuditEvent.entity:Document.detail:repositoryUniqueId",
        "path" : "AuditEvent.entity.detail",
        "sliceName" : "repositoryUniqueId",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AuditEvent.entity:Document.detail:DocumentType",
        "path" : "AuditEvent.entity.detail",
        "sliceName" : "DocumentType",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AuditEvent.entity:Document.detail:Title",
        "path" : "AuditEvent.entity.detail",
        "sliceName" : "Title",
        "min" : 1,
        "max" : "1"
      }
    ]
  }
}

```
