# CZ Participants CodeSystem - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Participants CodeSystem**

## CodeSystem: CZ Participants CodeSystem 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/CodeSystem/cz-participants-cs | *Version*:0.0.1 |
| Active as of 2025-01-17 | *Computable Name*:CZ_ParticipantsCs |

 
Codesystem for participant code. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CZ_ParticipantsVs](ValueSet-cz-participants-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-participants-cs",
  "language" : "cs-CZ",
  "url" : "https://hl7.cz/fhir/hie/CodeSystem/cz-participants-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "CZ_ParticipantsCs",
  "title" : "CZ Participants CodeSystem",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-17",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Codesystem for participant code.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "PAT",
      "display" : "Pacient"
    },
    {
      "code" : "HCP",
      "display" : "Zdravotnický pracovník"
    },
    {
      "code" : "GRP",
      "display" : "Zdravotnická skupina"
    }
  ]
}

```
