# CZ DocumentEntry AuthorRole CodeSystem - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ DocumentEntry AuthorRole CodeSystem**

## CodeSystem: CZ DocumentEntry AuthorRole CodeSystem 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/CodeSystem/cz-documentEntry-authorRole-cs | *Version*:0.0.1 |
| Active as of 2025-01-17 | *Computable Name*:CZ_DocumentEntryAuthorRoleCs |

 
Codesystem for author role codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CZ_DocumentEntryAuthorRoleVs](ValueSet-cz-documentEntry-authorRole-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-documentEntry-authorRole-cs",
  "language" : "cs-CZ",
  "url" : "https://hl7.cz/fhir/hie/CodeSystem/cz-documentEntry-authorRole-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "CZ_DocumentEntryAuthorRoleCs",
  "title" : "CZ DocumentEntry AuthorRole CodeSystem",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-17",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Codesystem for author role codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "PAT",
      "display" : "Patient"
    },
    {
      "code" : "HCP",
      "display" : "Healthcare professional"
    },
    {
      "code" : "ORG",
      "display" : "Organization"
    }
  ]
}

```
