# CZ Audit Trail Consumption Event Types CodeSystem - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Audit Trail Consumption Event Types CodeSystem**

## CodeSystem: CZ Audit Trail Consumption Event Types CodeSystem 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/CodeSystem/cz-atc-cs | *Version*:0.0.1 |
| Active as of 2025-01-17 | *Computable Name*:CZ_ATCCs |

 
Codesystem for Audit Trail Consumption Event Types codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-atc-cs",
  "language" : "cs-CZ",
  "url" : "https://hl7.cz/fhir/hie/CodeSystem/cz-atc-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "CZ_ATCCs",
  "title" : "CZ Audit Trail Consumption Event Types CodeSystem",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-17",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Codesystem for Audit Trail Consumption Event Types codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 15,
  "concept" : [
    {
      "code" : "ATC_DOC_CREATE",
      "display" : "Document upload"
    },
    {
      "code" : "ATC_DOC_READ",
      "display" : "Document retrieval"
    },
    {
      "code" : "ATC_DOC_UPDATE",
      "display" : "Document or Document Metadata update"
    },
    {
      "code" : "ATC_DOC_DELETE",
      "display" : "Document removal"
    },
    {
      "code" : "ATC_DOC_SEARCH",
      "display" : "Document search"
    },
    {
      "code" : "ATC_POL_CREATE_AUT_PART_AL",
      "display" : "Authorize participants to access level/date"
    },
    {
      "code" : "ATC_POL_UPDATE_AUT_PART_AL",
      "display" : "Update access level/date of authorized participants"
    },
    {
      "code" : "ATC_POL_REMOVE_AUT_PART_AL",
      "display" : "Remove authorization for participants to access level/date"
    },
    {
      "code" : "ATC_POL_DEF_CONFLEVEL",
      "display" : "Set or update the default Confidentiality Level for new documents"
    },
    {
      "code" : "ATC_POL_DIS_EMER_USE",
      "display" : "Disabling Emergency Access"
    },
    {
      "code" : "ATC_POL_ENA_EMER_USE",
      "display" : "Enabling Emergency Access"
    },
    {
      "code" : "ATC_POL_INCL_BLACKLIST",
      "display" : "Assign a Healthcare Professional to Blacklist"
    },
    {
      "code" : "ATC_POL_EXL_BLACKLIST",
      "display" : "Exclude a Healthcare Professional from Blacklist"
    },
    {
      "code" : "ATC_LOG_READ",
      "display" : "Accessing the Patient Audit Record Repository"
    },
    {
      "code" : "ATC_HPD_GROUP_ENTRY_NOTIFY",
      "display" : "Entry of healthcare professionals into a group"
    }
  ]
}

```
