# MHD Document Source (client) - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **MHD Document Source (client)**

## CapabilityStatement: MHD Document Source (client) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/CapabilityStatement/CZ-MHD-DocumentSource | *Version*:0.0.1 |
| Active as of 2025-09-23 | *Computable Name*:CZ_MHD_DocumentSource |

 
CapabilityStatement for Actor MHD Document Source (client). 

 [Raw OpenAPI-Swagger Definition file](CZ-MHD-DocumentSource.openapi.json) | [Download](CZ-MHD-DocumentSource.openapi.json) 

## MHD Document Source (client)

* Implementation Guide Version: 0.0.1 
* FHIR Version: 4.0.1 
* Supported Formats: `application/fhir+xml`, `application/fhir+json`
* Published on: 2025-09-23 
* Published by: HL7 Czech Republic 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

## FHIR RESTful Capabilities

### Mode: client

MHD client sends documents and metadata to the Document Recipient [ITI-65].

**Security**

> 

TLS SHALL be used together with IUA extended access token


**Summary of System-wide Interactions**

* Supports the `transaction`interaction described as follows:

https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-providedocumentbundle-comprehensive




## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "CZ-MHD-DocumentSource",
  "url" : "https://hl7.cz/fhir/hie/CapabilityStatement/CZ-MHD-DocumentSource",
  "version" : "0.0.1",
  "name" : "CZ_MHD_DocumentSource",
  "title" : "MHD Document Source (client)",
  "status" : "active",
  "date" : "2025-09-23",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CapabilityStatement for Actor MHD Document Source (client).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["application/fhir+xml", "application/fhir+json"],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "MHD client sends documents and metadata to the Document Recipient [ITI-65].",
      "security" : {
        "cors" : false,
        "description" : "TLS SHALL be used together with IUA extended access token"
      },
      "interaction" : [
        {
          "code" : "transaction",
          "documentation" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-providedocumentbundle-comprehensive"
        }
      ]
    }
  ]
}

```
