# CZ-AuditEventIti65SourceExample - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-AuditEventIti65SourceExample**

## Example AuditEvent: CZ-AuditEventIti65SourceExample

Profile: [CZ Audit Event for [ITI-65] Document Source](StructureDefinition-cz-auditEventIti65Source.md)

**type**: DICOM 110106: Export

**subtype**: unknown ITI-65: Provide Document Bundle

**recorded**: 2024-10-28 09:43:56+0000

**outcome**: Success

> **agent****type**:Source Role ID**who**: Nemocnice XYZ**requestor**: false

### Networks

| | | |
| :--- | :--- | :--- |
| - | **Address** | **Type** |
| * | 192.168.1.1 | IP Address |


> **agent****type**:Destination Role ID**who**: Affinitní doména A**requestor**: false

### Networks

| | | |
| :--- | :--- | :--- |
| - | **Address** | **Type** |
| * | https://example.com | URI |


> **agent****type**:responsible party**role**:Healthcare professional**altId**: 2000000090092**name**: Mracena Mrakomorová**requestor**: true**purposeOfUse**:Normální přístup

### Sources

| | | |
| :--- | :--- | :--- |
| - | **Site** | **Observer** |
| * | 2.16.756.1.2.3 | Nemocnice XYZ |

> **entity****what**: Identifier:`https://ncez.mzcr.cz/fhir/sid/rid`/4567891235**type**:[Audit event entity type 1](http://terminology.hl7.org/6.5.0/CodeSystem-audit-entity-type.html#audit-entity-type-1): Person**role**:[AuditEventEntityRole 1](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html#object-role-1): Patient

> **entity****what**: Identifier:[Uniform Resource Identifier (URI)](http://terminology.hl7.org/5.3.0/NamingSystem-uri.html)/urn:oid:1.3.6.1.4.1.12559.11.13.2.6.2949**type**:[Audit event entity type 2](http://terminology.hl7.org/6.5.0/CodeSystem-audit-entity-type.html#audit-entity-type-2): System Object**role**:[AuditEventEntityRole 20](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html#object-role-20): Job

> **entity****what**: Identifier: 00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-00**type**:[Audit event entity type 4](http://terminology.hl7.org/6.5.0/CodeSystem-audit-entity-type.html#audit-entity-type-4): Other**role**:[AuditEventEntityRole 26](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html#object-role-26): Processing Element



## Resource Content

```json
{
  "resourceType" : "AuditEvent",
  "id" : "CZ-AuditEventIti65SourceExample",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti65Source"
    ]
  },
  "type" : {
    "system" : "http://dicom.nema.org/resources/ontology/DCM",
    "code" : "110106",
    "display" : "Export"
  },
  "subtype" : [
    {
      "system" : "urn:ihe:event-type-code",
      "code" : "ITI-65",
      "display" : "Provide Document Bundle"
    }
  ],
  "recorded" : "2024-10-28T09:43:56Z",
  "outcome" : "0",
  "agent" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "code" : "110153",
            "display" : "Source Role ID"
          }
        ]
      },
      "who" : {
        "display" : "Nemocnice XYZ"
      },
      "requestor" : false,
      "network" : {
        "address" : "192.168.1.1",
        "type" : "2"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "code" : "110152",
            "display" : "Destination Role ID"
          }
        ]
      },
      "who" : {
        "display" : "Affinitní doména A"
      },
      "requestor" : false,
      "network" : {
        "address" : "https://example.com",
        "type" : "5"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
            "code" : "RESP",
            "display" : "responsible party"
          }
        ]
      },
      "role" : [
        {
          "coding" : [
            {
              "system" : "https://hl7.cz/fhir/hie/CodeSystem/cz-documentEntry-authorRole-cs",
              "code" : "HCP"
            }
          ]
        }
      ],
      "altId" : "2000000090092",
      "name" : "Mracena Mrakomorová",
      "requestor" : true,
      "purposeOfUse" : [
        {
          "coding" : [
            {
              "system" : "https://hl7.cz/fhir/hie/CodeSystem/cz-purposeOfUse-cs",
              "code" : "NORM",
              "display" : "Normální přístup"
            }
          ]
        }
      ]
    }
  ],
  "source" : {
    "site" : "2.16.756.1.2.3",
    "observer" : {
      "display" : "Nemocnice XYZ"
    }
  },
  "entity" : [
    {
      "what" : {
        "identifier" : {
          "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
          "value" : "4567891235"
        }
      },
      "type" : {
        "system" : "http://terminology.hl7.org/CodeSystem/audit-entity-type",
        "code" : "1",
        "display" : "Person"
      },
      "role" : {
        "system" : "http://terminology.hl7.org/CodeSystem/object-role",
        "code" : "1",
        "display" : "Patient"
      }
    },
    {
      "what" : {
        "identifier" : {
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:1.3.6.1.4.1.12559.11.13.2.6.2949"
        }
      },
      "type" : {
        "system" : "http://terminology.hl7.org/CodeSystem/audit-entity-type",
        "code" : "2",
        "display" : "System Object"
      },
      "role" : {
        "system" : "http://terminology.hl7.org/CodeSystem/object-role",
        "code" : "20",
        "display" : "Job"
      }
    },
    {
      "what" : {
        "identifier" : {
          "value" : "00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-00"
        }
      },
      "type" : {
        "system" : "http://terminology.hl7.org/CodeSystem/audit-entity-type",
        "code" : "4",
        "display" : "Other"
      },
      "role" : {
        "system" : "http://terminology.hl7.org/CodeSystem/object-role",
        "code" : "26",
        "display" : "Processing Element"
      }
    }
  ]
}

```
