# A - Prescription - HL7 Europe Medication Prescription and Dispense v0.1.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A - Prescription**

## Logical Model: A - Prescription 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/mpd/StructureDefinition/Prescription | *Version*:0.1.0-ci-build |
| Draft as of 2025-12-30 | *Computable Name*:EprescriptionEhn |
| **Copyright/Legal**: Used by permission of HL7 Europe, all rights reserved Creative Commons License | |

 
Prescription. Several Sections of the eHN guideline. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.mpd|current/StructureDefinition/Prescription)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Prescription.csv), [Excel](StructureDefinition-Prescription.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Prescription",
  "url" : "http://hl7.eu/fhir/mpd/StructureDefinition/Prescription",
  "version" : "0.1.0-ci-build",
  "name" : "EprescriptionEhn",
  "title" : "A - Prescription",
  "status" : "draft",
  "date" : "2025-12-30T11:46:09+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "Prescription. Several Sections of the eHN guideline.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 Europe, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/mpd/StructureDefinition/Prescription",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Prescription",
        "path" : "Prescription",
        "short" : "A - Prescription",
        "definition" : "Prescription. Several Sections of the eHN guideline."
      },
      {
        "id" : "Prescription.patient",
        "path" : "Prescription.patient",
        "short" : "A.1.1 Patient administrative data",
        "definition" : "Patient administrative data",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/mpd/StructureDefinition/Subject"
          }
        ]
      },
      {
        "id" : "Prescription.authentication",
        "path" : "Prescription.authentication",
        "short" : "A.1.2 Authentication of the prescription",
        "definition" : "Authentication of the prescription",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Prescription.authentication.identifier",
        "path" : "Prescription.authentication.identifier",
        "short" : "A.1.2.1 Identifier of the Prescription",
        "definition" : "A unique string generated by an EPS (Electronic Prescribing System) to \nuniquely identify a prescription; this unique code is needed for traceability. \nIt might be used to register whether a prescription, and/or the maximum \nnumber of repeats, has already been dispensed. The identifier can consist of \na root and an extension [ISO 21090:2011].",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Prescription.authentication.issueDate",
        "path" : "Prescription.authentication.issueDate",
        "short" : "A.1.2.2 Issue date",
        "definition" : "The date and optionally the time the prescription was issued.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Prescription.prescriber",
        "path" : "Prescription.prescriber",
        "short" : "A.1.3 Identification of the prescribing health professional",
        "definition" : "Identification of the prescribing health professional",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Prescription.prescriber.familyName",
        "path" : "Prescription.prescriber.familyName",
        "short" : "A.1.3.1 Familyname",
        "definition" : "The family name/surname/last name of the prescriber. This enables the prescriber to be traced in the event of questions or emergencies.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Prescription.prescriber.givenName",
        "path" : "Prescription.prescriber.givenName",
        "short" : "A.1.3.2 Given name",
        "definition" : "The given name/ first name of the prescriber. This enables the prescriber to be traced in the event of questions or emergencies.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Prescription.prescriber.qualification",
        "path" : "Prescription.prescriber.qualification",
        "short" : "A.1.3.3 Professional qualifications",
        "definition" : "The professional title of the prescribing health professional, which may be used to prove the authority of the prescriber.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Prescription.prescriber.contact",
        "path" : "Prescription.prescriber.contact",
        "short" : "A.1.3.4 Details for direct contact",
        "definition" : "Details for direct contact could be an email address and/or phone/fax number of the prescriber in order for the dispenser and/or patient to contact  the prescriber. This might be necessary if problems arise with dosage, allergies, reimbursement etc.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "Prescription.prescriber.workAddress",
        "path" : "Prescription.prescriber.workAddress",
        "short" : "A.1.3.5 Work address",
        "definition" : "This is the address of the hospital or the practice, etc. where the health professional normally works, meets patients and prescribes medication. Minimally, the country should be specified.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "Prescription.prescriber.signature",
        "path" : "Prescription.prescriber.signature",
        "short" : "A.1.3.6 Signature",
        "definition" : "Digital signature or token as proof of the authenticity of the prescriber.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Signature"
          }
        ]
      },
      {
        "id" : "Prescription.prescriber.identifier",
        "path" : "Prescription.prescriber.identifier",
        "short" : "A.1.3.7  Health care provider identifier",
        "definition" : "A unique number or code issued for the purpose of identifying a health care provider [ISO/TS 27527:2010]; this may be a licence or registration number which can be used to trace the prescriber and to check whether a medicinal product was prescribed by the right person according to the law of the prescribing country.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Prescription.product",
        "path" : "Prescription.product",
        "short" : "A1.4 Identification of the prescribed product",
        "definition" : "Identification of the prescribed product",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/mpd/StructureDefinition/MedicinalProduct"
          }
        ]
      },
      {
        "id" : "Prescription.details",
        "path" : "Prescription.details",
        "short" : "A.1.5 Prescription information",
        "definition" : "Prescription information",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Prescription.details.quantity",
        "path" : "Prescription.details.quantity",
        "short" : "A.1.5.2 Quantity of prescribed product",
        "definition" : "Total quantity or volume of the medicinal product that is prescribed to the specific patient. It can be provided as number of packages, given that the pack size is sufficiently described, or it can be the overall amount in appropriate units of measure (UCUM) or units of presentation (EDQM) (ml, g, tablets, vials).\nDepending on national legislation, this quantity may or may not be dispensed in one dispensation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Quantity"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "UCUM, EDQM"
        }
      },
      {
        "id" : "Prescription.details.doseRegimen",
        "path" : "Prescription.details.doseRegimen",
        "short" : "A.1.5.3 Dose regimen",
        "definition" : "The regimen governing the dose quantity per single administration, the dose frequency, and/or speed of administration (in the event of intravenous administration).\nNote: this information may be used by the dispenser to calculate the quantity to be dispensed.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Prescription.details.doseRegimen.unitsPerIntake",
        "path" : "Prescription.details.doseRegimen.unitsPerIntake",
        "short" : "A.1.5.3.1 Number of units per intake",
        "definition" : "The number of units per intake that the patient is taking. \nExample: 1 tablet",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Quantity"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "UCUM, EDQM"
        }
      },
      {
        "id" : "Prescription.details.doseRegimen.frequencyOfIntakes",
        "path" : "Prescription.details.doseRegimen.frequencyOfIntakes",
        "short" : "A.1.5.3.2 Frequency of intakes",
        "definition" : "Frequency of intakes per hour/day/week/month. \nExample: every 24 hours. Preferred codesystems UCUM, HL7 TimingEvent",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Prescription.details.route",
        "path" : "Prescription.details.route",
        "short" : "A.1.5.4 Route of administration",
        "definition" : "The route of administration as prescribed. \nExample: oral intake",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "EDQM"
        }
      },
      {
        "id" : "Prescription.details.duration",
        "path" : "Prescription.details.duration",
        "short" : "A.1.5.5 Duration of treatment",
        "definition" : "The duration of the treatment as indicated by the Prescriber. Example: 14 days. \nCan be left blank for long-term therapies.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Quantity"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "UCUM"
        }
      },
      {
        "id" : "Prescription.details.startDate",
        "path" : "Prescription.details.startDate",
        "short" : "A.1.5.6 Starting date of therapy",
        "definition" : "The time and date on which it is agreed that therapy will start. \n - Preferred system(s): ISO 8601",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Prescription.details.directionsOfUse",
        "path" : "Prescription.details.directionsOfUse",
        "short" : "A.1.5.7 Directions for use",
        "definition" : "Information about the directions for use of the prescribed medicinal product (such as ?with food? or ?before a meal?) and any cautionary advice for correct use of the prescribed medicinal product by the patient.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "HL7 TimingEvent"
        }
      },
      {
        "id" : "Prescription.details.expiryDate",
        "path" : "Prescription.details.expiryDate",
        "short" : "A.1.5.8 Prescription expiry date",
        "definition" : "This might be dependent on local or national policy or legislation, in accordance with the treatment plan or because the therapeutic need for the prescribed medicine has expired.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Prescription.details.repeats",
        "path" : "Prescription.details.repeats",
        "short" : "A.1.5.9 Repeats",
        "definition" : "In some countries, when medicinal products are dispensed for the first time, \nthe patient may only receive medication for a short period of time. When a \npatient starts taking medication for a chronic illness, the prescriber can issue a prescription for a longer period that is now separated by repeats. In addition, the maximum quantity (A.1.4.3) of the prescribed product that may be dispensed in one dispensation may be stated here.\nDecision on dispensability is made in the country of prescription.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "Prescription.details.reason",
        "path" : "Prescription.details.reason",
        "short" : "A.1.5.10 Reason for prescription",
        "definition" : "The reason why the medicine is being prescribed, including the option to mention that the medicinal product is being prescribed for ?off label? use. \nThe reason for the prescription gives the dispenser the opportunity to review the prescription for medication safety issues.\nNote: in some countries it is obligatory to state the reason for prescription on the prescription itself for some or all medicinal products.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Prescription.details.substitution",
        "path" : "Prescription.details.substitution",
        "short" : "A.1.5.11 Substitution",
        "definition" : "Substitution handling can be recorded to indicate whether and to what extent substitution is allowed by the prescriber.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
