# Authors and Contributors - HL7 Europe Medication Prescription and Dispense v0.1.0-ci-build

* [**Table of Contents**](toc.md)
* **Authors and Contributors**

## Authors and Contributors

HL7 Europe's Medication Prescription and Dispense FHIR Implementation Guide is a result of cross-project, cross-SDO and volunteer community collaboration. The working group included over 100 participants from over 20 countries.

**Major contributors and their roles**:

* **IHE Pharmacy** started their MPD IG (FHIR R5) for IHE profile before HL7 Europe's initiative, and a lot of their work was used as the starting point for the European IG. As IHE IG has a global scope, HL7 Europe's MPD IG uses their extensions for R5.
* **XpanDH project** experimented with the future European data exchange format, and this IG is a direct successor to XpanDH work which was funded by EU.
* **Xt-EHR project** is responsible for preparing implementing acts for the EHDS regulation. This includes the exact data sets and technical specifications. In order to work together with other EU projects, their profiling team joined the HL7 Europe working group. The profiles in this IG are based on Xt-EHR logical information models.
* **MyHealth@EU solution provider** has provided their insight into EU crossborder data exchange. eP and eD are operational crossborder services in Europe, and even though they use HL7 CDA for the moment, the participation of the solution provider guarantees that the FHIR specification will be adoptable and adaptable for crossborder use case.
* **HL7 Pharmacy** provides guidance on how Medication module resources are meant to be used, but also processes the implementers' feedback from the group. The working group has filed multiple change requests to FHIR core specification. These change requests are mostly processed by HL7 Pharmacy.
* **HL7 Europe** provides a project-agnostic platform for collaborative work and carries out the technical and administrative tasks regarding HL7 Europe's IGs. The MPD IGs also have a dependency on HL7 Europe's Base Profiles IG, which is authored by another similar working group.
* **Community of volunteers**, including EHR vendors, data exchange regulators, implementers, and other enthusiastic people from all over Europe and even beyond.

