# 200A-multiitem-prescription-without-orchestration - HL7 Europe Medication Prescription and Dispense v0.1.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **200A-multiitem-prescription-without-orchestration**

## Example Bundle: 200A-multiitem-prescription-without-orchestration



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "200A-multiitem-prescription-without-orchestration",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "https://example.com/MedicationRequest/200C-2-medication-prescription-request2",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "200C-2-medication-prescription-request2",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/mpd/StructureDefinition/MedicationRequest-eu-mpd"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_200C-2-medication-prescription-request2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest 200C-2-medication-prescription-request2</b></p><a name=\"200C-2-medication-prescription-request2\"> </a><a name=\"hc200C-2-medication-prescription-request2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationRequest-eu-mpd.html\">MedicationRequest: MPD</a></p></div><p><b>identifier</b>: 200-2/2</p><p><b>status</b>: Active</p><p><b>intent</b>: Order</p><p><b>medication</b>: <span title=\"Codes:{http://snomed.info/sct 374647008}\">Amoxicillin 875 mg oral tablet</span></p><p><b>subject</b>: <a href=\"Patient-patient1.html\">Thomas Engine  Male, DoB: 1950-09-15 ( 12345)</a></p><p><b>authoredOn</b>: 2024-10-06</p><p><b>requester</b>: <a href=\"PractitionerRole-doctor1.html\">PractitionerRole Clinical oncologist</a></p><p><b>reasonCode</b>: <span title=\"Codes:{http://snomed.info/sct 88348008}\">Maxillary sinusitis</span></p><p><b>groupIdentifier</b>: 200</p><blockquote><p><b>dosageInstruction</b></p><p><b>timing</b>: 2 per 1 day</p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: SNOMED CT  code732936001 = 'Tablet (unit of presentation)')</span></td></tr></table></blockquote><h3>DispenseRequests</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ValidityPeriod</b></td><td><b>NumberOfRepeatsAllowed</b></td><td><b>Quantity</b></td></tr><tr><td style=\"display: none\">*</td><td>2024-10-06 --&gt; 2024-12-06</td><td>1</td><td>14 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: SNOMED CT  code732936001 = 'Tablet (unit of presentation)')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "value" : "200-2/2"
          }
        ],
        "status" : "active",
        "intent" : "order",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "374647008",
              "display" : "Amoxicillin 875 mg oral tablet"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/patient1"
        },
        "authoredOn" : "2024-10-06",
        "requester" : {
          "reference" : "PractitionerRole/doctor1"
        },
        "reasonCode" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "88348008",
                "display" : "Maxillary sinusitis"
              }
            ]
          }
        ],
        "groupIdentifier" : {
          "value" : "200"
        },
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "boundsDuration" : {
                  "value" : 7,
                  "unit" : "day",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "d"
                },
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Tablet",
                  "system" : "http://snomed.info/sct",
                  "code" : "732936001"
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "validityPeriod" : {
            "start" : "2024-10-06",
            "end" : "2024-12-06"
          },
          "numberOfRepeatsAllowed" : 1,
          "quantity" : {
            "value" : 14,
            "unit" : "Tablet",
            "system" : "http://snomed.info/sct",
            "code" : "732936001"
          }
        }
      }
    },
    {
      "fullUrl" : "https://example.com/PractitionerRole/doctor1",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "doctor1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_doctor1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole doctor1</b></p><a name=\"doctor1\"> </a><a name=\"hcdoctor1\"> </a><p><b>practitioner</b>: <a href=\"Practitioner-practitioner1.html\">Dr Meryl Ärztin</a></p><p><b>organization</b>: <a href=\"Organization-organization1.html\">Dr Ärztin Private Practice</a></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 309295000}\">Clinical oncologist</span></p></div>"
        },
        "practitioner" : {
          "reference" : "Practitioner/practitioner1",
          "display" : "Dr Meryl Ärztin"
        },
        "organization" : {
          "reference" : "Organization/organization1",
          "display" : "Dr Ärztin Private Practice"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "309295000",
                "display" : "Clinical oncologist"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://example.com/Patient/patient1",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "patient1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_patient1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient patient1</b></p><a name=\"patient1\"> </a><a name=\"hcpatient1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.eu/fhir/base/0.1.0-ballot/StructureDefinition-patient-eu-core.html\">Patient (EU core)</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Thomas Engine  Male, DoB: 1950-09-15 ( 12345)</p><hr/></div>"
        },
        "identifier" : [
          {
            "value" : "12345"
          }
        ],
        "name" : [
          {
            "family" : "Engine",
            "given" : ["Thomas"]
          }
        ],
        "gender" : "male",
        "birthDate" : "1950-09-15"
      }
    }
  ]
}

```
