# 05A-Tilidin-Branded - HL7 Europe Medication Prescription and Dispense v0.1.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **05A-Tilidin-Branded**

## Example Medication: 05A-Tilidin-Branded

Profile: [Medication: MPD](StructureDefinition-Medication-eu-mpd.md)

**Medication - Classification**: Other opioids

**Medication - Product Name**: Tilidin HEXAL® comp Lösung, 50/4 mg je 0,72 ml Tropfen zum Einnehmen, Lösung

**Medication - Unit of presentation**: Drop

**identifier**: 12345

**marketingAuthorizationHolder**: Hexal AG

**doseForm**: Oral drops, solution

**totalVolume**: 10 milliliter(Details: UCUM codemL = 'mL')

> **ingredient**

### Items

| | |
| :--- | :--- |
| - | **Concept** |
| * | Tilidine |

**isActive**: true**strength**: 50 milligram(Details: UCUM codemg = 'mg')/20 Drop(Details: EDQM Standard Terms code15022000 = 'Drop')

> **ingredient**

### Items

| | |
| :--- | :--- |
| - | **Concept** |
| * | Naloxone |

**isActive**: true**strength**: 4 milligram(Details: UCUM codemg = 'mg')/20 Drop(Details: EDQM Standard Terms code15022000 = 'Drop')



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "05A-Tilidin-Branded",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/mpd-r5/StructureDefinition/Medication-eu-mpd"
    ]
  },
  "extension" : [
    {
      "url" : "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-classification",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.whocc.no/atc",
            "version" : "2025",
            "code" : "N02AX",
            "display" : "Other opioids"
          }
        ]
      }
    },
    {
      "url" : "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-productname",
      "valueString" : "Tilidin HEXAL® comp Lösung, 50/4 mg je 0,72 ml Tropfen zum Einnehmen, Lösung"
    },
    {
      "url" : "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-unitofpresentation",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://standardterms.edqm.eu",
            "code" : "15022000",
            "display" : "Drop"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "value" : "12345"
    }
  ],
  "marketingAuthorizationHolder" : {
    "display" : "Hexal AG"
  },
  "doseForm" : {
    "coding" : [
      {
        "system" : "http://standardterms.edqm.eu",
        "code" : "10101000",
        "display" : "Oral drops, solution"
      }
    ]
  },
  "totalVolume" : {
    "value" : 10,
    "unit" : "milliliter",
    "system" : "http://unitsofmeasure.org",
    "code" : "mL"
  },
  "ingredient" : [
    {
      "item" : {
        "concept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "373562008",
              "display" : "Tilidine"
            }
          ]
        }
      },
      "isActive" : true,
      "strengthRatio" : {
        "extension" : [
          {
            "url" : "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-strengthsubstance",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "96186004",
                  "display" : "Tilidine hydrochloride"
                }
              ]
            }
          }
        ],
        "numerator" : {
          "value" : 50,
          "unit" : "milligram",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg"
        },
        "denominator" : {
          "value" : 20,
          "unit" : "Drop",
          "system" : "http://standardterms.edqm.eu",
          "code" : "15022000"
        }
      }
    },
    {
      "item" : {
        "concept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "372890007",
              "display" : "Naloxone"
            }
          ]
        }
      },
      "isActive" : true,
      "strengthRatio" : {
        "extension" : [
          {
            "url" : "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-strengthsubstance",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "21518006",
                  "display" : "Naloxone hydrochloride"
                }
              ]
            }
          }
        ],
        "numerator" : {
          "value" : 4,
          "unit" : "milligram",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg"
        },
        "denominator" : {
          "value" : 20,
          "unit" : "Drop",
          "system" : "http://standardterms.edqm.eu",
          "code" : "15022000"
        }
      }
    }
  ]
}

```
