# KR Core Observation Profile for Vital Signs - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Observation Profile for Vital Signs**

## Resource Profile: KR Core Observation Profile for Vital Signs 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-vitalsigns | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_Observation_VitalSigns |

 
KR Core Observation Profile for Vital Signs는 KR Core Server와 KR Core Client의 진료정보를 교류할 때 환자를 대상으로하는 다양한 활력징후 및 신체 계측 정보를 일관되게 표현하는데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 단, 아래의 목록에 해당하는 활력징후 및 신체 계측 정보는 본 Profile을 상속하여 정의한 세부 Profile들을**반드시(SHALL)**적용해야 한다. 아래의 세부 Profile들을 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다. 
* 활력징후 및 신체 계측 정보별 세부 Profile 목록 
* 수축기 혈압 및 이완기 혈압 - [KR Core Observation Profile for Vital Signs: Blood Pressure](StructureDefinition-krcore-bloodpressure.md)
* 키 - [KR Core Observation Profile for Vital Signs: Body Height](StructureDefinition-krcore-bodyheight.md)
* 체온 - [KR Core Observation Profile for Vital Signs: Body Temperature](StructureDefinition-krcore-bodytemperature.md)
* 몸무게 - [KR Core Observation Profile for Vital Signs: Body Weight](StructureDefinition-krcore-bodyweight.md)
* 맥박수 - [KR Core Observation Profile for Vital Signs: Heart Rate](StructureDefinition-krcore-heartrate.md)
* 산소포화도 - [KR Core Observation Profile for Vital Signs: Pulse Oximetry](StructureDefinition-krcore-pulseoximeter.md)
* 호흡수 - [KR Core Observation Profile for Vital Signs: Respiratory Rate](StructureDefinition-krcore-respiratoryrate.md)
 
 
※ 주의사항 
* KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 

 
환자를 대상으로하는 활력 징후 및 신체 계측 정보를 구조화하기 위해 정의한 범용 Profile. 

**Usages:**

* Derived from this Profile: [KR Core Observation Profile for Vital Signs: Blood Pressure](StructureDefinition-krcore-bloodpressure.md), [KR Core Observation Profile for Vital Signs: Body Height](StructureDefinition-krcore-bodyheight.md), [KR Core Observation Profile for Vital Signs: Body Temperature](StructureDefinition-krcore-bodytemperature.md), [KR Core Observation Profile for Vital Signs: Body Weight](StructureDefinition-krcore-bodyweight.md)...Show 3 more,[KR Core Observation Profile for Vital Signs: Heart Rate](StructureDefinition-krcore-heartrate.md),[KR Core Observation Profile for Vital Signs: Pulse Oximetry](StructureDefinition-krcore-pulseoximetry.md)and[KR Core Observation Profile for Vital Signs: Respiratory Rate](StructureDefinition-krcore-respiratoryrate.md)
* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-vitalsigns)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-vitalsigns.csv), [Excel](StructureDefinition-krcore-vitalsigns.xlsx), [Schematron](StructureDefinition-krcore-vitalsigns.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-vitalsigns",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-vitalsigns",
  "version" : "2.0.0",
  "name" : "KRCore_Observation_VitalSigns",
  "title" : "KR Core Observation Profile for Vital Signs",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Observation Profile for Vital Signs는 KR Core Server와 KR Core Client의 진료정보를 교류할 때 \n환자를 대상으로하는 다양한 활력징후 및 신체 계측 정보를 일관되게 표현하는데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n단, 아래의 목록에 해당하는 활력징후 및 신체 계측 정보는 본 Profile을 상속하여 정의한 세부 Profile들을 **반드시(SHALL)** 적용해야 한다.\n아래의 세부 Profile들을 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다.\n\n+ 활력징후 및 신체 계측 정보별 세부 Profile 목록\n  + 수축기 혈압 및 이완기 혈압 - [KR Core Observation Profile for Vital Signs: Blood Pressure](StructureDefinition-krcore-bloodpressure.html)\n  + 키 - [KR Core Observation Profile for Vital Signs: Body Height](StructureDefinition-krcore-bodyheight.html)\n  + 체온 - [KR Core Observation Profile for Vital Signs: Body Temperature](StructureDefinition-krcore-bodytemperature.html)\n  + 몸무게 - [KR Core Observation Profile for Vital Signs: Body Weight](StructureDefinition-krcore-bodyweight.html)\n  + 맥박수 - [KR Core Observation Profile for Vital Signs: Heart Rate](StructureDefinition-krcore-heartrate.html)\n  + 산소포화도 - [KR Core Observation Profile for Vital Signs: Pulse Oximetry](StructureDefinition-krcore-pulseoximeter.html)\n  + 호흡수 - [KR Core Observation Profile for Vital Signs: Respiratory Rate](StructureDefinition-krcore-respiratoryrate.html)\n\n\n※ 주의사항\n+ KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "환자를 대상으로하는 활력 징후 및 신체 계측 정보를 구조화하기 위해 정의한 범용 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "KR Core Observation Profile for Vital Signs"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "short" : "측정 상태: registered | preliminary | final | amended +"
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "관찰 및 측정 범주",
        "min" : 1,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationCategory"
            }
          ],
          "strength" : "required",
          "description" : "Codes for high level observation categories.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-category"
        }
      },
      {
        "id" : "Observation.category:VitalSigns",
        "path" : "Observation.category",
        "sliceName" : "VitalSigns",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "활력징후 및 신체 계측 항목 정보"
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.code.coding:LOINC",
        "path" : "Observation.code.coding",
        "sliceName" : "LOINC",
        "short" : "LOINC 코드 정보",
        "min" : 0,
        "max" : "*",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet",
              "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-vital-signs-codes"
            }
          ],
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Observation.code.coding:LOINC.system",
        "path" : "Observation.code.coding.system",
        "short" : "LOINC 코드체계",
        "min" : 1,
        "fixedUri" : "http://loinc.org"
      },
      {
        "id" : "Observation.code.coding:LOINC.code",
        "path" : "Observation.code.coding.code",
        "short" : "LOINC 코드",
        "min" : 1
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "short" : "활력징후 및 신체 계측 대상 환자",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "short" : "활력징후 및 신체 계측 일시"
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "short" : "활력징후 및 신체 계측 책임자",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner",
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner-role",
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-organization",
              "http://hl7.org/fhir/StructureDefinition/CareTeam",
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-patient",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "활력징후 및 신체 계측 결과"
      },
      {
        "id" : "Observation.dataAbsentReason",
        "path" : "Observation.dataAbsentReason",
        "short" : "활력징후 및 신체 계측 결과 부재 사유"
      },
      {
        "id" : "Observation.device",
        "path" : "Observation.device",
        "short" : "활력징후 및 신체 계측 장비 정보"
      },
      {
        "id" : "Observation.component.code",
        "path" : "Observation.component.code",
        "short" : "세부 활력징후 및 신체 계측 정보"
      },
      {
        "id" : "Observation.component.code.coding",
        "path" : "Observation.component.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component.code.coding:LOINC",
        "path" : "Observation.component.code.coding",
        "sliceName" : "LOINC",
        "short" : "LOINC 코드 정보",
        "min" : 0,
        "max" : "*",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet",
              "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-vital-signs-codes"
            }
          ],
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Observation.component.code.coding:LOINC.system",
        "path" : "Observation.component.code.coding.system",
        "short" : "LOINC 코드체계",
        "min" : 1,
        "fixedUri" : "http://loinc.org"
      },
      {
        "id" : "Observation.component.code.coding:LOINC.code",
        "path" : "Observation.component.code.coding.code",
        "short" : "LOINC 코드",
        "min" : 1
      },
      {
        "id" : "Observation.component.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "세부 활력징후 및 신체 계측 결과"
      },
      {
        "id" : "Observation.component.dataAbsentReason",
        "path" : "Observation.component.dataAbsentReason",
        "short" : "세부 활력징후 및 신체 계측 결과 부재 사유"
      }
    ]
  }
}

```
