# KR Core PractitionerRole Profile - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core PractitionerRole Profile**

## Resource Profile: KR Core PractitionerRole Profile 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner-role | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_PractitionerRole |

 
KR Core PractitionerRole Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 보건의료 환경에서 실질적으로 진료 과정에 참여하는 다양한 인력의 역할을 일관되게 표현하는데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 임상 행위, 진료 흐름, 환자 정보 처리, 의료 데이터 관리에 공식적으로 참여하는 모든 인력의 역할을 표현하는데 이 Profile을 적용할 수 있다. 단, 의료법에 따라 자격이 부여된 의사(Medical Doctor)의 역할을 표현하기 위해서는 본 Profile을 상속하여 정의한[KR Core PractitionerRole Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor-role.md)를**반드시(SHALL)**적용해야 한다. KR Core PractitionerRole Profile for Medical Doctor를 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다. 
※ 주의사항 
* KR Core PractitionerRole Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자의 역할 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 

 
보건의료 서비스 제공 과정에 직접 또는 간접적으로 관여하는 사람의 역할 정보를 구조화하기 위해 정의한 범용 Profile. 

**Usages:**

* Derived from this Profile: [KR Core PractitionerRole Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor-role.md)
* Refer to this Profile: [KR Core DiagnosticReport Profile for Diagnostic Imaging](StructureDefinition-krcore-diagnosticreport-diagnostic-imaging.md), [KR Core DiagnosticReport Profile for Functional Tests](StructureDefinition-krcore-diagnosticreport-function-tests.md), [KR Core DiagnosticReport Profile for Laboratory Results](StructureDefinition-krcore-diagnosticreport-laboratory-results.md), [KR Core DiagnosticReport Profile for Pathology Results](StructureDefinition-krcore-diagnosticreport-pathology-results.md)...Show 4 more,[KR Core Encounter Profile](StructureDefinition-krcore-encounter.md),[KR Core Observation Profile for Functional Test](StructureDefinition-krcore-observation-function-test.md),[KR Core Observation Profile for Laboratory Result](StructureDefinition-krcore-observation-laboratory-result.md)and[KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)
* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-practitioner-role)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-practitioner-role.csv), [Excel](StructureDefinition-krcore-practitioner-role.xlsx), [Schematron](StructureDefinition-krcore-practitioner-role.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-practitioner-role",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner-role",
  "version" : "2.0.0",
  "name" : "KRCore_PractitionerRole",
  "title" : "KR Core PractitionerRole Profile",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core PractitionerRole Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 보건의료 환경에서 실질적으로 진료 과정에 참여하는\n다양한 인력의 역할을 일관되게 표현하는데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n임상 행위, 진료 흐름, 환자 정보 처리, 의료 데이터 관리에 공식적으로 참여하는 모든 인력의 역할을 표현하는데 이 Profile을 적용할 수 있다.\n단, 의료법에 따라 자격이 부여된 의사(Medical Doctor)의 역할을 표현하기 위해서는 본 Profile을 상속하여 정의한\n[KR Core PractitionerRole Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor-role.html)를\n**반드시(SHALL)** 적용해야 한다. KR Core PractitionerRole Profile for Medical Doctor를 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다.\n\n\n※ 주의사항\n+ KR Core PractitionerRole Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자의 역할 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "보건의료 서비스 제공 과정에 직접 또는 간접적으로 관여하는 사람의 역할 정보를 구조화하기 위해 정의한 범용 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole",
        "short" : "KR Core PractitionerRole Profile"
      },
      {
        "id" : "PractitionerRole.identifier",
        "path" : "PractitionerRole.identifier",
        "short" : "보건의료 종사자 역할 ID"
      },
      {
        "id" : "PractitionerRole.identifier.system",
        "path" : "PractitionerRole.identifier.system",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.identifier.value",
        "path" : "PractitionerRole.identifier.value",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.practitioner",
        "path" : "PractitionerRole.practitioner",
        "short" : "보건의료 종사자 인적사항",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.organization",
        "path" : "PractitionerRole.organization",
        "short" : "보건의료 종사자 소속 기관",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-organization"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.code",
        "path" : "PractitionerRole.code",
        "short" : "보건의료 종사자 역할"
      },
      {
        "id" : "PractitionerRole.code.coding.system",
        "path" : "PractitionerRole.code.coding.system",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.code.coding.code",
        "path" : "PractitionerRole.code.coding.code",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.specialty",
        "path" : "PractitionerRole.specialty",
        "short" : "보건의료 종사자 전문분야"
      },
      {
        "id" : "PractitionerRole.specialty.coding.system",
        "path" : "PractitionerRole.specialty.coding.system",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.specialty.coding.code",
        "path" : "PractitionerRole.specialty.coding.code",
        "min" : 1
      }
    ]
  }
}

```
