# KR Core Patient Profile - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Patient Profile**

## Resource Profile: KR Core Patient Profile 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-patient | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_Patient |

 
KR Core Patient Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 환자 정보를 표현하는 데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 

 
**KR CDI V2 환자 정보 클래스**에서 정의한 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile. 

**Usages:**

* Refer to this Profile: [KR Core AllergyIntolerance Profile](StructureDefinition-krcore-allergyintolerance.md), [KR Core Condition Profile for Chief Complaint](StructureDefinition-krcore-condition-chief-complaint.md), [KR Core Condition Profile for Encounter Diagnosis](StructureDefinition-krcore-condition-encounter-diagnosis.md), [KR Core DiagnosticReport Profile for Diagnostic Imaging](StructureDefinition-krcore-diagnosticreport-diagnostic-imaging.md)...Show 12 more,[KR Core DiagnosticReport Profile for Functional Tests](StructureDefinition-krcore-diagnosticreport-function-tests.md),[KR Core DiagnosticReport Profile for Laboratory Results](StructureDefinition-krcore-diagnosticreport-laboratory-results.md),[KR Core DiagnosticReport Profile for Pathology Results](StructureDefinition-krcore-diagnosticreport-pathology-results.md),[KR Core Encounter Profile](StructureDefinition-krcore-encounter.md),[KR Core ImagingStudy Profile](StructureDefinition-krcore-imagingstudy.md),[KR Core Immunization Profile](StructureDefinition-krcore-immunization.md),[KR Core MedicationRequest Profile](StructureDefinition-krcore-medicationrequest.md),[KR Core Observation Profile for Functional Test](StructureDefinition-krcore-observation-function-test.md),[KR Core Observation Profile for Laboratory Result](StructureDefinition-krcore-observation-laboratory-result.md),[KR Core Procedure Profile](StructureDefinition-krcore-procedure.md),[KR Core Specimen Profile](StructureDefinition-krcore-specimen.md)and[KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)
* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-patient.csv), [Excel](StructureDefinition-krcore-patient.xlsx), [Schematron](StructureDefinition-krcore-patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-patient",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-patient",
  "version" : "2.0.0",
  "name" : "KRCore_Patient",
  "title" : "KR Core Patient Profile",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Patient Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 환자 정보를 표현하는 데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 환자 정보 클래스**에서 정의한 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "short" : "KR Core Patient Profile"
      },
      {
        "id" : "Patient.identifier",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.identifier",
        "short" : "환자 ID",
        "alias" : ["KRCDI: 환자 ID"],
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier.system",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.identifier.system",
        "short" : "식별체계 식별자",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier.value",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.identifier.value",
        "short" : "식별자",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name",
        "short" : "성명",
        "alias" : ["KRCDI: 성명"],
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name.text",
        "short" : "전체 성명",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "short" : "연락처"
      },
      {
        "id" : "Patient.telecom:Phone",
        "path" : "Patient.telecom",
        "sliceName" : "Phone",
        "short" : "전화번호",
        "alias" : ["KRCDI: 전화번호"],
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Patient.telecom:Phone.system",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom.system",
        "short" : "연락처 유형: phone",
        "min" : 1,
        "fixedCode" : "phone"
      },
      {
        "id" : "Patient.telecom:Phone.value",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom.value",
        "short" : "상세 연락처",
        "min" : 1
      },
      {
        "id" : "Patient.telecom:E-mail",
        "path" : "Patient.telecom",
        "sliceName" : "E-mail",
        "short" : "전자메일",
        "alias" : ["KRCDI: 전자메일"],
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Patient.telecom:E-mail.system",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom.system",
        "short" : "연락처 유형: email",
        "min" : 1,
        "fixedCode" : "email"
      },
      {
        "id" : "Patient.telecom:E-mail.value",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom.value",
        "short" : "상세 연락처",
        "min" : 1
      },
      {
        "id" : "Patient.gender",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:reject-invalid"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.gender",
        "short" : "성별: male | female | other | unknown",
        "alias" : ["KRCDI: 성별"],
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.birthDate",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.birthDate",
        "short" : "생년월일",
        "alias" : ["KRCDI: 생년월일"],
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.address",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address",
        "short" : "환자 주소",
        "alias" : ["KRCDI: 주소"]
      },
      {
        "id" : "Patient.address.extension:krcore-roadNameAddress",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address.extension",
        "sliceName" : "krcore-roadNameAddress",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-roadNameAddress"
            ]
          }
        ]
      },
      {
        "id" : "Patient.address.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address.text",
        "short" : "주소 텍스트"
      },
      {
        "id" : "Patient.address.postalCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address.postalCode",
        "short" : "우편번호"
      },
      {
        "id" : "Patient.contact",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.contact",
        "short" : "환자의 연락처(예: 보호자, 배우자, 친구)"
      },
      {
        "id" : "Patient.contact.address",
        "path" : "Patient.contact.address",
        "short" : "연락 담당자의 주소"
      },
      {
        "id" : "Patient.contact.address.extension:krcore-roadNameAddress",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.contact.address.extension",
        "sliceName" : "krcore-roadNameAddress",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-roadNameAddress"
            ]
          }
        ]
      },
      {
        "id" : "Patient.contact.address.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.contact.address.text",
        "short" : "주소 텍스트"
      },
      {
        "id" : "Patient.contact.address.postalCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ActorDefinition/krcore-actordefinition-client"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.contact.address.postalCode",
        "short" : "우편번호"
      }
    ]
  }
}

```
