# KR Core Organization Profile - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Organization Profile**

## Resource Profile: KR Core Organization Profile 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-organization | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_Organization |

 
KR Core Organization Profile은 KR Core Server와 KR Core Client의 진료정보 교류 과정에 참여하는 다양한 기관 및 부서를 일관되게 표현하는데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 임상 행위, 진료 흐름, 환자 정보 처리, 의료 데이터 관리에 공식적으로 참여하는 모든 조직 단위를 표현하는데 이 Profile을 적용할 수 있다. 단, 병원, 보건소, 약국 등 건강보험심사평가원에서 요양기관으로 분류한 기관을 표현하기 위해서는 본 Profile을 상속하여 정의한[KR Core Healthcare Organization Profile](StructureDefinition-krcore-healthcare-organization.md)을**반드시(SHALL)**적용해야 한다. KR Core Healthcare Organization Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다. 
※ 주의사항 
* KR Core Organization Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 

 
보건의료 서비스 제공 과정에 직접 또는 간접적으로 관여하는 사람의 정보를 구조화하기 위해 정의한 범용 Profile. 

**Usages:**

* Derived from this Profile: [KR Core Healthcare Organization Profile](StructureDefinition-krcore-healthcare-organization.md)
* Refer to this Profile: [KR Core DiagnosticReport Profile for Diagnostic Imaging](StructureDefinition-krcore-diagnosticreport-diagnostic-imaging.md), [KR Core DiagnosticReport Profile for Functional Tests](StructureDefinition-krcore-diagnosticreport-function-tests.md), [KR Core DiagnosticReport Profile for Laboratory Results](StructureDefinition-krcore-diagnosticreport-laboratory-results.md), [KR Core DiagnosticReport Profile for Pathology Results](StructureDefinition-krcore-diagnosticreport-pathology-results.md)...Show 5 more,[KR Core Encounter Profile](StructureDefinition-krcore-encounter.md),[KR Core Observation Profile for Functional Test](StructureDefinition-krcore-observation-function-test.md),[KR Core Observation Profile for Laboratory Result](StructureDefinition-krcore-observation-laboratory-result.md),[KR Core PractitionerRole Profile](StructureDefinition-krcore-practitioner-role.md)and[KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)
* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-organization.csv), [Excel](StructureDefinition-krcore-organization.xlsx), [Schematron](StructureDefinition-krcore-organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-organization",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-organization",
  "version" : "2.0.0",
  "name" : "KRCore_Organization",
  "title" : "KR Core Organization Profile",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Organization Profile은 KR Core Server와 KR Core Client의 진료정보 교류 과정에 참여하는\n다양한 기관 및 부서를 일관되게 표현하는데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n임상 행위, 진료 흐름, 환자 정보 처리, 의료 데이터 관리에 공식적으로 참여하는 모든 조직 단위를 표현하는데 이 Profile을 적용할 수 있다.\n단, 병원, 보건소, 약국 등 건강보험심사평가원에서 요양기관으로 분류한 기관을 표현하기 위해서는 본 Profile을 상속하여 정의한\n[KR Core Healthcare Organization Profile](StructureDefinition-krcore-healthcare-organization.html)을\n**반드시(SHALL)** 적용해야 한다. KR Core Healthcare Organization Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다.\n\n\n※ 주의사항\n+ KR Core Organization Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "보건의료 서비스 제공 과정에 직접 또는 간접적으로 관여하는 사람의 정보를 구조화하기 위해 정의한 범용 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "short" : "KR Core Organization Profile"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "short" : "기관 ID"
      },
      {
        "id" : "Organization.identifier.system",
        "path" : "Organization.identifier.system",
        "min" : 1
      },
      {
        "id" : "Organization.identifier.value",
        "path" : "Organization.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "short" : "기관 유형",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/organization-type"
        }
      },
      {
        "id" : "Organization.type.coding.system",
        "path" : "Organization.type.coding.system",
        "min" : 1
      },
      {
        "id" : "Organization.type.coding.code",
        "path" : "Organization.type.coding.code",
        "min" : 1
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "short" : "기관명",
        "min" : 1
      },
      {
        "id" : "Organization.telecom",
        "path" : "Organization.telecom",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "short" : "기관 연락처"
      },
      {
        "id" : "Organization.telecom:Phone",
        "path" : "Organization.telecom",
        "sliceName" : "Phone",
        "short" : "전화번호",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Organization.telecom:Phone.system",
        "path" : "Organization.telecom.system",
        "short" : "연락처 유형: phone",
        "min" : 1,
        "fixedCode" : "phone"
      },
      {
        "id" : "Organization.telecom:Phone.value",
        "path" : "Organization.telecom.value",
        "short" : "상세 연락처",
        "min" : 1
      },
      {
        "id" : "Organization.telecom:Fax",
        "path" : "Organization.telecom",
        "sliceName" : "Fax",
        "short" : "팩스번호",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Organization.telecom:Fax.system",
        "path" : "Organization.telecom.system",
        "short" : "연락처 유형: fax",
        "min" : 1,
        "fixedCode" : "fax"
      },
      {
        "id" : "Organization.telecom:Fax.value",
        "path" : "Organization.telecom.value",
        "short" : "상세 연락처",
        "min" : 1
      },
      {
        "id" : "Organization.address",
        "path" : "Organization.address",
        "short" : "주소"
      },
      {
        "id" : "Organization.address.extension:roadNameAddress",
        "path" : "Organization.address.extension",
        "sliceName" : "roadNameAddress",
        "short" : "한국의 도로명 주소",
        "definition" : "도로명 주소 정보를 표현하는 확장",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-roadNameAddress"
            ]
          }
        ]
      },
      {
        "id" : "Organization.address.text",
        "path" : "Organization.address.text",
        "short" : "전체 주소"
      },
      {
        "id" : "Organization.address.postalCode",
        "path" : "Organization.address.postalCode",
        "short" : "우편번호",
        "definition" : "우편번호"
      }
    ]
  }
}

```
