# KR Core MedicationRequest Profile - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core MedicationRequest Profile**

## Resource Profile: KR Core MedicationRequest Profile 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medicationrequest | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_MedicationRequest |

 
KR Core MedicationRequest Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 약품 처방 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 약품 처방 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. 

 
**KR CDI V2 약물 정보**클래스에서 정의한 약품 처방 정보 관련 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile. 

**Usages:**

* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-medicationrequest)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-medicationrequest.csv), [Excel](StructureDefinition-krcore-medicationrequest.xlsx), [Schematron](StructureDefinition-krcore-medicationrequest.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-medicationrequest",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medicationrequest",
  "version" : "2.0.0",
  "name" : "KRCore_MedicationRequest",
  "title" : "KR Core MedicationRequest Profile",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core MedicationRequest Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 약품 처방 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n약품 처방 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 약물 정보** 클래스에서 정의한 약품 처방 정보 관련 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest",
        "path" : "MedicationRequest",
        "short" : "KR Core MedicationRequest Profile"
      },
      {
        "id" : "MedicationRequest.status",
        "path" : "MedicationRequest.status",
        "short" : "처방 상태: active | on-hold | cancelled | completed | entered-in-error | stopped | draft | unknown",
        "alias" : ["KRCDI: 처방 상태"],
        "example" : [
          {
            "label" : "Value (Preferred)",
            "valueCode" : "completed"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.intent",
        "path" : "MedicationRequest.intent",
        "short" : "처방 의도: order | proposal | plan +",
        "alias" : ["KRCDI: 처방 의도"],
        "example" : [
          {
            "label" : "Value (Preferred)",
            "valueCode" : "order"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.medication[x]",
        "path" : "MedicationRequest.medication[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "처방 약품 정보",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationReference",
        "path" : "MedicationRequest.medication[x]",
        "sliceName" : "medicationReference",
        "short" : "약품 정보 참조",
        "alias" : ["KRCDI: 약품 제품명, 약품 성분명"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medication"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept",
        "path" : "MedicationRequest.medication[x]",
        "sliceName" : "medicationCodeableConcept",
        "short" : "약품 제품 정보",
        "alias" : ["KRCDI: 약품 제품명"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-edi-medication-codes"
        }
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.extension",
        "path" : "MedicationRequest.medication[x].extension",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.extension:krcore-medicationIngredient",
        "path" : "MedicationRequest.medication[x].extension",
        "sliceName" : "krcore-medicationIngredient",
        "short" : "약품 성분명",
        "alias" : ["KRCDI: 약품 성분명", "user content"],
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medicationIngredient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding.system",
        "path" : "MedicationRequest.medication[x].coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding.code",
        "path" : "MedicationRequest.medication[x].coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationCodeableConcept.coding.display",
        "path" : "MedicationRequest.medication[x].coding.display",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.subject",
        "path" : "MedicationRequest.subject",
        "short" : "처방 대상",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.authoredOn",
        "path" : "MedicationRequest.authoredOn",
        "short" : "처방 일시"
      },
      {
        "id" : "MedicationRequest.dosageInstruction",
        "path" : "MedicationRequest.dosageInstruction",
        "short" : "약물 투여 및 복용 지침",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.text",
        "path" : "MedicationRequest.dosageInstruction.text",
        "short" : "용법",
        "alias" : ["KRCDI: 용법"],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing",
        "path" : "MedicationRequest.dosageInstruction.timing",
        "short" : "약품 투여 및 복용 일정",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat",
        "short" : "약품 투여 및 복용 반복 정보",
        "alias" : ["KRCDI: 복용 횟수"],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.frequency",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.frequency",
        "short" : "주기 당 약품 투여 및 복용 횟수",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.period",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.period",
        "short" : "약품 투여 및 복용 주기 수치",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.periodUnit",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.periodUnit",
        "short" : "약품 투여 및 복용 주기 단위: s | min | h | d | wk | mo | a",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/units-of-time|4.0.1"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate",
        "short" : "투여 및 복용량",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "1회량, 1회량 단위",
        "alias" : ["KRCDI: 1회량, 1회량 단위"],
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]:doseQuantity",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "sliceName" : "doseQuantity",
        "short" : "단위를 포함한 투여 및 복용량",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ucum-units"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]:doseRange",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "sliceName" : "doseRange",
        "short" : "범위로 지정된 투여 및 복용량",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Range"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]:doseRange.low",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].low",
        "short" : "최소",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ucum-units"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]:doseRange.high",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x].high",
        "short" : "최대",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ucum-units"
        }
      },
      {
        "id" : "MedicationRequest.dispenseRequest",
        "path" : "MedicationRequest.dispenseRequest",
        "short" : "처방 요청",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity",
        "path" : "MedicationRequest.dispenseRequest.quantity",
        "short" : "단위를 포함한 처방 총량",
        "alias" : ["KRCDI: 총량, 총량 단위"],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ucum-units"
        }
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "short" : "처방 기간: s | min | h | d | wk | mo | a",
        "alias" : ["KRCDI: 처방 일수"],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration.code",
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration.code",
        "short" : "처방 기간 단위 코드",
        "example" : [
          {
            "label" : "Value (Preferred)",
            "valueCode" : "d"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "UnitsOfTime"
            }
          ],
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/units-of-time|4.0.1"
        }
      }
    ]
  }
}

```
