# KR Core PractitionerRole Profile for Medical Doctor - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core PractitionerRole Profile for Medical Doctor**

## Resource Profile: KR Core PractitionerRole Profile for Medical Doctor 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medical-doctor-role | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_PractitionerRole_MedicalDoctor |

 
KR Core PractitionerRole Profile for Medical Doctor는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진료의의 역할 정보를 표현하는 데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 본 Profile은 의료법에 따라 자격이 부여된 의사(Medical Doctor)의 역할을 표현하기 위해[KR Core PractitionerRole Profile](StructureDefinition-krcore-practitioner-role.md)을 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core PractitionerRole Profile을 만족한다. 
※ 주의사항 
* KR Core PractitionerRole Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자의 역할 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 

 
**KR CDI V2 진료의 정보 및 역할 정보**클래스에서 정의한 진료의의 역할 정보 관련 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile. 

**Usages:**

* Refer to this Profile: [KR Core Encounter Profile](StructureDefinition-krcore-encounter.md)
* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-medical-doctor-role)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-medical-doctor-role.csv), [Excel](StructureDefinition-krcore-medical-doctor-role.xlsx), [Schematron](StructureDefinition-krcore-medical-doctor-role.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-medical-doctor-role",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medical-doctor-role",
  "version" : "2.0.0",
  "name" : "KRCore_PractitionerRole_MedicalDoctor",
  "title" : "KR Core PractitionerRole Profile for Medical Doctor",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core PractitionerRole Profile for Medical Doctor는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진료의의 역할 정보를 표현하는 데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n본 Profile은 의료법에 따라 자격이 부여된 의사(Medical Doctor)의 역할을 표현하기 위해 [KR Core PractitionerRole Profile](StructureDefinition-krcore-practitioner-role.html)을\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core PractitionerRole Profile을 만족한다.\n\n\n※ 주의사항\n+ KR Core PractitionerRole Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자의 역할 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 진료의 정보 및 역할 정보** 클래스에서 정의한 진료의의 역할 정보 관련 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner-role",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole",
        "short" : "KR Core PractitionerRole Profile for Medical Doctor"
      },
      {
        "id" : "PractitionerRole.practitioner",
        "path" : "PractitionerRole.practitioner",
        "short" : "진료의 인적사항",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medical-doctor"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.organization",
        "path" : "PractitionerRole.organization",
        "short" : "진료의 소속 기관",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-healthcare-organization"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.code",
        "path" : "PractitionerRole.code",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "진료의 역할",
        "min" : 1,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "PractitionerRole"
            }
          ],
          "strength" : "extensible",
          "description" : "The role a person plays representing an organization.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/practitioner-role"
        }
      },
      {
        "id" : "PractitionerRole.code:MDRole",
        "path" : "PractitionerRole.code",
        "sliceName" : "MDRole",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/practitioner-role",
              "code" : "doctor"
            }
          ]
        }
      },
      {
        "id" : "PractitionerRole.specialty",
        "path" : "PractitionerRole.specialty",
        "short" : "진료과",
        "alias" : ["KRCDI: 진료과"],
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-medicaldepartment-codes"
        }
      },
      {
        "id" : "PractitionerRole.specialty.coding",
        "path" : "PractitionerRole.specialty.coding",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.specialty.coding.system",
        "path" : "PractitionerRole.specialty.coding.system",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.specialty.coding.code",
        "path" : "PractitionerRole.specialty.coding.code",
        "mustSupport" : true
      }
    ]
  }
}

```
