# KR Core Healthcare Organization Profile - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Healthcare Organization Profile**

## Resource Profile: KR Core Healthcare Organization Profile 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-healthcare-organization | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_HealthcareOrganization |

 
KR Core Healthcare Organization Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 의료기관 정보를 표현하는 데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 본 Profile은 병원, 보건소, 약국 등 건강보험심사평가원에서 요양기관으로 분류한 기관을 표현하기 위해[KR Core Organization Profile](StructureDefinition-krcore-organization.md)을 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Organization Profile을 만족한다. 
※ 주의사항 
* KR Core Organization Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 

 
**KR CDI V2 의료기관 정보**클래스에서 정의한 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile. 

**Usages:**

* Refer to this Profile: [KR Core Encounter Profile](StructureDefinition-krcore-encounter.md) and [KR Core PractitionerRole Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor-role.md)
* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-healthcare-organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-healthcare-organization.csv), [Excel](StructureDefinition-krcore-healthcare-organization.xlsx), [Schematron](StructureDefinition-krcore-healthcare-organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-healthcare-organization",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-healthcare-organization",
  "version" : "2.0.0",
  "name" : "KRCore_HealthcareOrganization",
  "title" : "KR Core Healthcare Organization Profile",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Healthcare Organization Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 의료기관 정보를 표현하는 데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n본 Profile은 병원, 보건소, 약국 등 건강보험심사평가원에서 요양기관으로 분류한 기관을 표현하기 위해 [KR Core Organization Profile](StructureDefinition-krcore-organization.html)을\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Organization Profile을 만족한다.\n\n\n※ 주의사항\n+ KR Core Organization Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 의료기관 정보** 클래스에서 정의한 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "short" : "KR Core Healthcare Organization Profile"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "short" : "의료기관 ID",
        "alias" : ["KRCDI: 의료기관 ID"],
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:HIRA",
        "path" : "Organization.identifier",
        "sliceName" : "HIRA",
        "short" : "건강보험심사평가원 요양기관 식별 정보",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:HIRA.system",
        "path" : "Organization.identifier.system",
        "short" : "건강보험심사평가원 요양기관 식별 체계",
        "fixedUri" : "http://www.hl7korea.or.kr/Identifier/hira-krnpi",
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:HIRA.value",
        "path" : "Organization.identifier.value",
        "short" : "건강보험심사평가원 요양기관 식별자",
        "definition" : "요양기관의 OID",
        "mustSupport" : true
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "short" : "의료기관 유형",
        "alias" : ["KRCDI: 의료기관 유형"],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-healthcare-organization-type-codes"
        }
      },
      {
        "id" : "Organization.type.coding",
        "path" : "Organization.type.coding",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Organization.type.coding.system",
        "path" : "Organization.type.coding.system",
        "mustSupport" : true
      },
      {
        "id" : "Organization.type.coding.code",
        "path" : "Organization.type.coding.code",
        "mustSupport" : true
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "short" : "의료기관명",
        "alias" : ["KRCDI: 의료기관명"],
        "mustSupport" : true
      },
      {
        "id" : "Organization.telecom",
        "path" : "Organization.telecom",
        "short" : "의료기관 연락처"
      },
      {
        "id" : "Organization.telecom:Phone",
        "path" : "Organization.telecom",
        "sliceName" : "Phone",
        "alias" : ["KRCDI: 전화번호"]
      },
      {
        "id" : "Organization.telecom:Fax",
        "path" : "Organization.telecom",
        "sliceName" : "Fax",
        "alias" : ["KRCDI: 팩스번호"]
      },
      {
        "id" : "Organization.address",
        "path" : "Organization.address",
        "alias" : ["KRCDI: 주소"]
      }
    ]
  }
}

```
