# KR Core Observation Profile for Vital Signs: Body Temperature - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Observation Profile for Vital Signs: Body Temperature**

## Resource Profile: KR Core Observation Profile for Vital Signs: Body Temperature 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-bodytemperature | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_Observation_VitalSigns_BodyTemperature |

 
본 Profile은 환자를 대상으로 측정한 체온을 표현하기 위해[KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)를 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다. 
※ 주의사항 
* KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 

 
**KR CDI V2 활력 징후 및 신체 계측 정보**클래스에서 정의한`체온`항목과 주요 추가 정보를 구조화하기 위해 정의한 Profile. 

**Usages:**

* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-bodytemperature)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-bodytemperature.csv), [Excel](StructureDefinition-krcore-bodytemperature.xlsx), [Schematron](StructureDefinition-krcore-bodytemperature.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-bodytemperature",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-bodytemperature",
  "version" : "2.0.0",
  "name" : "KRCore_Observation_VitalSigns_BodyTemperature",
  "title" : "KR Core Observation Profile for Vital Signs: Body Temperature",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "본 Profile은 환자를 대상으로 측정한 체온을 표현하기 위해 [KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.html)를\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.\n\n\n※ 주의사항\n+ KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 활력 징후 및 신체 계측 정보** 클래스에서 정의한 `체온` 항목과 주요 추가 정보를 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-vitalsigns",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "KR Core Observation Profile for Vital Signs: Body Temperature",
        "constraint" : [
          {
            "key" : "krcore-obs-01",
            "requirements" : "KR Core 권장사항",
            "severity" : "warning",
            "human" : "value 또는 dataAbsentReason 중 하나는 제공할 것.",
            "expression" : "value.exists() or dataAbsentReason.exists()",
            "source" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-bodytemperature"
          }
        ]
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding:LOINC",
        "path" : "Observation.code.coding",
        "sliceName" : "LOINC",
        "short" : "체온 측정",
        "alias" : ["체온"]
      },
      {
        "id" : "Observation.code.coding:LOINC.system",
        "path" : "Observation.code.coding.system",
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding:LOINC.code",
        "path" : "Observation.code.coding.code",
        "fixedCode" : "8310-5",
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding:LOINC.display",
        "path" : "Observation.code.coding.display",
        "example" : [
          {
            "label" : "Value (Preferred)",
            "valueString" : "Body temperature"
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "체온 측정 결과",
        "type" : [
          {
            "code" : "Quantity"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x].value",
        "path" : "Observation.value[x].value",
        "short" : "측정값",
        "min" : 1
      },
      {
        "id" : "Observation.value[x].unit",
        "path" : "Observation.value[x].unit",
        "example" : [
          {
            "label" : "Value (Preferred)",
            "valueString" : "°C"
          }
        ]
      },
      {
        "id" : "Observation.value[x].system",
        "path" : "Observation.value[x].system",
        "min" : 1,
        "fixedUri" : "http://unitsofmeasure.org"
      },
      {
        "id" : "Observation.value[x].code",
        "path" : "Observation.value[x].code",
        "min" : 1,
        "fixedCode" : "Cel"
      }
    ]
  }
}

```
