# ns-hira-healthcare-organization-identifier - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ns-hira-healthcare-organization-identifier**

## NamingSystem: ns-hira-healthcare-organization-identifier 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/NamingSystem/ns-hira-healthcare-organization-identifier | *Version*:1.0.2 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HIRA_Healthcare_Organization_Identifier |

 
건강보험심사평가원 요양기관 식별자 명명체계 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ns-hira-healthcare-organization-identifier",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.url",
      "valueUri" : "http://www.hl7korea.or.kr/fhir/krcore/NamingSystem/ns-hira-healthcare-organization-identifier"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.version",
      "valueString" : "1.0.2"
    }
  ],
  "name" : "HIRA_Healthcare_Organization_Identifier",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2023-06-30",
  "publisher" : "HL7 Korea",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PRN",
        "display" : "Provider number"
      }
    ]
  },
  "description" : "건강보험심사평가원 요양기관 식별자 명명체계",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://www.hl7korea.or.kr/Identifier/hira-krnpi",
      "preferred" : true,
      "comment" : "건강보험심사평가원 요양기관 식별자를 정의하기 위해 HL7 Korea에서 부여한 식별자"
    },
    {
      "type" : "uri",
      "value" : "https://hira.or.kr/knpi",
      "preferred" : false,
      "comment" : "건강보험심사평가원 요양기관 식별자를 정의하기 위해 KR Core Draft버전에서 부여한 식별자"
    }
  ]
}

```
