# KR Core Condition Category Types - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Condition Category Types**

## CodeSystem: KR Core Condition Category Types 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/CodeSystem/krcore-condition-category-types | *Version*:1.0.2 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KR_Core_Condition_Category_Types |

 
KR Core 진단 및 주호소 범주 코드체계 

 
KR Core Condition Profile for Chief Complaint와 KR Core Condition Profile for Encounter Diagnosis의 범주 구분을 위해 정의 

 This Code system is referenced in the content logical definition of the following value sets: 

* [KR_Core_Condition_Category_Codes](ValueSet-krcore-condition-category-codes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "krcore-condition-category-types",
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/CodeSystem/krcore-condition-category-types",
  "version" : "1.0.2",
  "name" : "KR_Core_Condition_Category_Types",
  "title" : "KR Core Condition Category Types",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-06-30",
  "publisher" : "HL7 Korea",
  "description" : "KR Core 진단 및 주호소 범주 코드체계",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "KR Core Condition Profile for Chief Complaint와 KR Core Condition Profile for Encounter Diagnosis의 범주 구분을 위해 정의",
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 2,
  "concept" : [
    {
      "code" : "진단",
      "display" : "진단"
    },
    {
      "code" : "주호소",
      "display" : "주호소"
    }
  ]
}

```
