# Search Parameters Observation Derived - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Search Parameters Observation Derived**

## Search Parameters Observation Derived

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [category](SearchParameter-krcore-sp-observation-category.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 관찰 및 측정 범주 | Observation.category | SHOULD |
| [code](SearchParameter-krcore-sp-observation-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 관찰 및 측정의 유형 | Observation.code | MAY |
| [code-value-concept](SearchParameter-krcore-sp-observation-code-value-concept.md) | [composite](http://hl7.org/fhir/r4/search.html#composite) | 관찰 및 측정의 유형과 CodeableConcept 자료형으로 표현된 측정값 쌍 | On Observation: code: code value-concept: value.ofType(CodeableConcept) | MAY |
| [code-value-date](SearchParameter-krcore-sp-observation-code-value-date.md) | [composite](http://hl7.org/fhir/r4/search.html#composite) | 관찰 및 측정의 유형과 date/time 자료형으로 표현된 측정값 쌍 | On Observation: code: code value-date: value.ofType(DateTime) | value.ofType(Period) | MAY |
| [code-value-quantity](SearchParameter-krcore-sp-observation-code-value-quantity.md) | [composite](http://hl7.org/fhir/r4/search.html#composite) | 관찰 및 측정의 유형과 quantity 자료형으로 표현된 측정값 쌍 | On Observation: code: code value-quantity: value.ofType(Quantity) | MAY |
| [code-value-string](SearchParameter-krcore-sp-observation-code-value-string.md) | [composite](http://hl7.org/fhir/r4/search.html#composite) | 관찰 및 측정의 유형과 string 자료형으로 표현된 측정값 쌍 | On Observation: code: code value-string: value.ofType(string) | MAY |
| [component-code](SearchParameter-krcore-sp-observation-component-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 세부 관찰 및 측정의 유형 | Observation.component.code | MAY |
| [component-code-value-concept](SearchParameter-krcore-sp-observation-component-code-value-concept.md) | [composite](http://hl7.org/fhir/r4/search.html#composite) | 세부 관찰 및 측정의 유형과 CodeableConcept 자료형으로 표현된 세부 관찰 및 측정값 쌍 | On Observation.component: component-code: code component-value-concept: value.ofType(CodeableConcept) | MAY |
| [component-code-value-quantity](SearchParameter-krcore-sp-observation-component-code-value-quantity.md) | [composite](http://hl7.org/fhir/r4/search.html#composite) | 세부 관찰 및 측정의 유형과 Quantity 자료형으로 표현된 세부 관찰 및 측정값 쌍 | On Observation.component: component-code: code component-value-quantity: value.ofType(Quantity) | MAY |
| [component-data-absent-reason](SearchParameter-krcore-sp-observation-component-data-absent-reason.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 세부 관찰 및 측정 결과(Observation.component.value[x]) 부재 사유 | Observation.component.dataAbsentReason | MAY |
| [component-value-concept](SearchParameter-krcore-sp-observation-component-value-concept.md) | [token](http://hl7.org/fhir/r4/search.html#token) | CodeableConcept 자료형으로 표현된 세부 관찰 및 측정값 | Observation.component.value.ofType(CodeableConcept) | MAY |
| [component-value-quantity](SearchParameter-krcore-sp-observation-component-value-quantity.md) | [quantity](http://hl7.org/fhir/r4/search.html#quantity) | Quantity 또는 SampledData 자료형으로 표현된 세부 관찰 및 측정값 | Observation.component.value.ofType(Quantity) | Observation.component.value.ofType(SampledData) | MAY |
| [data-absent-reason](SearchParameter-krcore-sp-observation-data-absent-reason.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 관찰 및 측정 결과(Observation.value[x]) 부재 사유 | Observation.dataAbsentReason | MAY |
| [date](SearchParameter-krcore-sp-observation-date.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | 관찰 및 측정 일시 | Observation.effective | MAY |
| [patient](SearchParameter-krcore-sp-observation-patient.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 관찰 및 측정 대상 환자 | Observation.subject.where(resolve() is Patient) | SHALL |
| [performer](SearchParameter-krcore-sp-observation-performer.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 관찰 및 측정 책임자 | Observation.performer | SHOULD |
| [specimen](SearchParameter-krcore-sp-observation-specimen.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 본 관찰 및 측정에 사용된 검체 | Observation.specimen | MAY |
| [status](SearchParameter-krcore-sp-observation-status.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 관찰 및 측정 진행 상태 | Observation.status | MAY |
| [value-concept](SearchParameter-krcore-sp-observation-value-concept.md) | [token](http://hl7.org/fhir/r4/search.html#token) | CodeableConcept 자료형으로 표현된 측정값 | Observation.value.ofType(CodeableConcept) | MAY |
| [value-date](SearchParameter-krcore-sp-observation-value-date.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | dateTime 또는 Period 자료형으로 표현된 측정값 | Observation.value.ofType(dateTime) | Observation.value.ofType(Period) | MAY |
| [value-quantity](SearchParameter-krcore-sp-observation-value-quantity.md) | [quantity](http://hl7.org/fhir/r4/search.html#quantity) | Quantity 또는 SampledData 자료형으로 표현된 측정값 | Observation.value.ofType(Quantity) | Observation.value.ofType(SampledData) | MAY |
| [value-string](SearchParameter-krcore-sp-observation-value-string.md) | [string](http://hl7.org/fhir/r4/search.html#string) | string 자료형 또는 CodeableConcept 자료형 내 text로 표현된 측정값 | Observation.value.ofType(string) | Observation.value.ofType(CodeableConcept).text | MAY |

