# Capability Statements - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Capability Statements**

## Capability Statements

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

다음의 CapabilityStatement들은 KR Core Implementation Guide를 준수하기 위해 각 유형의 시스템이 갖추어야 할 구체적인 기능(capabilities)을 정의한다. KR Core Implementation Guide 적합성을 준수하는 시스템은 아래에 나열된 하나 이상의 CapabilityStatement를 준수하고 있음을 명시적으로 밝혀야한다.

* [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) 
이 CapabilityStatement는 보건의료데이터 생성(create), 수정(update), 읽기(read), 검색(search) 요청을 시작하는 역할을 담당하는 **KR Core Client**에 대한 기본 규칙을 설명한다. KR Core Client가 지원해야 하는 KR Core Profile, RESTful API, 검색 인자(Search Parameter)의 전체 목록은 이 CapabilityStatement에 정의되어 있다.
* [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md) 
이 CapabilityStatement는 보건의료데이터 생성(create), 수정(update), 읽기(read), 검색(search) 요청에 응답하는 역할을 담당하는 **KR Core Server**에 대한 기본 규칙을 설명한다. KR Core Server가 지원해야 하는 하는 KR Core Profile, RESTful API, 검색 인자(Search Parameter)의 전체 목록은 이 CapabilityStatement에 정의되어 있다.

