# KR Core Medical Department Codes - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Medical Department Codes**

## ValueSet: KR Core Medical Department Codes 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-medicaldepartment-codes | *Version*:1.0.2 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KR_Core_Medical_Department_Codes |

 
KR Core 의료인 진료과 코드집합 

 **References** 

* [KR Core PractitionerRole Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor-role.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "krcore-medicaldepartment-codes",
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-medicaldepartment-codes",
  "version" : "1.0.2",
  "name" : "KR_Core_Medical_Department_Codes",
  "title" : "KR Core Medical Department Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-06-30",
  "publisher" : "HL7 Korea",
  "description" : "KR Core 의료인 진료과 코드집합",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://www.hl7korea.or.kr/CodeSystem/hira-medical-department",
        "concept" : [
          {
            "code" : "00",
            "display" : "일반의"
          },
          {
            "code" : "01",
            "display" : "내과"
          },
          {
            "code" : "02",
            "display" : "신경과"
          },
          {
            "code" : "03",
            "display" : "정신건강의학과"
          },
          {
            "code" : "04",
            "display" : "외과"
          },
          {
            "code" : "05",
            "display" : "정형외과"
          },
          {
            "code" : "06",
            "display" : "신경외과"
          },
          {
            "code" : "07",
            "display" : "흉부외과"
          },
          {
            "code" : "08",
            "display" : "성형외과"
          },
          {
            "code" : "09",
            "display" : "마취통증의학과"
          },
          {
            "code" : "10",
            "display" : "산부인과"
          },
          {
            "code" : "11",
            "display" : "소아청소년과"
          },
          {
            "code" : "12",
            "display" : "안과"
          },
          {
            "code" : "13",
            "display" : "이비인후과"
          },
          {
            "code" : "14",
            "display" : "피부과"
          },
          {
            "code" : "15",
            "display" : "비뇨의학과"
          },
          {
            "code" : "16",
            "display" : "영상의학과"
          },
          {
            "code" : "17",
            "display" : "방사선종양학과"
          },
          {
            "code" : "18",
            "display" : "병리과"
          },
          {
            "code" : "19",
            "display" : "진단검사의학과"
          },
          {
            "code" : "20",
            "display" : "결핵과"
          },
          {
            "code" : "21",
            "display" : "재활의학과"
          },
          {
            "code" : "22",
            "display" : "핵의학과"
          },
          {
            "code" : "23",
            "display" : "가정의학과"
          },
          {
            "code" : "24",
            "display" : "응급의학과"
          },
          {
            "code" : "25",
            "display" : "직업환경의학과"
          },
          {
            "code" : "26",
            "display" : "예방의학과"
          },
          {
            "code" : "50",
            "display" : "구강악안면외과"
          },
          {
            "code" : "51",
            "display" : "치과보철과"
          },
          {
            "code" : "52",
            "display" : "치과교정과"
          },
          {
            "code" : "53",
            "display" : "소아치과"
          },
          {
            "code" : "54",
            "display" : "치주과"
          },
          {
            "code" : "55",
            "display" : "치과보존과"
          },
          {
            "code" : "56",
            "display" : "구강내과"
          },
          {
            "code" : "57",
            "display" : "영상치의학과"
          },
          {
            "code" : "58",
            "display" : "구강병리과"
          },
          {
            "code" : "59",
            "display" : "예방치과"
          },
          {
            "code" : "61",
            "display" : "통합치의학과"
          },
          {
            "code" : "80",
            "display" : "한방내과"
          },
          {
            "code" : "81",
            "display" : "한방부인과"
          },
          {
            "code" : "82",
            "display" : "한방소아과"
          },
          {
            "code" : "83",
            "display" : "한방안·이비인후·피부과"
          },
          {
            "code" : "84",
            "display" : "한방신경정신과"
          },
          {
            "code" : "85",
            "display" : "침구과"
          },
          {
            "code" : "86",
            "display" : "한방재활의학과"
          },
          {
            "code" : "87",
            "display" : "사상체질과"
          },
          {
            "code" : "1",
            "display" : "의과"
          },
          {
            "code" : "2",
            "display" : "치과"
          },
          {
            "code" : "3",
            "display" : "조산"
          },
          {
            "code" : "4",
            "display" : "피임시술(자궁내장치, 정관절제술 또는 난관결찰술)을 시행한 경우"
          },
          {
            "code" : "5",
            "display" : "물리치료를 실시한 경우"
          },
          {
            "code" : "7",
            "display" : "한방에서 시술만 시행한 경우"
          },
          {
            "code" : "8",
            "display" : "한방에서 투약만 실시한 경우 응급"
          },
          {
            "code" : "9",
            "display" : "한방에서 시술과 투약을 병행한 경우"
          }
        ]
      }
    ]
  }
}

```
