# KR Core Road Name Address Extension - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Road Name Address Extension**

## Extension: KR Core Road Name Address Extension 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-roadNameAddress | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_RoadNameAddress_Extension |

KR Core Road Name Address Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 한국의 도로명 주소 정보를 표현하는데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Extension을 적용한다.

한국의 도로명 주소 정보를 구조화하기 위해 정의한 범용 Extension.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [KR Core Organization Profile](StructureDefinition-krcore-organization.md), [KR Core Patient Profile](StructureDefinition-krcore-patient.md) and [KR Core Practitioner Profile](StructureDefinition-krcore-practitioner.md)
* Search Parameters using this Extension: [KRCoreSearchParameterOrganizationAddress](SearchParameter-krcore-sp-organization-address.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-roadNameAddress)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-roadNameAddress.csv), [Excel](StructureDefinition-krcore-roadNameAddress.xlsx), [Schematron](StructureDefinition-krcore-roadNameAddress.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-roadNameAddress",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-roadNameAddress",
  "version" : "2.0.0",
  "name" : "KRCore_RoadNameAddress_Extension",
  "title" : "KR Core Road Name Address Extension",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Road Name Address Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 한국의 도로명 주소 정보를 표현하는데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Extension을 적용한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "한국의 도로명 주소 정보를 구조화하기 위해 정의한 범용 Extension.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Address"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "KR Core Road Name Address Extension",
        "definition" : "KR Core Road Name Address Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 한국의 도로명 주소 정보를 표현하는데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Extension을 적용한다."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 3
      },
      {
        "id" : "Extension.extension:district",
        "path" : "Extension.extension",
        "sliceName" : "district",
        "short" : "행정구역",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:district.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:district.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "district"
      },
      {
        "id" : "Extension.extension:district.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:roadName",
        "path" : "Extension.extension",
        "sliceName" : "roadName",
        "short" : "도로명",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:roadName.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:roadName.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "roadName"
      },
      {
        "id" : "Extension.extension:roadName.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:detailedAddress",
        "path" : "Extension.extension",
        "sliceName" : "detailedAddress",
        "short" : "상세주소",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:detailedAddress.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:detailedAddress.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "detailedAddress"
      },
      {
        "id" : "Extension.extension:detailedAddress.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:complements",
        "path" : "Extension.extension",
        "sliceName" : "complements",
        "short" : "참고항목",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:complements.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:complements.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "complements"
      },
      {
        "id" : "Extension.extension:complements.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-roadNameAddress"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
