# KR Core Practitioner Profile for Medical Doctor - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Practitioner Profile for Medical Doctor**

## Resource Profile: KR Core Practitioner Profile for Medical Doctor 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medical-doctor | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_Practitioner_MedicalDoctor |

 
KR Core Practitioner Profile for Medical Doctor는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진료의 정보를 표현하는 데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 본 Profile은 의료법에 따라 자격이 부여된 의사(Medical Doctor)를 표현하기 위해[KR Core Practitioner Profile](StructureDefinition-krcore-practitioner.md)을 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Practitioner Profile을 만족한다. 
※ 주의사항 
* KR Core Practitioner Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 

 
**KR CDI V2 진료의 정보 및 역할 정보**클래스에서 정의한 진료의 정보 관련 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile. 

**Usages:**

* Refer to this Profile: [KR Core Encounter Profile](StructureDefinition-krcore-encounter.md) and [KR Core PractitionerRole Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor-role.md)
* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-medical-doctor)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-medical-doctor.csv), [Excel](StructureDefinition-krcore-medical-doctor.xlsx), [Schematron](StructureDefinition-krcore-medical-doctor.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-medical-doctor",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medical-doctor",
  "version" : "2.0.0",
  "name" : "KRCore_Practitioner_MedicalDoctor",
  "title" : "KR Core Practitioner Profile for Medical Doctor",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Practitioner Profile for Medical Doctor는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진료의 정보를 표현하는 데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n본 Profile은 의료법에 따라 자격이 부여된 의사(Medical Doctor)를 표현하기 위해 [KR Core Practitioner Profile](StructureDefinition-krcore-practitioner.html)을\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Practitioner Profile을 만족한다.\n\n\n※ 주의사항\n+ KR Core Practitioner Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 진료의 정보 및 역할 정보** 클래스에서 정의한 진료의 정보 관련 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner",
        "short" : "KR Core Practitioner Profile for Medical Doctor"
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "alias" : ["KRCDI: 성명"],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name.text",
        "path" : "Practitioner.name.text",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.address",
        "path" : "Practitioner.address",
        "short" : "진료의 개인 주소"
      },
      {
        "id" : "Practitioner.qualification",
        "path" : "Practitioner.qualification",
        "short" : "진료의 면허 정보",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.qualification.identifier",
        "path" : "Practitioner.qualification.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "short" : "진료의 면허 식별 정보",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.qualification.identifier:MOHW",
        "path" : "Practitioner.qualification.identifier",
        "sliceName" : "MOHW",
        "short" : "보건복지부 진료의 면허 코드 식별 정보",
        "alias" : ["KRCDI: 진료의 ID"],
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.qualification.identifier:MOHW.system",
        "path" : "Practitioner.qualification.identifier.system",
        "short" : "보건복지부 진료의 면허 코드 식별 체계",
        "min" : 1,
        "fixedUri" : "http://www.hl7korea.or.kr/Identifier/mohw-md-license-id",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.qualification.identifier:MOHW.value",
        "path" : "Practitioner.qualification.identifier.value",
        "short" : "보건복지부 진료의 면허 코드",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.qualification.code",
        "path" : "Practitioner.qualification.code",
        "short" : "면허 및 자격증 정보",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-doctor-qualification-codes"
        }
      },
      {
        "id" : "Practitioner.qualification.code.coding.system",
        "path" : "Practitioner.qualification.code.coding.system",
        "min" : 1
      },
      {
        "id" : "Practitioner.qualification.code.coding.code",
        "path" : "Practitioner.qualification.code.coding.code",
        "min" : 1
      }
    ]
  }
}

```
