# KR Core AllergyIntolerance Profile - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core AllergyIntolerance Profile**

## Resource Profile: KR Core AllergyIntolerance Profile 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-allergyintolerance | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_AllergyIntolerance |

 
KR Core AllergyIntolerance Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 알레르기 및 불내성 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 알레르기 및 불내성 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. 

 
**KR CDI V2 알레르기 불내성**클래스에서 정의한 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile. 

**Usages:**

* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-allergyintolerance)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-allergyintolerance.csv), [Excel](StructureDefinition-krcore-allergyintolerance.xlsx), [Schematron](StructureDefinition-krcore-allergyintolerance.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-allergyintolerance",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-allergyintolerance",
  "version" : "2.0.0",
  "name" : "KRCore_AllergyIntolerance",
  "title" : "KR Core AllergyIntolerance Profile",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core AllergyIntolerance Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 알레르기 및 불내성 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n알레르기 및 불내성 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 알레르기 불내성** 클래스에서 정의한 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AllergyIntolerance",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/AllergyIntolerance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AllergyIntolerance",
        "path" : "AllergyIntolerance",
        "short" : "KR Core AllergyIntolerance Profile"
      },
      {
        "id" : "AllergyIntolerance.clinicalStatus",
        "path" : "AllergyIntolerance.clinicalStatus",
        "short" : "알레르기 및 불내성 상태: active | inactive | resolved"
      },
      {
        "id" : "AllergyIntolerance.category",
        "path" : "AllergyIntolerance.category",
        "short" : "알레르기 및 불내성 원인 구분: food | medication | environment | biologic",
        "alias" : ["KRCDI: 원인 구분", "Type", "Reaction Type", "Class"]
      },
      {
        "id" : "AllergyIntolerance.code",
        "path" : "AllergyIntolerance.code",
        "short" : "알레르기 및 불내성의 원인 물질 및 증상",
        "comment" : "기존 AllergyIntolerance.code는 알레르기 및 불내성 원인물질과 증상 등을 표현하는 데 사용할 수 있으나, KR Core에서는 사용 용도를 명확하게 하기 위하여 원인물질만을 표현하도록 사용 범위를 좁힘. 알레르기 및 불내성 증상은 AllergyIntolerance.reaction.manifestation으로 표현.",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-atc-codes"
        }
      },
      {
        "id" : "AllergyIntolerance.code.coding.system",
        "path" : "AllergyIntolerance.code.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.code.coding.code",
        "path" : "AllergyIntolerance.code.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.code.text",
        "path" : "AllergyIntolerance.code.text",
        "short" : "알레르기 및 불내성의 원인 물질 및 증상 서술",
        "alias" : ["KRCDI: 원인 물질"]
      },
      {
        "id" : "AllergyIntolerance.patient",
        "path" : "AllergyIntolerance.patient",
        "short" : "알레르기 및 불내성 대상 환자",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.onset[x]",
        "path" : "AllergyIntolerance.onset[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "AllergyIntolerance.onset[x]:onsetDateTime",
        "path" : "AllergyIntolerance.onset[x]",
        "sliceName" : "onsetDateTime",
        "short" : "알레르기 및 불내성 발생일",
        "alias" : ["KRCDI: 발생일"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.reaction",
        "path" : "AllergyIntolerance.reaction",
        "short" : "알레르기 및 불내성 반응"
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation",
        "path" : "AllergyIntolerance.reaction.manifestation",
        "short" : "알레르기 및 불내성 반응 증상"
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation.text",
        "path" : "AllergyIntolerance.reaction.manifestation.text",
        "short" : "알레르기 및 불내성 반응 증상 서술",
        "alias" : ["KRCDI: 증상"]
      }
    ]
  }
}

```
