# krcore-sp-practitionerrole-practitioner - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **krcore-sp-practitionerrole-practitioner**

## SearchParameter: krcore-sp-practitionerrole-practitioner 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/SearchParameter/krcore-sp-practitionerrole-practitioner | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCoreSearchParameterPractitionerRolePractitioner |

 
의료인 인적사항 



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "krcore-sp-practitionerrole-practitioner",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
      "valueCode" : "SHALL"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/note",
      "valueAnnotation" : {
        "text" : "KR Core Client는 적어도 `id` 값 검색을 **반드시(SHALL)** 지원해야 하며, **선택적(MAY)**으로 `Type`/`id` 값 검색을 지원할 수 있다. KR Core Server는 **반드시(SHALL)** `id`, `Type`/`id` 값 검색을 모두 지원해야 한다."
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/SearchParameter/krcore-sp-practitionerrole-practitioner",
  "version" : "2.0.0",
  "name" : "KRCoreSearchParameterPractitionerRolePractitioner",
  "derivedFrom" : "http://hl7.org/fhir/SearchParameter/PractitionerRole-practitioner",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "의료인 인적사항",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "code" : "practitioner",
  "base" : ["PractitionerRole"],
  "type" : "reference",
  "expression" : "PractitionerRole.practitioner",
  "target" : ["Practitioner"],
  "multipleOr" : true,
  "_multipleOr" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "MAY"
      }
    ]
  },
  "multipleAnd" : true,
  "_multipleAnd" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "MAY"
      }
    ]
  }
}

```
