# krcore-sp-observation-component-code-value-quantity - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **krcore-sp-observation-component-code-value-quantity**

## SearchParameter: krcore-sp-observation-component-code-value-quantity 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/SearchParameter/krcore-sp-observation-component-code-value-quantity | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCoreSearchParameterObservationComponentCodeValueQuantity |

 
세부 관찰 및 측정의 유형과 Quantity 자료형으로 표현된 세부 관찰 및 측정값 쌍 



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "krcore-sp-observation-component-code-value-quantity",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
      "valueCode" : "MAY"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/note",
      "valueAnnotation" : {
        "text" : "KR Core Client는 **반드시(SHALL)** 모든 구성 요소의 검색 값을 동시에 제공할 수 있어야 한다. KR Core Server는 **반드시(SHALL)** 모든 구성 요소의 검색 값을 동시에 지원해야 한다."
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/SearchParameter/krcore-sp-observation-component-code-value-quantity",
  "version" : "2.0.0",
  "name" : "KRCoreSearchParameterObservationComponentCodeValueQuantity",
  "derivedFrom" : "http://hl7.org/fhir/SearchParameter/Observation-component-code-value-quantity",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "세부 관찰 및 측정의 유형과 Quantity 자료형으로 표현된 세부 관찰 및 측정값 쌍",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "code" : "component-code-value-quantity",
  "base" : ["Observation"],
  "type" : "composite",
  "expression" : "Observation.component",
  "multipleOr" : true,
  "_multipleOr" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "MAY"
      }
    ]
  },
  "multipleAnd" : true,
  "_multipleAnd" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "MAY"
      }
    ]
  },
  "component" : [
    {
      "definition" : "http://www.hl7korea.or.kr/fhir/krcore/SearchParameter/krcore-sp-observation-component-code",
      "expression" : "code"
    },
    {
      "definition" : "http://www.hl7korea.or.kr/fhir/krcore/SearchParameter/krcore-sp-observation-component-value-quantity",
      "expression" : "value.ofType(Quantity)"
    }
  ]
}

```
