# ns-mohw-md-license-id - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ns-mohw-md-license-id**

## NamingSystem: ns-mohw-md-license-id 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/NamingSystem/ns-mohw-md-license-id | *Version*:1.0.2 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:MOHW_MD_License_Id |

 
보건복지부 진료의 면허 식별자 명명체계 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ns-mohw-md-license-id",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.url",
      "valueUri" : "http://www.hl7korea.or.kr/fhir/krcore/NamingSystem/ns-mohw-md-license-id"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.version",
      "valueString" : "1.0.2"
    }
  ],
  "name" : "MOHW_MD_License_Id",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2023-06-30",
  "publisher" : "HL7 Korea",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PRN",
        "display" : "Provider number"
      }
    ]
  },
  "description" : "보건복지부 진료의 면허 식별자 명명체계",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://www.hl7korea.or.kr/Identifier/mohw-md-license-id",
      "preferred" : true,
      "comment" : "보건복지부 진료의 면허 식별자를 정의하기 위해 HL7 Korea에서 부여한 식별자"
    },
    {
      "type" : "uri",
      "value" : "https://mohw.go.kr/CodeSystem/practitioner-license-type",
      "preferred" : false,
      "comment" : "보건복지부 의료인 면허 식별자를 정의하기 위해 KR Core Draft버전에서 부여한 식별자"
    }
  ]
}

```
