# MOHW Practitioner Qualification Types - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MOHW Practitioner Qualification Types**

## CodeSystem: MOHW Practitioner Qualification Types 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/CodeSystem/mohw-practitioner-qualification-types | *Version*:1.0.2 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:MOHW_Practitioner_Qualification_Types |

 
보건복지부 면허종별/자격종별 코드체계 

 This Code system is referenced in the content logical definition of the following value sets: 

* [KR_Core_Doctor_Qualification_Codes](ValueSet-krcore-doctor-qualification-codes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "mohw-practitioner-qualification-types",
  "url" : "http://www.hl7korea.or.kr/CodeSystem/mohw-practitioner-qualification-types",
  "version" : "1.0.2",
  "name" : "MOHW_Practitioner_Qualification_Types",
  "title" : "MOHW Practitioner Qualification Types",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-06-30",
  "publisher" : "HL7 Korea",
  "description" : "보건복지부 면허종별/자격종별 코드체계",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 88,
  "concept" : [
    {
      "code" : "의사",
      "display" : "의사"
    },
    {
      "code" : "치과의사",
      "display" : "치과의사"
    },
    {
      "code" : "한의사",
      "display" : "한의사"
    },
    {
      "code" : "간호사",
      "display" : "간호사"
    },
    {
      "code" : "조산사",
      "display" : "조산사"
    },
    {
      "code" : "임상병리사",
      "display" : "임상병리사"
    },
    {
      "code" : "방사선사",
      "display" : "방사선사"
    },
    {
      "code" : "물리치료사",
      "display" : "물리치료사"
    },
    {
      "code" : "작업치료사",
      "display" : "작업치료사"
    },
    {
      "code" : "치과기공사",
      "display" : "치과기공사"
    },
    {
      "code" : "치과위생사",
      "display" : "치과위생사"
    },
    {
      "code" : "보건의료정보관리사",
      "display" : "보건의료정보관리사"
    },
    {
      "code" : "안경사",
      "display" : "안경사"
    },
    {
      "code" : "위생사",
      "display" : "위생사"
    },
    {
      "code" : "영양사",
      "display" : "영양사"
    },
    {
      "code" : "약사",
      "display" : "약사"
    },
    {
      "code" : "한약사",
      "display" : "한약사"
    },
    {
      "code" : "내과",
      "display" : "내과"
    },
    {
      "code" : "신경과",
      "display" : "신경과"
    },
    {
      "code" : "정신건강의학과",
      "display" : "정신건강의학과"
    },
    {
      "code" : "외과",
      "display" : "외과"
    },
    {
      "code" : "정형외과",
      "display" : "정형외과"
    },
    {
      "code" : "신경외과",
      "display" : "신경외과"
    },
    {
      "code" : "심장혈관흉부외과",
      "display" : "심장혈관흉부외과"
    },
    {
      "code" : "성형외과",
      "display" : "성형외과"
    },
    {
      "code" : "마취통증의학과",
      "display" : "마취통증의학과"
    },
    {
      "code" : "산부인과",
      "display" : "산부인과"
    },
    {
      "code" : "소아청소년과",
      "display" : "소아청소년과"
    },
    {
      "code" : "안과",
      "display" : "안과"
    },
    {
      "code" : "이비인후과",
      "display" : "이비인후과"
    },
    {
      "code" : "피부과",
      "display" : "피부과"
    },
    {
      "code" : "비뇨의학과",
      "display" : "비뇨의학과"
    },
    {
      "code" : "영상의학과",
      "display" : "영상의학과"
    },
    {
      "code" : "방사선종양학과",
      "display" : "방사선종양학과"
    },
    {
      "code" : "병리과",
      "display" : "병리과"
    },
    {
      "code" : "진단검사의학과",
      "display" : "진단검사의학과"
    },
    {
      "code" : "결핵과",
      "display" : "결핵과"
    },
    {
      "code" : "재활의학과",
      "display" : "재활의학과"
    },
    {
      "code" : "예방의학과",
      "display" : "예방의학과"
    },
    {
      "code" : "가정의학과",
      "display" : "가정의학과"
    },
    {
      "code" : "응급의학과",
      "display" : "응급의학과"
    },
    {
      "code" : "핵의학",
      "display" : "핵의학"
    },
    {
      "code" : "직업환경의학과",
      "display" : "직업환경의학과"
    },
    {
      "code" : "신경정신과",
      "display" : "신경정신과"
    },
    {
      "code" : "방사선과",
      "display" : "방사선과"
    },
    {
      "code" : "구강악안면외과",
      "display" : "구강악안면외과"
    },
    {
      "code" : "치과보철과",
      "display" : "치과보철과"
    },
    {
      "code" : "치과교정과",
      "display" : "치과교정과"
    },
    {
      "code" : "소아치과",
      "display" : "소아치과"
    },
    {
      "code" : "치주과",
      "display" : "치주과"
    },
    {
      "code" : "치과보존과",
      "display" : "치과보존과"
    },
    {
      "code" : "구강내과",
      "display" : "구강내과"
    },
    {
      "code" : "영상치의학과",
      "display" : "영상치의학과"
    },
    {
      "code" : "구강병리과",
      "display" : "구강병리과"
    },
    {
      "code" : "예방치과",
      "display" : "예방치과"
    },
    {
      "code" : "통합치의학과",
      "display" : "통합치의학과"
    },
    {
      "code" : "한방내과",
      "display" : "한방내과"
    },
    {
      "code" : "한방부인과",
      "display" : "한방부인과"
    },
    {
      "code" : "한방소아과",
      "display" : "한방소아과"
    },
    {
      "code" : "한방신경정신과",
      "display" : "한방신경정신과"
    },
    {
      "code" : "침구과",
      "display" : "침구과"
    },
    {
      "code" : "한방안.이비인후.피부과",
      "display" : "한방안.이비인후.피부과"
    },
    {
      "code" : "한방재활의학과",
      "display" : "한방재활의학과"
    },
    {
      "code" : "사상체질과",
      "display" : "사상체질과"
    },
    {
      "code" : "보건",
      "display" : "보건"
    },
    {
      "code" : "마취",
      "display" : "마취"
    },
    {
      "code" : "정신",
      "display" : "정신"
    },
    {
      "code" : "가정",
      "display" : "가정"
    },
    {
      "code" : "감염관리",
      "display" : "감염관리"
    },
    {
      "code" : "산업",
      "display" : "산업"
    },
    {
      "code" : "응급",
      "display" : "응급"
    },
    {
      "code" : "노인",
      "display" : "노인"
    },
    {
      "code" : "중환자",
      "display" : "중환자"
    },
    {
      "code" : "호스피스",
      "display" : "호스피스"
    },
    {
      "code" : "종양",
      "display" : "종양"
    },
    {
      "code" : "임상",
      "display" : "임상"
    },
    {
      "code" : "아동",
      "display" : "아동"
    },
    {
      "code" : "정신건강임상심리사 1.2급",
      "display" : "정신건강임상심리사 1.2급"
    },
    {
      "code" : "정신건강간호사 1.2급",
      "display" : "정신건강간호사 1.2급"
    },
    {
      "code" : "정신건강사회복지사 1.2급",
      "display" : "정신건강사회복지사 1.2급"
    },
    {
      "code" : "정신건강작업치료사 1.2급",
      "display" : "정신건강작업치료사 1.2급"
    },
    {
      "code" : "한약조제",
      "display" : "한약조제"
    },
    {
      "code" : "임상영양사",
      "display" : "임상영양사"
    },
    {
      "code" : "간호조무사",
      "display" : "간호조무사"
    },
    {
      "code" : "1.2급 응급구조사",
      "display" : "1.2급 응급구조사"
    },
    {
      "code" : "의지.보조기 기사 / 보조공학사",
      "display" : "의지.보조기 기사 / 보조공학사"
    },
    {
      "code" : "1.2급 언어재활사",
      "display" : "1.2급 언어재활사"
    },
    {
      "code" : "1.2.3급 장애인재활상담사",
      "display" : "1.2.3급 장애인재활상담사"
    }
  ]
}

```
