# Terminology - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Terminology**

## Terminology

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### NamingSystems

KR Core에서 정의한 NamingSystem은 다음과 같다.

* [HIRA EDI Material](NamingSystem-ns-hira-edi-material.md) 
건강보험심사평가원 EDI 치료재료 코드 명명체계

* [HIRA EDI Medication](NamingSystem-ns-hira-edi-medication.md) 
건강보험심사평가원 EDI 약제 코드 명명체계

* [HIRA EDI Procedure](NamingSystem-ns-hira-edi-procedure.md) 
건강보험심사평가원 EDI 진료행위 코드 명명체계

* [HIRA Healthcare Organization Identifier](NamingSystem-ns-hira-healthcare-organization-identifier.md) 
건강보험심사평가원 요양기관 식별자 명명체계

* [HIRA Healthcare Organization Types](NamingSystem-ns-hira-healthcare-organization-types.md) 
건강보험심사평가원 요양종별 코드 명명체계

* [HIRA Insurance Types](NamingSystem-ns-hira-insurance-types.md) 
건강보험심사평가원 보험자구분 코드 명명체계

* [HIRA Medical Department](NamingSystem-ns-hira-medical-department.md) 
건강보험심사평가원 진료과목 코드 명명체계

* [KOSTAT KCD8](NamingSystem-ns-kostat-kcd-8.md) 
통계청 제8차 한국표준질병·사인분류표 코드 명명체계

* [KPIS Korea Drug Code](NamingSystem-ns-kpis-kdcode.md) 
의약품관리종합정보센터 KD 코드 명명체계

* [MOHW MD License Id](NamingSystem-ns-mohw-md-license-id.md) 
보건복지부 진료의 면허 식별자 명명체계

* [MOHW Practitioner Qualification Types](NamingSystem-ns-mohw-practitioner-qualification-types.md) 
보건복지부 면허종별/자격종별 코드 명명체계

* [WHO ATC](https://terminology.hl7.org/2.1.0/NamingSystem-v3-WC.html) 
세계보건기구협력센터 ATC 코드 명명체계

### CodeSystems

KR Core에서 정의한 CodeSystem은 다음과 같다.

* [HIRA EDI Material](CodeSystem-hira-edi-material.md) 
건강보험심사평가원 EDI 치료재료 코드체계 

* [HIRA EDI Medication](CodeSystem-hira-edi-medication.md) 
건강보험심사평가원 EDI 약제 코드체계 

* [HIRA EDI Procedure](CodeSystem-hira-edi-procedure.md) 
건강보험심사평가원 EDI 진료행위 코드체계 

* [HIRA Healthcare Organization Types](CodeSystem-hira-healthcare-organization-types.md) 
건강보험심사평가원 요양종별 코드체계 

* [HIRA Insurance Types](CodeSystem-hira-insurance-types.md) 
건강보험심사평가원 보험자구분 코드체계 

* [HIRA Medical Department](CodeSystem-hira-medical-department.md) 
건강보험심사평가원 진료과목 코드체계 

* [KOSTAT KCD-8](CodeSystem-kostat-kcd-8.md) 
통계청 제8차 한국표준질병·사인분류표 코드체계 

* [KPIS Korea Drug Code](CodeSystem-kpis-kdcode.md) 
의약품관리종합정보센터 KD 코드체계 

* [KR Core Condition Category Types](CodeSystem-krcore-condition-category-types.md) 
KR Core 진단 및 주호소 범주 코드체계 

* [KR Core Procedure Category Types](CodeSystem-krcore-procedure-category-types.md) 
KR Core 수술 및 처치 범주 코드체계 

* [KR Core Vaccination Types](CodeSystem-krcore-vcnt-types.md) 
KR Core 예방접종 유형 코드체계 

* [MOHW Practitioner Qualification Types](CodeSystem-mohw-practitioner-qualification-types.md) 
보건복지부 면허종별/자격종별 코드체계 

#### External Links

KR Core 내에서 Concept 목록이 제공되지 않는 CodeSystem들의 원본 코드 목록을 다운로드 또는 확인할 수 있는 링크는 다음과 같다.

* HIRA EDI Material 
* [참조 사이트](https://www.hira.or.kr/rc/drug/insuadtcrtr/bbsView.do?pgmid=HIRAA030069000400&brdScnBltNo=4&brdBltNo=52388&pageIndex=2&isPopupYn=Y)
* 2023년 5월 1일 버전 이상을 사용할 것을 권장함
 
* HIRA EDI Medication 
* [참조 사이트](https://www.hira.or.kr/bbsDummy.do?pgmid=HIRAA030014050000&brdScnBltNo=4&brdBltNo=1665&pageIndex=1&pageIndex2=1#none)
* 2023년 5월 4일 버전 이상을 사용할 것을 권장함
 
* HIRA EDI Procedure 
* [참조 사이트](https://www.hira.or.kr/bbsDummy.do?pgmid=HIRAA020002000100&brdScnBltNo=4&brdBltNo=10217&pageIndex=2&pageIndex2=2)
* 2023년 5월 1일 버전 이상을 사용할 것을 권장함
 
* KOSTAT KCD-8 
* [참조 사이트](http://kssc.kostat.go.kr/ksscNew_web/kssc/common/CommonBoardList.do?gubun=1&strCategoryNameCode=004&strBbsId=kcdtnr&categoryMenu=011)
 
* KPIS Korea Drug Code 
* [참조 사이트](https://biz.kpis.or.kr/kpis_biz/index.jsp?sso=ok)
 
* WHO ATC 
* [참조 사이트](https://www.hira.or.kr/bbsDummy.do?pgmid=HIRAA020002000100&brdScnBltNo=4&brdBltNo=11587&pageIndex=1&pageIndex2=1)
 
* LOINC 
* [참조 사이트](https://loinc.org/downloads/)
* 2.74 (2023-02-22) 버전 이상을 사용할 것을 권장함
 
* SNOMED CT 
* [참조 사이트](https://mlds.ihtsdotools.org/#/viewReleases/viewRelease/167)
* SNOMED CT International Edition April 2023 v1.0 (2023-04-30) 버전 이상을 사용할 것을 권장함
 

#### FHIR R4 CodeSystems

HL7 FHIR R4 기본 사양에서 제공되는 CodeSystem들의 목록을 다운로드 또는 확인할 수 있는 링크는 다음과 같다.

* [Code Systems](http://hl7.org/fhir/R4/terminologies-systems.html)

### ValueSets

KR Core에서 정의한 ValueSet은 다음과 같다.

* [ATC Codes](ValueSet-krcore-atc-codes.md) 
모든 ATC 코드를 포함한 코드집합 

* [KR Core Condition Category Codes](ValueSet-krcore-condition-category-codes.md) 
KR Core 진단 및 주호소 범주 코드집합 

* [KR Core Diagnostic Imaging Codes](ValueSet-krcore-diagnostic-imaging-codes.md) 
KR Core 진단영상검사 코드집합 

* [KR Core Doctor Qualification Codes](ValueSet-krcore-doctor-qualification-codes.md) 
KR Core 진료의 면허(자격) 종별 코드집합 

* [KR Core EDI Material Codes](ValueSet-krcore-edi-material-codes.md) 
KR Core EDI 치료재료 코드집합 

* [KR Core EDI Medication Codes](ValueSet-krcore-edi-medication-codes.md) 
KR Core EDI 약제 코드집합 

* [KR Core EDI Procedure Codes](ValueSet-krcore-edi-procedure-codes.md) 
KR Core EDI 진료행위 코드집합 

* [KR Core Organization Type Codes](ValueSet-krcore-healthcare-organization-type-codes.md) 
KR Core 요양기관 종별 구분 코드집합 

* [KR Core Insurance Types Codes](ValueSet-krcore-insurance-types-codes.md) 
KR Core 건강보험유형 구분 코드집합 

* [KR Core KCD8 Codes](ValueSet-krcore-kcd8-codes.md) 
KR Core KCD-8 코드집합 

* [KR Core Korea Drug Codes](ValueSet-krcore-korea-drug-codes.md) 
KR Core KD 코드집합 

* [KR Core Laboratory Codes](ValueSet-krcore-laboratory-codes.md) 
KR Core 진단검사 코드집합 

* [KR Core LOINC Codes](ValueSet-krcore-loinc-codes.md) 
KR Core LOINC 코드집합 

* [KR Core Medical Department Codes](ValueSet-krcore-medicaldepartment-codes.md) 
KR Core 의료인 진료과 코드집합 

* [KR Core Pathology Codes](ValueSet-krcore-pathology-codes.md) 
KR Core 병리검사 코드집합 

* [KR Core Procedure Category Codes](ValueSet-krcore-procedure-category-codes.md) 
KR Core Procedure Category 코드집합 

* [KR Core Procedure Codes](ValueSet-krcore-procedure-codes.md) 
KR Core 진료행위 코드집합 

* [KR Core SNOMED CT Codes](ValueSet-krcore-snomed-ct-codes.md) 
KR Core SNOMED CT 코드집합 

* [KR Core Vaccination Type Codes](ValueSet-krcore-vcnt-type-codes.md) 
KR Core 예방접종명 코드집합 

* [KR Core Vital Signs Codes](ValueSet-krcore-vital-signs-codes.md) 
KR Core 활력징후 및 신체 계측 항목 코드집합 

#### FHIR R4 ValueSets

HL7 FHIR R4 기본 사양에서 제공되는 ValueSet들의 목록을 다운로드 또는 확인할 수 있는 링크는 다음과 같다.

* [Value Sets](http://hl7.org/fhir/R4/terminologies-valuesets.html)

