# Home - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core | *Version*:2.0.0 |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KR_Core_IG |

### 소개

KR Core는 국내 보건의료데이터 교류의 상호운용성과 데이터의 질을 보장하기 위한 한국형 FHIR IG(상세규격)로, [HL7 FHIR R4](https://hl7.org/fhir/R4/)를 기반으로 하여 국내 보건의료데이터 교류에 사용하는 FHIR 리소스 및 FHIR RESTful API에 대한 최소한의 제약조건을 정의한다. KR Core는 KR CDI(한국형 핵심교류데이터)의 요구사항에 따라 국내 보건의료데이터 교류 시스템이 갖추어야 할 공통 요구사항을 정의함으로써, 시스템간 상호운용성을 확보하고 데이터를 유의미하게 활용할 수 있는 토대를 마련한다. 이를 통해 국내 보건의료데이터 교류를 촉진하고 특정 사용 사례에 대한 추가 제약조건 개발을 용이하게 한다.

### 배경

세계 각 국가들은 국가차원의 FHIR IG를 개발하여 자국의 의료정보교류 상호운용성 확보와 더불어 의료데이터의 질을 높이기 위해 노력하고 있다. 이러한 FHIR IG의 대표적인 예로는 US Core(미국), AU Base(호주), UK Core(영국), CH Core(스위스) 등이 있고, 이 외에도 캐나다, 이탈리아, 인도 등 많은 나라들이 국가수준의 FHIR IG를 개발 중이다.

KR Core는 대한민국에서 보건의료정보의 교환을 위한 기본 FHIR IG(상세규격)로, 보건복지부 고시인 [보건의료데이터 용어 및 전송 표준](https://www.law.go.kr/LSW/admRulLsInfoP.do?admRulId=62344&efYd=0)의 한국 핵심교류데이터(KR CDI)를 근간으로 개발되었으며 그 목적은 다음과 같다.

* 국내 보건의료 환경에 맞는 FHIR IG를 개발하여 국내 보건의료데이터 교류 생태계 기반을 마련
* 국내 의료정보교류 상호운용성 확보와 의료데이터 질 향상
* 특정 사용 사례에 대한 기반 정보모델 제공
* SMART on FHIR, Blue Button 2.0 등과 같은 다양한 헬스케어 서비스 개발의 활성화

### 문서의 내용 및 안내

KR Core는 한국에서 사용하는 FHIR 리소스 및 FHIR RESTful API 등을 정의하고 이에 대한 상세한 설명을 문서화하여 제공한다.

KR Core를 구성하는 문서의 목록과 각 문서의 내용은 다음과 같다.

* [IG Home](./index.md): 본 페이지. KR Core에 대한 소개 및 개발 배경 등에 관한 정보 제공.
* Conformance: KR Core 적합성을 준수하기 위한 규칙들을 제공. 
* [KR CDI](./kr_cdi.md): 한국 핵심교류데이터(KR CDI)에 대한 설명과 KR CDI 분류(Class)에 대응되는 KR Core Profile 정의 테이블을 제공.
* [General Requirements](./general_requirements.md): KR Core를 따르는 모든 시스템과 Profile에 대한 공통적인 요구사항을 설명.
* [Element Support and Responsibilities](./element_support_and_responsibilities.md): KR Core 기반 시스템 구현과 활용을 위해, 의무 요소와 필수 지원 요소, 그리고 구현 지침을 해석하고 적용하여 시스템에서 지원하기 위한 방법을 설명.
 
* Guidance: 사용 사례 별로 KR Core Profile과 기능에 대한 사용 지침을 제공. 
* [Key Terms](./key_terms.md): KR Core Implementation Guide에서 사용한 주요 용어와 표현들에 대해 간략한 설명을 제공.
* [General Guidance](./general_guidance.md): KR Core Profile과 기능을 사용하는 모든 시스템에 대한 공통 지침과 요구사항을 정의.
 
* FHIR Artifacts: KR Core에서 정의한 모든 FHIR 리소스에 대한 상세한 설명 및 정의를 제공. 
* [Profiles and Extensions](./profiles_and_extensions.md): KR Core에서 정의한 Profile 및 확장 목록을 제공함. 각 Profile 페이지는 의무 요소 및 필수 지원 요소, 사용 가능한 검색 인자 목록 등을 제공.
* [Search Parameters](./search_parameters.md): KR Core에서 제공하는 검색 인자 목록을 제공. 각 검색 인자는 검색 유형 및 검색 대상이 되는 리소스와 요소, 구현 기대치 등을 정의함.
* [Terminology](./terminology.md): KR Core에서 활용하고 있는 NamingSystem, CodeSystem 및 ValueSet 리소스 목록 제공.
* [Actor Definitions](./actor_definitions.md): KR Core Implementation Guide에서 보건의료데이터 교류에 참여하는 시스템의 역할을 정의.
* [Capability Statements](./capability_statements.md): KR Core Implementation Guide를 준수하기 위해 각 유형의 시스템이 갖추어야 할 구체적인 기능(capabilities)을 정의.
 
* [Examples](./examples.md): KR Core를 적용한 시스템에서 생성 및 활용하는 FHIR Resource 예제를 제공. 각 FHIR Resource 예제는 하나 이상의 KR Core Profile을 준수함.
* [Downloads](./downloads.md): 다운로드 가능한 산출물에 대한 링크를 제공.
* [Change Log](./change_log.md): KR Core 버전 별 수정 사항을 제공.
* [History](http://www.hl7korea.or.kr/fhir/krcore/history.html): KR Core 버전 별 설명과 링크를 제공.

### KR Core Actors

다음의 ActorDefinition들은 KR Core Implementation Guide에서 보건의료데이터 교류에 참여하는 시스템의 역할을 정의한다.

* [KR Core Client Actor](ActorDefinition-krcore-actordefinition-client.md) 
KR Core Server는 보건의료데이터 생성(create), 수정(update), 읽기(read), 검색(search) 요청을 시작하는 역할을 한다. 이 역할이 지원해야 하는 기능은 [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md)에 정의되어 있다.
* [KR Core Server Actor](ActorDefinition-krcore-actordefinition-server.md) 
KR Core Server는 보건의료데이터 생성(create), 수정(update), 읽기(read), 검색(search) 요청에 대한 응답을 제공하는 역할을 한다. 이 역할이 지원해야 하는 기능은 [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)에 정의되어 있다.

### KR Core CapabilityStatements

다음의 CapabilityStatement들은 KR Core Implementation Guide를 준수하기 위해 각 유형의 시스템이 갖추어야 할 구체적인 기능(capabilities)을 정의한다. KR Core Implementation Guide 적합성을 준수하는 시스템은 아래에 나열된 하나 이상의 CapabilityStatement를 준수하고 있음을 명시적으로 밝혀야한다.

* [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) 
이 CapabilityStatement는 보건의료데이터 생성(create), 수정(update), 읽기(read), 검색(search) 요청을 시작하는 역할을 담당하는 **KR Core Client**에 대한 기본 규칙을 설명한다. KR Core Client가 지원해야 하는 KR Core Profile, RESTful API, 검색 인자(Search Parameter)의 전체 목록은 이 CapabilityStatement에 정의되어 있다.
* [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md) 
이 CapabilityStatement는 보건의료데이터 생성(create), 수정(update), 읽기(read), 검색(search) 요청에 응답하는 역할을 담당하는 **KR Core Server**에 대한 기본 규칙을 설명한다. KR Core Server가 지원해야 하는 하는 KR Core Profile, RESTful API, 검색 인자(Search Parameter)의 전체 목록은 이 CapabilityStatement에 정의되어 있다.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.kr.core",
  "language" : "ko",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core",
  "version" : "2.0.0",
  "name" : "KR_Core_IG",
  "title" : "KR Core Implementation Guide",
  "status" : "active",
  "date" : "2025-08-29",
  "publisher" : "HL7 Korea",
  "contact" : [
    {
      "name" : "HL7 Korea",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7korea.or.kr/"
        },
        {
          "system" : "email",
          "value" : "hl7korea@gmail.com"
        }
      ]
    },
    {
      "name" : "Korea Health Information Service (Project Sponsor)",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://k-his.or.kr/",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "HealthAll Inc. (STU1, STU2 Developer)",
      "telecom" : [
        {
          "system" : "phone",
          "value" : "82-53-384-8590",
          "use" : "work"
        },
        {
          "system" : "email",
          "value" : "contact@healthall.co.kr",
          "use" : "work"
        },
        {
          "system" : "url",
          "value" : "https://www.healthall.co.kr/",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "KR Core",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.kr.core",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_uv_smart_app_launch",
      "uri" : "http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch",
      "packageId" : "hl7.fhir.uv.smart-app-launch",
      "version" : "2.0.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2022+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 2"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU2"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "i18n-default-lang"
          },
          {
            "url" : "value",
            "valueString" : "ko-KR"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "CodeSystem/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "ValueSet/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "ConceptMap/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "NamingSystem/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "SearchParameter/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/fhir/krcore"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/Identifier/mohw-md-license-id"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/mohw-practitioner-license-types"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/mohw-practitioner-qualification-types"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/hira-insurance-types"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/hira-medical-department"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/hira-healthcare-organization-types"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/hira-edi-material"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/hira-edi-procedure"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/hira-edi-medication"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/Identifier/hira-krnpi"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/kostat-kcd-8"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/kpis-kdcode"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/kdca-vcnt-types"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/fhir/krcore/CodeSystem/krcore-condition-category-types"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "default-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/fhir/krcore/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.9.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2022+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 2"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU2"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "i18n-default-lang"
          },
          {
            "url" : "value",
            "valueString" : "ko-KR"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "CodeSystem/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "ValueSet/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "ConceptMap/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "NamingSystem/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "SearchParameter/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/fhir/krcore"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/Identifier/mohw-md-license-id"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/mohw-practitioner-license-types"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/mohw-practitioner-qualification-types"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/hira-insurance-types"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/hira-medical-department"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/hira-healthcare-organization-types"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/hira-edi-material"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/hira-edi-procedure"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/hira-edi-medication"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/Identifier/hira-krnpi"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/kostat-kcd-8"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/kpis-kdcode"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/CodeSystem/kdca-vcnt-types"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/fhir/krcore/CodeSystem/krcore-condition-category-types"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "default-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://www.hl7korea.or.kr/fhir/krcore/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-atc-codes"
        },
        "name" : "ATC Codes",
        "description" : "모든 ATC 코드를 포함한 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hira-edi-material"
        },
        "name" : "HIRA EDI Material",
        "description" : "건강보험심사평가원 EDI 치료재료 코드체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hira-edi-medication"
        },
        "name" : "HIRA EDI Medication",
        "description" : "건강보험심사평가원 EDI 약제 코드체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hira-edi-procedure"
        },
        "name" : "HIRA EDI Procedure",
        "description" : "건강보험심사평가원 EDI 진료행위 코드체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hira-healthcare-organization-types"
        },
        "name" : "HIRA Healthcare Organization Types",
        "description" : "건강보험심사평가원 요양종별 코드체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hira-insurance-types"
        },
        "name" : "HIRA Insurance Types",
        "description" : "건강보험심사평가원 보험자구분 코드체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hira-medical-department"
        },
        "name" : "HIRA Medical Department",
        "description" : "건강보험심사평가원 진료과목 코드체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/kostat-kcd-8"
        },
        "name" : "KOSTAT KCD-8",
        "description" : "통계청 제8차 한국표준질병·사인분류표 코드체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/kpis-kdcode"
        },
        "name" : "KPIS Korea Drug Code",
        "description" : "의약품관리종합정보센터 KD 코드체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-allergyintolerance"
        },
        "name" : "KR Core AllergyIntolerance Profile",
        "description" : "KR Core AllergyIntolerance Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 알레르기 및 불내성 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n알레르기 및 불내성 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/krcore-actordefinition-client"
        },
        "name" : "KR Core Client",
        "description" : "KR Core Client는 KR Core의 요구사항을 충족하는 FHIR 리소스를 교류하기 위해, 데이터 접근을 요청하는 시스템이다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/krcore-capabilitystatement-client"
        },
        "name" : "KR Core Client CapabilityStatement",
        "description" : "이 CapabilityStatement는 보건의료데이터 생성(create), 수정(update), 읽기(read), 검색(search) 요청을 시작하는 역할을 담당하는 **KR Core Client**에 대한 기본 규칙을 설명한다. KR Core Client가 지원해야 하는 KR Core Profile, RESTful API, 검색 인자(Search Parameter)의 전체 목록은 이 CapabilityStatement에 정의되어 있다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-condition-category-codes"
        },
        "name" : "KR Core Condition Category Codes",
        "description" : "KR Core 진단 및 주호소 범주 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/krcore-condition-category-types"
        },
        "name" : "KR Core Condition Category Types",
        "description" : "KR Core 진단 및 주호소 범주 코드체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-condition-chief-complaint"
        },
        "name" : "KR Core Condition Profile for Chief Complaint",
        "description" : "KR Core Condition Profile for Chief Complaint는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 주호소 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n주호소 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-condition-encounter-diagnosis"
        },
        "name" : "KR Core Condition Profile for Encounter Diagnosis",
        "description" : "KR Core Condition Profile for Encounter Diagnosis는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진단 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n진단 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-diagnostic-imaging-codes"
        },
        "name" : "KR Core Diagnostic Imaging Codes",
        "description" : "KR Core 진단영상검사 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-diagnosticreport-diagnostic-imaging"
        },
        "name" : "KR Core DiagnosticReport Profile for Diagnostic Imaging",
        "description" : "KR Core DiagnosticReport Profile for Diagnostic Imaging은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진단영상검사 중 진단보고서 관련 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n진단영상검사 중 진단보고서 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-diagnosticreport-function-tests"
        },
        "name" : "KR Core DiagnosticReport Profile for Functional Tests",
        "description" : "KR Core DiagnosticReport Profile for Functional Tests는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 기능검사 중 진단보고서 관련 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n기능검사 중 진단보고서 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-diagnosticreport-laboratory-results"
        },
        "name" : "KR Core DiagnosticReport Profile for Laboratory Results",
        "description" : "KR Core DiagnosticReport Profile for Laboratory Results는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진단검사 중 진단보고서 관련 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n진단검사 중 진단보고서 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-diagnosticreport-pathology-results"
        },
        "name" : "KR Core DiagnosticReport Profile for Pathology Results",
        "description" : "KR Core DiagnosticReport Profile for Pathology Results는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 병리검사 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n병리검사 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-doctor-qualification-codes"
        },
        "name" : "KR Core Doctor Qualification Codes",
        "description" : "KR Core 진료의 면허(자격) 종별 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-edi-material-codes"
        },
        "name" : "KR Core EDI Material Codes",
        "description" : "KR Core EDI 치료재료 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-edi-medication-codes"
        },
        "name" : "KR Core EDI Medication Codes",
        "description" : "KR Core EDI 약제 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-edi-procedure-codes"
        },
        "name" : "KR Core EDI Procedure Codes",
        "description" : "KR Core EDI 진료행위 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-encounter"
        },
        "name" : "KR Core Encounter Profile",
        "description" : "KR Core Encounter Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때, 환자와 의사 간의 대면, 접촉, 만남, 혹은 의료 서비스 과정 전체에 대한 시간적·공간적 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n진료 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-healthcare-organization"
        },
        "name" : "KR Core Healthcare Organization Profile",
        "description" : "KR Core Healthcare Organization Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 의료기관 정보를 표현하는 데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n본 Profile은 병원, 보건소, 약국 등 건강보험심사평가원에서 요양기관으로 분류한 기관을 표현하기 위해 [KR Core Organization Profile](StructureDefinition-krcore-organization.html)을\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Organization Profile을 만족한다.\n\n\n※ 주의사항\n+ KR Core Organization Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-imagingstudy"
        },
        "name" : "KR Core ImagingStudy Profile",
        "description" : "KR Core ImagingStudy Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진단영상검사 중 영상검사 관련 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n진단영상검사 중 영상검사 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-immunization"
        },
        "name" : "KR Core Immunization Profile",
        "description" : "KR Core Immunization Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 예방접종 내역 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n예방접종 내역 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-insurance-types-codes"
        },
        "name" : "KR Core Insurance Types Codes",
        "description" : "KR Core 건강보험유형 구분 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-insuranceTypes"
        },
        "name" : "KR Core Insurance Types Extension",
        "description" : "KR Core Insurance Types Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 환자의 건강보험유형 정보를 표현하는데 사용되며, 이 경우 **반드시(SHALL)** 본 Extension을 적용한다.\n\n※ 침고사항\n+ 환자의 건강보험유형은 진료 시점에 종속되므로, FHIR Patient 리소스 인스턴스가 아닌 FHIR Encounter 리소스 인스턴스에 본 Extension을 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-kcd8-codes"
        },
        "name" : "KR Core KCD8 Codes",
        "description" : "KR Core KCD-8 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-korea-drug-codes"
        },
        "name" : "KR Core Korea Drug Codes",
        "description" : "KR Core KD 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-laboratory-codes"
        },
        "name" : "KR Core Laboratory Codes",
        "description" : "KR Core 진단검사 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-loinc-codes"
        },
        "name" : "KR Core LOINC Codes",
        "description" : "KR Core LOINC 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-medicaldepartment-codes"
        },
        "name" : "KR Core Medical Department Codes",
        "description" : "KR Core 의료인 진료과 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-medicationIngredient"
        },
        "name" : "KR Core Medication Ingredient Extension",
        "description" : "KR Core Medication Ingredient Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 처방정보 내에서 약품 성분명 정보를 표현하는데 사용되며, 이 경우 아래의 조건에 따라 본 Extension을 적용한다.\n\n※ 사용조건\n+ [KR Core MedicationRequest Profile](StructureDefinition-krcore-medicationrequest.html)을 적용한 리소스 인스턴스 내에서, `MedicationRequest.medicationCodeableConcept`를 사용하여 약품 제품명을 표현하는 경우에, \n동일한 리소스 인스턴스 내에서 **반드시(SHALL)** 약품 성분명을 함께 표현해야 하며, 이를 위해 **반드시(SHALL)** 본 Extension을 사용해야 한다.\n+ KR Core MedicationRequest Profile을 적용한 리소스 인스턴스가 `MedicationRequest.medicationReference`를 사용하여 약품 제품명과 약품 성분명 정보를 간접적으로 제공한 경우에는, \n**가능한 한(SHOULD)** 본 Extension을 사용하지 않는다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-medication"
        },
        "name" : "KR Core Medication Profile",
        "description" : "KR Core Medication Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 약품 자체의 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n약품 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-medicationrequest"
        },
        "name" : "KR Core MedicationRequest Profile",
        "description" : "KR Core MedicationRequest Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 약품 처방 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n약품 처방 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-observation-function-test"
        },
        "name" : "KR Core Observation Profile for Functional Test",
        "description" : "KR Core Observation Profile for Functional Test는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 기능검사 중 검사 관련 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n기능검사 중 검사 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-observation-laboratory-result"
        },
        "name" : "KR Core Observation Profile for Laboratory Result",
        "description" : "KR Core Observation Profile for Laboratory Result는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진단검사 중 검사 관련 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n진단검사 중 검사 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.\n\n\n※ 참고<br />\n본 Profile은 KR CDI V2 병리검사 정보를 직접적으로 다루고 있지는 않지만, FHIR Observation 리소스를 사용해 병리검사 세부 결과를 표현할 경우, Observation.category 값을 일반적으로 `laboratory`로 설정한다.\n이에 따라 본 Profile은 병리검사 세부 결과 표현 시 구조적 참고 자료로 활용할 수 있다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-vitalsigns"
        },
        "name" : "KR Core Observation Profile for Vital Signs",
        "description" : "KR Core Observation Profile for Vital Signs는 KR Core Server와 KR Core Client의 진료정보를 교류할 때 \n환자를 대상으로하는 다양한 활력징후 및 신체 계측 정보를 일관되게 표현하는데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n단, 아래의 목록에 해당하는 활력징후 및 신체 계측 정보는 본 Profile을 상속하여 정의한 세부 Profile들을 **반드시(SHALL)** 적용해야 한다.\n아래의 세부 Profile들을 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다.\n\n+ 활력징후 및 신체 계측 정보별 세부 Profile 목록\n  + 수축기 혈압 및 이완기 혈압 - [KR Core Observation Profile for Vital Signs: Blood Pressure](StructureDefinition-krcore-bloodpressure.html)\n  + 키 - [KR Core Observation Profile for Vital Signs: Body Height](StructureDefinition-krcore-bodyheight.html)\n  + 체온 - [KR Core Observation Profile for Vital Signs: Body Temperature](StructureDefinition-krcore-bodytemperature.html)\n  + 몸무게 - [KR Core Observation Profile for Vital Signs: Body Weight](StructureDefinition-krcore-bodyweight.html)\n  + 맥박수 - [KR Core Observation Profile for Vital Signs: Heart Rate](StructureDefinition-krcore-heartrate.html)\n  + 산소포화도 - [KR Core Observation Profile for Vital Signs: Pulse Oximetry](StructureDefinition-krcore-pulseoximeter.html)\n  + 호흡수 - [KR Core Observation Profile for Vital Signs: Respiratory Rate](StructureDefinition-krcore-respiratoryrate.html)\n\n\n※ 주의사항\n+ KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-bloodpressure"
        },
        "name" : "KR Core Observation Profile for Vital Signs: Blood Pressure",
        "description" : "본 Profile은 환자를 대상으로 측정한 수축기 혈압 및 이완기 혈압을 표현하기 위해 [KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.html)를\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.\n\n\n※ 주의사항\n+ KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-bodyheight"
        },
        "name" : "KR Core Observation Profile for Vital Signs: Body Height",
        "description" : "본 Profile은 환자를 대상으로 측정한 키를 표현하기 위해 [KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.html)를\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.\n\n\n※ 주의사항\n+ KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-bodytemperature"
        },
        "name" : "KR Core Observation Profile for Vital Signs: Body Temperature",
        "description" : "본 Profile은 환자를 대상으로 측정한 체온을 표현하기 위해 [KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.html)를\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.\n\n\n※ 주의사항\n+ KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-bodyweight"
        },
        "name" : "KR Core Observation Profile for Vital Signs: Body Weight",
        "description" : "본 Profile은 환자를 대상으로 측정한 몸무게를 표현하기 위해 [KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.html)를\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.\n\n\n※ 주의사항\n+ KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-heartrate"
        },
        "name" : "KR Core Observation Profile for Vital Signs: Heart Rate",
        "description" : "본 Profile은 환자를 대상으로 측정한 맥박수를 표현하기 위해 [KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.html)를\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.\n\n\n※ 주의사항\n+ KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-pulseoximetry"
        },
        "name" : "KR Core Observation Profile for Vital Signs: Pulse Oximetry",
        "description" : "본 Profile은 환자를 대상으로 측정한 산소포화도를 표현하기 위해 [KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.html)를\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.\n\n\n※ 주의사항\n+ KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-respiratoryrate"
        },
        "name" : "KR Core Observation Profile for Vital Signs: Respiratory Rate",
        "description" : "본 Profile은 환자를 대상으로 측정한 호흡수를 표현하기 위해 [KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.html)를\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.\n\n\n※ 주의사항\n+ KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-organization"
        },
        "name" : "KR Core Organization Profile",
        "description" : "KR Core Organization Profile은 KR Core Server와 KR Core Client의 진료정보 교류 과정에 참여하는\n다양한 기관 및 부서를 일관되게 표현하는데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n임상 행위, 진료 흐름, 환자 정보 처리, 의료 데이터 관리에 공식적으로 참여하는 모든 조직 단위를 표현하는데 이 Profile을 적용할 수 있다.\n단, 병원, 보건소, 약국 등 건강보험심사평가원에서 요양기관으로 분류한 기관을 표현하기 위해서는 본 Profile을 상속하여 정의한\n[KR Core Healthcare Organization Profile](StructureDefinition-krcore-healthcare-organization.html)을\n**반드시(SHALL)** 적용해야 한다. KR Core Healthcare Organization Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다.\n\n\n※ 주의사항\n+ KR Core Organization Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-healthcare-organization-type-codes"
        },
        "name" : "KR Core Organization Type Codes",
        "description" : "KR Core 요양기관 종별 구분 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-pathology-codes"
        },
        "name" : "KR Core Pathology Codes",
        "description" : "KR Core 병리검사 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-patient"
        },
        "name" : "KR Core Patient Profile",
        "description" : "KR Core Patient Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 환자 정보를 표현하는 데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-practitioner"
        },
        "name" : "KR Core Practitioner Profile",
        "description" : "KR Core Practitioner Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 보건의료 환경에서 실질적으로 진료 과정에 참여하는\n다양한 인력을 일관되게 표현하는데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n임상 행위, 진료 흐름, 환자 정보 처리, 의료 데이터 관리에 공식적으로 참여하는 모든 인력을 표현하는데 이 Profile을 적용할 수 있다.\n단, 의료법에 따라 자격이 부여된 의사(Medical Doctor)를 표현하기 위해서는 본 Profile을 상속하여 정의한\n[KR Core Practitioner Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor.html)를\n**반드시(SHALL)** 적용해야 한다. KR Core Practitioner Profile for Medical Doctor를 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다.\n\n\n※ 주의사항\n+ KR Core Practitioner Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-medical-doctor"
        },
        "name" : "KR Core Practitioner Profile for Medical Doctor",
        "description" : "KR Core Practitioner Profile for Medical Doctor는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진료의 정보를 표현하는 데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n본 Profile은 의료법에 따라 자격이 부여된 의사(Medical Doctor)를 표현하기 위해 [KR Core Practitioner Profile](StructureDefinition-krcore-practitioner.html)을\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Practitioner Profile을 만족한다.\n\n\n※ 주의사항\n+ KR Core Practitioner Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-practitioner-role"
        },
        "name" : "KR Core PractitionerRole Profile",
        "description" : "KR Core PractitionerRole Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 보건의료 환경에서 실질적으로 진료 과정에 참여하는\n다양한 인력의 역할을 일관되게 표현하는데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n임상 행위, 진료 흐름, 환자 정보 처리, 의료 데이터 관리에 공식적으로 참여하는 모든 인력의 역할을 표현하는데 이 Profile을 적용할 수 있다.\n단, 의료법에 따라 자격이 부여된 의사(Medical Doctor)의 역할을 표현하기 위해서는 본 Profile을 상속하여 정의한\n[KR Core PractitionerRole Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor-role.html)를\n**반드시(SHALL)** 적용해야 한다. KR Core PractitionerRole Profile for Medical Doctor를 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다.\n\n\n※ 주의사항\n+ KR Core PractitionerRole Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자의 역할 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-medical-doctor-role"
        },
        "name" : "KR Core PractitionerRole Profile for Medical Doctor",
        "description" : "KR Core PractitionerRole Profile for Medical Doctor는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진료의의 역할 정보를 표현하는 데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n본 Profile은 의료법에 따라 자격이 부여된 의사(Medical Doctor)의 역할을 표현하기 위해 [KR Core PractitionerRole Profile](StructureDefinition-krcore-practitioner-role.html)을\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core PractitionerRole Profile을 만족한다.\n\n\n※ 주의사항\n+ KR Core PractitionerRole Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자의 역할 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-procedure-category-codes"
        },
        "name" : "KR Core Procedure Category Codes",
        "description" : "KR Core Procedure Category 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/krcore-procedure-category-types"
        },
        "name" : "KR Core Procedure Category Types",
        "description" : "KR Core 수술 및 처치 범주 코드체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-procedure-codes"
        },
        "name" : "KR Core Procedure Codes",
        "description" : "KR Core 진료행위 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-procedure"
        },
        "name" : "KR Core Procedure Profile",
        "description" : "KR Core Procedure Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 수술, 처치 그리고 마취 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n진료 행위 정보 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-roadNameAddress"
        },
        "name" : "KR Core Road Name Address Extension",
        "description" : "KR Core Road Name Address Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 한국의 도로명 주소 정보를 표현하는데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Extension을 적용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/krcore-actordefinition-server"
        },
        "name" : "KR Core Server",
        "description" : "KR Core Server는 KR Core Client(KR Core 요청자)의 요청에 따라, KR Core Profile을 준수하는 FHIR 리소스를 제공하는 시스템이다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/krcore-capabilitystatement-server"
        },
        "name" : "KR Core Server CapabilityStatement",
        "description" : "이 CapabilityStatement는 보건의료데이터 생성(create), 수정(update), 읽기(read), 검색(search) 요청에 응답하는 역할을 담당하는 **KR Core Server**에 대한 기본 규칙을 설명한다. KR Core Server가 지원해야 하는 하는 KR Core Profile, RESTful API, 검색 인자(Search Parameter)의 전체 목록은 이 CapabilityStatement에 정의되어 있다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-snomed-ct-codes"
        },
        "name" : "KR Core SNOMED CT Codes",
        "description" : "KR Core SNOMED CT 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-specimen"
        },
        "name" : "KR Core Specimen Profile",
        "description" : "KR Core Specimen Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 검체 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n검체 정보 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/krcore-testRequestDateTime"
        },
        "name" : "KR Core Test Request DateTime Extension",
        "description" : "KR Core Test Request DateTime Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 검사의뢰일 정보를 표현하는데 사용되며, 이 경우 아래의 조건에 따라 본 Extension을 적용한다.\n\n※ 사용조건\n+ [KR Core DiagnosticReport Profile for Functional Tests](StructureDefinition-krcore-diagnosticreport-function-tests.html)를 적용한 리소스 인스턴스는 **반드시(SHALL)** 본 Extension을 사용해서 기능검사 일자를 표현한다.\n+ [KR Core DiagnosticReport Profile for Pathology Results](StructureDefinition-krcore-diagnosticreport-pathology-results.html)를 적용한 리소스 인스턴스는 **반드시(SHALL)** 본 Extension을 사용해서 병리검사 의뢰일을 표현한다.\n+ 그 외 FHIR Diagnostic 리소스 인스턴스 내에 검사의뢰일 또는 검사일 정보를 표현하는 경우, **가능한 한(SHOULD)** 본 Extension을 사용한다.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-vcnt-type-codes"
        },
        "name" : "KR Core Vaccination Type Codes",
        "description" : "KR Core 예방접종명 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/krcore-vcnt-types"
        },
        "name" : "KR Core Vaccination Types",
        "description" : "KR Core 예방접종 유형 코드체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/krcore-vital-signs-codes"
        },
        "name" : "KR Core Vital Signs Codes",
        "description" : "KR Core 활력징후 및 신체 계측 항목 코드집합",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-allergyintolerance-category"
        },
        "name" : "krcore-sp-allergyintolerance-category",
        "description" : "알레르기 및 불내성 원인구분",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-allergyintolerance-clinical-status"
        },
        "name" : "krcore-sp-allergyintolerance-clinical-status",
        "description" : "알레르기 및 불내성 상태: active \\| inactive \\| resolved",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-allergyintolerance-code"
        },
        "name" : "krcore-sp-allergyintolerance-code",
        "description" : "원인물질 등 알레르기 및 불내성 반응 코드",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-allergyintolerance-manifestation"
        },
        "name" : "krcore-sp-allergyintolerance-manifestation",
        "description" : "알레르기 및 불내성 증상",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-allergyintolerance-onset"
        },
        "name" : "krcore-sp-allergyintolerance-onset",
        "description" : "알레르기 및 불내성 발생일 또는 개별 증상 발생일",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-allergyintolerance-patient"
        },
        "name" : "krcore-sp-allergyintolerance-patient",
        "description" : "알레르기 및 불내성 정보의 대상 환자",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-condition-category"
        },
        "name" : "krcore-sp-condition-category",
        "description" : "진단 및 주호소 범주",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-condition-clinical-status"
        },
        "name" : "krcore-sp-condition-clinical-status",
        "description" : "진단 및 주호소 임상적 상태: active \\| recurrence \\| relapse \\| inactive \\| remission \\| resolved",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-condition-code"
        },
        "name" : "krcore-sp-condition-code",
        "description" : "진단 및 주호소 상태를 식별하는 코드",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-diagnosticreport-result"
        },
        "name" : "krcore-sp-diagnosticreport-result",
        "description" : "진단보고를 위한 검사 결과",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-diagnosticreport-specimen"
        },
        "name" : "krcore-sp-diagnosticreport-specimen",
        "description" : "본 진단보고에 사용된 검체",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-diagnosticreport-study"
        },
        "name" : "krcore-sp-diagnosticreport-study",
        "description" : "진단보고를 위한 진단영상",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-encounter-status"
        },
        "name" : "krcore-sp-encounter-status",
        "description" : "내원 상태: planned \\| arrived \\| triaged \\| in-progress \\| onleave \\| finished \\| cancelled \\+",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-imagingstudy-modality"
        },
        "name" : "krcore-sp-imagingstudy-modality",
        "description" : "DICOM 촬영 장비",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-imagingstudy-series"
        },
        "name" : "krcore-sp-imagingstudy-series",
        "description" : "DICOM Series UID",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-immunization-dose-number"
        },
        "name" : "krcore-sp-immunization-dose-number",
        "description" : "예방 접종 차수",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-immunization-status"
        },
        "name" : "krcore-sp-immunization-status",
        "description" : "예방 접종 상태",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-medicationrequest-authoredon"
        },
        "name" : "krcore-sp-medicationrequest-authoredon",
        "description" : "약물 처방 일시",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-medicationrequest-intent"
        },
        "name" : "krcore-sp-medicationrequest-intent",
        "description" : "약물 처방 의도",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-medicationrequest-medication"
        },
        "name" : "krcore-sp-medicationrequest-medication",
        "description" : "처방한 약물",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-observation-code"
        },
        "name" : "krcore-sp-observation-code",
        "description" : "관찰 및 측정의 유형",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-observation-component-code"
        },
        "name" : "krcore-sp-observation-component-code",
        "description" : "세부 관찰 및 측정의 유형",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-observation-component-code-value-concept"
        },
        "name" : "krcore-sp-observation-component-code-value-concept",
        "description" : "세부 관찰 및 측정의 유형과 CodeableConcept 자료형으로 표현된 세부 관찰 및 측정값 쌍",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-observation-component-code-value-quantity"
        },
        "name" : "krcore-sp-observation-component-code-value-quantity",
        "description" : "세부 관찰 및 측정의 유형과 Quantity 자료형으로 표현된 세부 관찰 및 측정값 쌍",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-observation-component-data-absent-reason"
        },
        "name" : "krcore-sp-observation-component-data-absent-reason",
        "description" : "세부 관찰 및 측정 결과(Observation.component.value[x]) 부재 사유",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-observation-component-value-concept"
        },
        "name" : "krcore-sp-observation-component-value-concept",
        "description" : "CodeableConcept 자료형으로 표현된 세부 관찰 및 측정값",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-observation-performer"
        },
        "name" : "krcore-sp-observation-performer",
        "description" : "관찰 및 측정 책임자",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-observation-specimen"
        },
        "name" : "krcore-sp-observation-specimen",
        "description" : "본 관찰 및 측정에 사용된 검체",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-observation-value-date"
        },
        "name" : "krcore-sp-observation-value-date",
        "description" : "dateTime 또는 Period 자료형으로 표현된 측정값",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-organization-address"
        },
        "name" : "krcore-sp-organization-address",
        "description" : "한국 도로명 주소를 포함한 기관 주소 검색",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-organization-name"
        },
        "name" : "krcore-sp-organization-name",
        "description" : "기관 명칭",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-patient-id"
        },
        "name" : "krcore-sp-patient-id",
        "description" : "본 리소스 인스턴스의 논리적 ID",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-patient-name"
        },
        "name" : "krcore-sp-patient-name",
        "description" : "환자의 성명을 구성하는 성, 이름 등의 요소 중 일치하는 문자열",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-practitioner-name"
        },
        "name" : "krcore-sp-practitioner-name",
        "description" : "의료인의 성명을 구성하는 성, 이름 등의 요소 중 일치하는 문자열",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-practitionerrole-practitioner"
        },
        "name" : "krcore-sp-practitionerrole-practitioner",
        "description" : "의료인 인적사항",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-practitionerrole-specialty"
        },
        "name" : "krcore-sp-practitionerrole-specialty",
        "description" : "의료인 진료과목 코드",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-procedure-code"
        },
        "name" : "krcore-sp-procedure-code",
        "description" : "수술 및 처치 식별 코드",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-procedure-status"
        },
        "name" : "krcore-sp-procedure-status",
        "description" : "수술 및 처치 상태:\tpreparation \\| in-progress \\| not-done \\| on-hold \\| stopped \\| completed \\| entered-in-error \\| unknown",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/krcore-sp-specimen-bodysite"
        },
        "name" : "krcore-sp-specimen-bodysite",
        "description" : "검체 채취 부위",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/mohw-practitioner-qualification-types"
        },
        "name" : "MOHW Practitioner Qualification Types",
        "description" : "보건복지부 면허종별/자격종별 코드체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ns-hira-edi-material"
        },
        "name" : "ns-hira-edi-material",
        "description" : "건강보험심사평가원 EDI 치료재료 코드 명명체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ns-hira-edi-medication"
        },
        "name" : "ns-hira-edi-medication",
        "description" : "건강보험심사평가원 EDI 약제 코드 명명체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ns-hira-edi-procedure"
        },
        "name" : "ns-hira-edi-procedure",
        "description" : "건강보험심사평가원 EDI 진료행위 코드 명명체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ns-hira-healthcare-organization-identifier"
        },
        "name" : "ns-hira-healthcare-organization-identifier",
        "description" : "건강보험심사평가원 요양기관 식별자 명명체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ns-hira-healthcare-organization-types"
        },
        "name" : "ns-hira-healthcare-organization-types",
        "description" : "건강보험심사평가원 요양종별 코드 명명체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ns-hira-insurance-types"
        },
        "name" : "ns-hira-insurance-types",
        "description" : "건강보험심사평가원 보험자구분 코드 명명체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ns-hira-medical-department"
        },
        "name" : "ns-hira-medical-department",
        "description" : "건강보험심사평가원 진료과목 코드 명명체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ns-kostat-kcd-8"
        },
        "name" : "ns-kostat-kcd-8",
        "description" : "통계청 제8차 한국표준질병·사인분류표 코드 명명체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ns-kpis-kdcode"
        },
        "name" : "ns-kpis-kdcode",
        "description" : "의약품관리종합정보센터 KD 코드 명명체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ns-mohw-md-license-id"
        },
        "name" : "ns-mohw-md-license-id",
        "description" : "보건복지부 진료의 면허 식별자 명명체계",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ns-mohw-practitioner-qualification-types"
        },
        "name" : "ns-mohw-practitioner-qualification-types",
        "description" : "보건복지부 자격종별 코드 명명체계",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "actor_definitions.html"
            }
          ],
          "nameUrl" : "actor_definitions.html",
          "title" : "Actor Definitions",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "capability_statements.html"
            }
          ],
          "nameUrl" : "capability_statements.html",
          "title" : "Capability Statements",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "change_log.html"
            }
          ],
          "nameUrl" : "change_log.html",
          "title" : "Change Log",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "element_support_and_responsibilities.html"
            }
          ],
          "nameUrl" : "element_support_and_responsibilities.html",
          "title" : "Element Support and Responsibilities",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "extra_codesystems.html"
            }
          ],
          "nameUrl" : "extra_codesystems.html",
          "title" : "Extra Codesystems",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "general_guidance.html"
            }
          ],
          "nameUrl" : "general_guidance.html",
          "title" : "General Guidance",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "general_requirements.html"
            }
          ],
          "nameUrl" : "general_requirements.html",
          "title" : "General Requirements",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "key_terms.html"
            }
          ],
          "nameUrl" : "key_terms.html",
          "title" : "Key Terms",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "kr_cdi.html"
            }
          ],
          "nameUrl" : "kr_cdi.html",
          "title" : "Kr Cdi",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "namingsystems.html"
            }
          ],
          "nameUrl" : "namingsystems.html",
          "title" : "Namingsystems",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "profiles_and_extensions.html"
            }
          ],
          "nameUrl" : "profiles_and_extensions.html",
          "title" : "Profiles and Extensions",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters.html"
            }
          ],
          "nameUrl" : "search_parameters.html",
          "title" : "Search Parameters",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_allergyintolerance_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_allergyintolerance_derived.html",
          "title" : "Search Parameters Allergyintolerance Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_condition_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_condition_derived.html",
          "title" : "Search Parameters Condition Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_diagnosticreport_defined.html"
            }
          ],
          "nameUrl" : "search_parameters_diagnosticreport_defined.html",
          "title" : "Search Parameters Diagnosticreport Defined",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_diagnosticreport_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_diagnosticreport_derived.html",
          "title" : "Search Parameters Diagnosticreport Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_encounter_defined.html"
            }
          ],
          "nameUrl" : "search_parameters_encounter_defined.html",
          "title" : "Search Parameters Encounter Defined",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_encounter_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_encounter_derived.html",
          "title" : "Search Parameters Encounter Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_imagingstudy_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_imagingstudy_derived.html",
          "title" : "Search Parameters Imagingstudy Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_immunization_defined.html"
            }
          ],
          "nameUrl" : "search_parameters_immunization_defined.html",
          "title" : "Search Parameters Immunization Defined",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_immunization_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_immunization_derived.html",
          "title" : "Search Parameters Immunization Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_medication_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_medication_derived.html",
          "title" : "Search Parameters Medication Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_medicationrequest_defined.html"
            }
          ],
          "nameUrl" : "search_parameters_medicationrequest_defined.html",
          "title" : "Search Parameters Medicationrequest Defined",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_medicationrequest_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_medicationrequest_derived.html",
          "title" : "Search Parameters Medicationrequest Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_observation_defined.html"
            }
          ],
          "nameUrl" : "search_parameters_observation_defined.html",
          "title" : "Search Parameters Observation Defined",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_observation_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_observation_derived.html",
          "title" : "Search Parameters Observation Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_organization_defined.html"
            }
          ],
          "nameUrl" : "search_parameters_organization_defined.html",
          "title" : "Search Parameters Organization Defined",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_organization_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_organization_derived.html",
          "title" : "Search Parameters Organization Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_patient_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_patient_derived.html",
          "title" : "Search Parameters Patient Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_practitioner_defined.html"
            }
          ],
          "nameUrl" : "search_parameters_practitioner_defined.html",
          "title" : "Search Parameters Practitioner Defined",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_practitioner_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_practitioner_derived.html",
          "title" : "Search Parameters Practitioner Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_practitionerrole_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_practitionerrole_derived.html",
          "title" : "Search Parameters Practitionerrole Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_procedure_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_procedure_derived.html",
          "title" : "Search Parameters Procedure Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search_parameters_specimen_derived.html"
            }
          ],
          "nameUrl" : "search_parameters_specimen_derived.html",
          "title" : "Search Parameters Specimen Derived",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "terminology.html"
            }
          ],
          "nameUrl" : "terminology.html",
          "title" : "Terminology",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
