# Artifacts Summary - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Requirements: Actor Definitions 

The following artifacts define the types of individuals and/or systems that will interact as part of the use cases covered by this implementation guide.

| | |
| :--- | :--- |
| [KR Core Client](ActorDefinition-krcore-actordefinition-client.md) | KR Core Client는 KR Core의 요구사항을 충족하는 FHIR 리소스를 교류하기 위해, 데이터 접근을 요청하는 시스템이다. |
| [KR Core Server](ActorDefinition-krcore-actordefinition-server.md) | KR Core Server는 KR Core Client(KR Core 요청자)의 요청에 따라, KR Core Profile을 준수하는 FHIR 리소스를 제공하는 시스템이다. |

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) | 이 CapabilityStatement는 보건의료데이터 생성(create), 수정(update), 읽기(read), 검색(search) 요청을 시작하는 역할을 담당하는**KR Core Client**에 대한 기본 규칙을 설명한다. KR Core Client가 지원해야 하는 KR Core Profile, RESTful API, 검색 인자(Search Parameter)의 전체 목록은 이 CapabilityStatement에 정의되어 있다. |
| [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md) | 이 CapabilityStatement는 보건의료데이터 생성(create), 수정(update), 읽기(read), 검색(search) 요청에 응답하는 역할을 담당하는**KR Core Server**에 대한 기본 규칙을 설명한다. KR Core Server가 지원해야 하는 하는 KR Core Profile, RESTful API, 검색 인자(Search Parameter)의 전체 목록은 이 CapabilityStatement에 정의되어 있다. |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [krcore-sp-allergyintolerance-category](SearchParameter-krcore-sp-allergyintolerance-category.md) | 알레르기 및 불내성 원인구분 |
| [krcore-sp-allergyintolerance-clinical-status](SearchParameter-krcore-sp-allergyintolerance-clinical-status.md) | 알레르기 및 불내성 상태: active | inactive | resolved |
| [krcore-sp-allergyintolerance-code](SearchParameter-krcore-sp-allergyintolerance-code.md) | 원인물질 등 알레르기 및 불내성 반응 코드 |
| [krcore-sp-allergyintolerance-manifestation](SearchParameter-krcore-sp-allergyintolerance-manifestation.md) | 알레르기 및 불내성 증상 |
| [krcore-sp-allergyintolerance-onset](SearchParameter-krcore-sp-allergyintolerance-onset.md) | 알레르기 및 불내성 발생일 또는 개별 증상 발생일 |
| [krcore-sp-allergyintolerance-patient](SearchParameter-krcore-sp-allergyintolerance-patient.md) | 알레르기 및 불내성 정보의 대상 환자 |
| [krcore-sp-condition-category](SearchParameter-krcore-sp-condition-category.md) | 진단 및 주호소 범주 |
| [krcore-sp-condition-clinical-status](SearchParameter-krcore-sp-condition-clinical-status.md) | 진단 및 주호소 임상적 상태: active | recurrence | relapse | inactive | remission | resolved |
| [krcore-sp-condition-code](SearchParameter-krcore-sp-condition-code.md) | 진단 및 주호소 상태를 식별하는 코드 |
| [krcore-sp-diagnosticreport-result](SearchParameter-krcore-sp-diagnosticreport-result.md) | 진단보고를 위한 검사 결과 |
| [krcore-sp-diagnosticreport-specimen](SearchParameter-krcore-sp-diagnosticreport-specimen.md) | 본 진단보고에 사용된 검체 |
| [krcore-sp-diagnosticreport-study](SearchParameter-krcore-sp-diagnosticreport-study.md) | 진단보고를 위한 진단영상 |
| [krcore-sp-encounter-status](SearchParameter-krcore-sp-encounter-status.md) | 내원 상태: planned | arrived | triaged | in-progress | onleave | finished | cancelled + |
| [krcore-sp-imagingstudy-modality](SearchParameter-krcore-sp-imagingstudy-modality.md) | DICOM 촬영 장비 |
| [krcore-sp-imagingstudy-series](SearchParameter-krcore-sp-imagingstudy-series.md) | DICOM Series UID |
| [krcore-sp-immunization-dose-number](SearchParameter-krcore-sp-immunization-dose-number.md) | 예방 접종 차수 |
| [krcore-sp-immunization-status](SearchParameter-krcore-sp-immunization-status.md) | 예방 접종 상태 |
| [krcore-sp-medicationrequest-authoredon](SearchParameter-krcore-sp-medicationrequest-authoredon.md) | 약물 처방 일시 |
| [krcore-sp-medicationrequest-intent](SearchParameter-krcore-sp-medicationrequest-intent.md) | 약물 처방 의도 |
| [krcore-sp-medicationrequest-medication](SearchParameter-krcore-sp-medicationrequest-medication.md) | 처방한 약물 |
| [krcore-sp-observation-code](SearchParameter-krcore-sp-observation-code.md) | 관찰 및 측정의 유형 |
| [krcore-sp-observation-component-code](SearchParameter-krcore-sp-observation-component-code.md) | 세부 관찰 및 측정의 유형 |
| [krcore-sp-observation-component-code-value-concept](SearchParameter-krcore-sp-observation-component-code-value-concept.md) | 세부 관찰 및 측정의 유형과 CodeableConcept 자료형으로 표현된 세부 관찰 및 측정값 쌍 |
| [krcore-sp-observation-component-code-value-quantity](SearchParameter-krcore-sp-observation-component-code-value-quantity.md) | 세부 관찰 및 측정의 유형과 Quantity 자료형으로 표현된 세부 관찰 및 측정값 쌍 |
| [krcore-sp-observation-component-data-absent-reason](SearchParameter-krcore-sp-observation-component-data-absent-reason.md) | 세부 관찰 및 측정 결과(Observation.component.value[x]) 부재 사유 |
| [krcore-sp-observation-component-value-concept](SearchParameter-krcore-sp-observation-component-value-concept.md) | CodeableConcept 자료형으로 표현된 세부 관찰 및 측정값 |
| [krcore-sp-observation-performer](SearchParameter-krcore-sp-observation-performer.md) | 관찰 및 측정 책임자 |
| [krcore-sp-observation-specimen](SearchParameter-krcore-sp-observation-specimen.md) | 본 관찰 및 측정에 사용된 검체 |
| [krcore-sp-observation-value-date](SearchParameter-krcore-sp-observation-value-date.md) | dateTime 또는 Period 자료형으로 표현된 측정값 |
| [krcore-sp-organization-address](SearchParameter-krcore-sp-organization-address.md) | 한국 도로명 주소를 포함한 기관 주소 검색 |
| [krcore-sp-organization-name](SearchParameter-krcore-sp-organization-name.md) | 기관 명칭 |
| [krcore-sp-patient-id](SearchParameter-krcore-sp-patient-id.md) | 본 리소스 인스턴스의 논리적 ID |
| [krcore-sp-patient-name](SearchParameter-krcore-sp-patient-name.md) | 환자의 성명을 구성하는 성, 이름 등의 요소 중 일치하는 문자열 |
| [krcore-sp-practitioner-name](SearchParameter-krcore-sp-practitioner-name.md) | 의료인의 성명을 구성하는 성, 이름 등의 요소 중 일치하는 문자열 |
| [krcore-sp-practitionerrole-practitioner](SearchParameter-krcore-sp-practitionerrole-practitioner.md) | 의료인 인적사항 |
| [krcore-sp-practitionerrole-specialty](SearchParameter-krcore-sp-practitionerrole-specialty.md) | 의료인 진료과목 코드 |
| [krcore-sp-procedure-code](SearchParameter-krcore-sp-procedure-code.md) | 수술 및 처치 식별 코드 |
| [krcore-sp-procedure-status](SearchParameter-krcore-sp-procedure-status.md) | 수술 및 처치 상태: preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown |
| [krcore-sp-specimen-bodysite](SearchParameter-krcore-sp-specimen-bodysite.md) | 검체 채취 부위 |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [KR Core AllergyIntolerance Profile](StructureDefinition-krcore-allergyintolerance.md) | KR Core AllergyIntolerance Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 알레르기 및 불내성 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 알레르기 및 불내성 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core Condition Profile for Chief Complaint](StructureDefinition-krcore-condition-chief-complaint.md) | KR Core Condition Profile for Chief Complaint는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 주호소 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 주호소 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core Condition Profile for Encounter Diagnosis](StructureDefinition-krcore-condition-encounter-diagnosis.md) | KR Core Condition Profile for Encounter Diagnosis는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진단 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 진단 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core DiagnosticReport Profile for Diagnostic Imaging](StructureDefinition-krcore-diagnosticreport-diagnostic-imaging.md) | KR Core DiagnosticReport Profile for Diagnostic Imaging은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진단영상검사 중 진단보고서 관련 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 진단영상검사 중 진단보고서 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core DiagnosticReport Profile for Functional Tests](StructureDefinition-krcore-diagnosticreport-function-tests.md) | KR Core DiagnosticReport Profile for Functional Tests는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 기능검사 중 진단보고서 관련 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 기능검사 중 진단보고서 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core DiagnosticReport Profile for Laboratory Results](StructureDefinition-krcore-diagnosticreport-laboratory-results.md) | KR Core DiagnosticReport Profile for Laboratory Results는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진단검사 중 진단보고서 관련 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 진단검사 중 진단보고서 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core DiagnosticReport Profile for Pathology Results](StructureDefinition-krcore-diagnosticreport-pathology-results.md) | KR Core DiagnosticReport Profile for Pathology Results는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 병리검사 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 병리검사 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core Encounter Profile](StructureDefinition-krcore-encounter.md) | KR Core Encounter Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때, 환자와 의사 간의 대면, 접촉, 만남, 혹은 의료 서비스 과정 전체에 대한 시간적·공간적 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 진료 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core Healthcare Organization Profile](StructureDefinition-krcore-healthcare-organization.md) | KR Core Healthcare Organization Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 의료기관 정보를 표현하는 데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 본 Profile은 병원, 보건소, 약국 등 건강보험심사평가원에서 요양기관으로 분류한 기관을 표현하기 위해[KR Core Organization Profile](StructureDefinition-krcore-organization.md)을 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Organization Profile을 만족한다.※ 주의사항* KR Core Organization Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core ImagingStudy Profile](StructureDefinition-krcore-imagingstudy.md) | KR Core ImagingStudy Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진단영상검사 중 영상검사 관련 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 진단영상검사 중 영상검사 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core Immunization Profile](StructureDefinition-krcore-immunization.md) | KR Core Immunization Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 예방접종 내역 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 예방접종 내역 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core Medication Profile](StructureDefinition-krcore-medication.md) | KR Core Medication Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 약품 자체의 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 약품 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core MedicationRequest Profile](StructureDefinition-krcore-medicationrequest.md) | KR Core MedicationRequest Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 약품 처방 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 약품 처방 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core Observation Profile for Functional Test](StructureDefinition-krcore-observation-function-test.md) | KR Core Observation Profile for Functional Test는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 기능검사 중 검사 관련 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 기능검사 중 검사 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core Observation Profile for Laboratory Result](StructureDefinition-krcore-observation-laboratory-result.md) | KR Core Observation Profile for Laboratory Result는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진단검사 중 검사 관련 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 진단검사 중 검사 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.※ 참고<br /> 본 Profile은 KR CDI V2 병리검사 정보를 직접적으로 다루고 있지는 않지만, FHIR Observation 리소스를 사용해 병리검사 세부 결과를 표현할 경우, Observation.category 값을 일반적으로`laboratory`로 설정한다. 이에 따라 본 Profile은 병리검사 세부 결과 표현 시 구조적 참고 자료로 활용할 수 있다. |
| [KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md) | KR Core Observation Profile for Vital Signs는 KR Core Server와 KR Core Client의 진료정보를 교류할 때 환자를 대상으로하는 다양한 활력징후 및 신체 계측 정보를 일관되게 표현하는데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 단, 아래의 목록에 해당하는 활력징후 및 신체 계측 정보는 본 Profile을 상속하여 정의한 세부 Profile들을**반드시(SHALL)**적용해야 한다. 아래의 세부 Profile들을 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다.* 활력징후 및 신체 계측 정보별 세부 Profile 목록 
* 수축기 혈압 및 이완기 혈압 - [KR Core Observation Profile for Vital Signs: Blood Pressure](StructureDefinition-krcore-bloodpressure.md)
* 키 - [KR Core Observation Profile for Vital Signs: Body Height](StructureDefinition-krcore-bodyheight.md)
* 체온 - [KR Core Observation Profile for Vital Signs: Body Temperature](StructureDefinition-krcore-bodytemperature.md)
* 몸무게 - [KR Core Observation Profile for Vital Signs: Body Weight](StructureDefinition-krcore-bodyweight.md)
* 맥박수 - [KR Core Observation Profile for Vital Signs: Heart Rate](StructureDefinition-krcore-heartrate.md)
* 산소포화도 - [KR Core Observation Profile for Vital Signs: Pulse Oximetry](StructureDefinition-krcore-pulseoximeter.md)
* 호흡수 - [KR Core Observation Profile for Vital Signs: Respiratory Rate](StructureDefinition-krcore-respiratoryrate.md)
 
※ 주의사항* KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core Observation Profile for Vital Signs: Blood Pressure](StructureDefinition-krcore-bloodpressure.md) | 본 Profile은 환자를 대상으로 측정한 수축기 혈압 및 이완기 혈압을 표현하기 위해[KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)를 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.※ 주의사항* KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core Observation Profile for Vital Signs: Body Height](StructureDefinition-krcore-bodyheight.md) | 본 Profile은 환자를 대상으로 측정한 키를 표현하기 위해[KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)를 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.※ 주의사항* KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core Observation Profile for Vital Signs: Body Temperature](StructureDefinition-krcore-bodytemperature.md) | 본 Profile은 환자를 대상으로 측정한 체온을 표현하기 위해[KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)를 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.※ 주의사항* KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core Observation Profile for Vital Signs: Body Weight](StructureDefinition-krcore-bodyweight.md) | 본 Profile은 환자를 대상으로 측정한 몸무게를 표현하기 위해[KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)를 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.※ 주의사항* KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core Observation Profile for Vital Signs: Heart Rate](StructureDefinition-krcore-heartrate.md) | 본 Profile은 환자를 대상으로 측정한 맥박수를 표현하기 위해[KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)를 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.※ 주의사항* KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core Observation Profile for Vital Signs: Pulse Oximetry](StructureDefinition-krcore-pulseoximetry.md) | 본 Profile은 환자를 대상으로 측정한 산소포화도를 표현하기 위해[KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)를 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.※ 주의사항* KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core Observation Profile for Vital Signs: Respiratory Rate](StructureDefinition-krcore-respiratoryrate.md) | 본 Profile은 환자를 대상으로 측정한 호흡수를 표현하기 위해[KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)를 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.※ 주의사항* KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core Organization Profile](StructureDefinition-krcore-organization.md) | KR Core Organization Profile은 KR Core Server와 KR Core Client의 진료정보 교류 과정에 참여하는 다양한 기관 및 부서를 일관되게 표현하는데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 임상 행위, 진료 흐름, 환자 정보 처리, 의료 데이터 관리에 공식적으로 참여하는 모든 조직 단위를 표현하는데 이 Profile을 적용할 수 있다. 단, 병원, 보건소, 약국 등 건강보험심사평가원에서 요양기관으로 분류한 기관을 표현하기 위해서는 본 Profile을 상속하여 정의한[KR Core Healthcare Organization Profile](StructureDefinition-krcore-healthcare-organization.md)을**반드시(SHALL)**적용해야 한다. KR Core Healthcare Organization Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다.※ 주의사항* KR Core Organization Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core Patient Profile](StructureDefinition-krcore-patient.md) | KR Core Patient Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 환자 정보를 표현하는 데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. |
| [KR Core Practitioner Profile](StructureDefinition-krcore-practitioner.md) | KR Core Practitioner Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 보건의료 환경에서 실질적으로 진료 과정에 참여하는 다양한 인력을 일관되게 표현하는데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 임상 행위, 진료 흐름, 환자 정보 처리, 의료 데이터 관리에 공식적으로 참여하는 모든 인력을 표현하는데 이 Profile을 적용할 수 있다. 단, 의료법에 따라 자격이 부여된 의사(Medical Doctor)를 표현하기 위해서는 본 Profile을 상속하여 정의한[KR Core Practitioner Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor.md)를**반드시(SHALL)**적용해야 한다. KR Core Practitioner Profile for Medical Doctor를 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다.※ 주의사항* KR Core Practitioner Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core Practitioner Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor.md) | KR Core Practitioner Profile for Medical Doctor는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진료의 정보를 표현하는 데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 본 Profile은 의료법에 따라 자격이 부여된 의사(Medical Doctor)를 표현하기 위해[KR Core Practitioner Profile](StructureDefinition-krcore-practitioner.md)을 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Practitioner Profile을 만족한다.※ 주의사항* KR Core Practitioner Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core PractitionerRole Profile](StructureDefinition-krcore-practitioner-role.md) | KR Core PractitionerRole Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 보건의료 환경에서 실질적으로 진료 과정에 참여하는 다양한 인력의 역할을 일관되게 표현하는데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 임상 행위, 진료 흐름, 환자 정보 처리, 의료 데이터 관리에 공식적으로 참여하는 모든 인력의 역할을 표현하는데 이 Profile을 적용할 수 있다. 단, 의료법에 따라 자격이 부여된 의사(Medical Doctor)의 역할을 표현하기 위해서는 본 Profile을 상속하여 정의한[KR Core PractitionerRole Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor-role.md)를**반드시(SHALL)**적용해야 한다. KR Core PractitionerRole Profile for Medical Doctor를 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다.※ 주의사항* KR Core PractitionerRole Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자의 역할 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core PractitionerRole Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor-role.md) | KR Core PractitionerRole Profile for Medical Doctor는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진료의의 역할 정보를 표현하는 데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 본 Profile은 의료법에 따라 자격이 부여된 의사(Medical Doctor)의 역할을 표현하기 위해[KR Core PractitionerRole Profile](StructureDefinition-krcore-practitioner-role.md)을 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core PractitionerRole Profile을 만족한다.※ 주의사항* KR Core PractitionerRole Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자의 역할 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 |
| [KR Core Procedure Profile](StructureDefinition-krcore-procedure.md) | KR Core Procedure Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 수술, 처치 그리고 마취 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 진료 행위 정보 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |
| [KR Core Specimen Profile](StructureDefinition-krcore-specimen.md) | KR Core Specimen Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 검체 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 검체 정보 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [KR Core Insurance Types Extension](StructureDefinition-krcore-insuranceTypes.md) | KR Core Insurance Types Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 환자의 건강보험유형 정보를 표현하는데 사용되며, 이 경우**반드시(SHALL)**본 Extension을 적용한다.※ 침고사항* 환자의 건강보험유형은 진료 시점에 종속되므로, FHIR Patient 리소스 인스턴스가 아닌 FHIR Encounter 리소스 인스턴스에 본 Extension을 사용한다.
 |
| [KR Core Medication Ingredient Extension](StructureDefinition-krcore-medicationIngredient.md) | KR Core Medication Ingredient Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 처방정보 내에서 약품 성분명 정보를 표현하는데 사용되며, 이 경우 아래의 조건에 따라 본 Extension을 적용한다.※ 사용조건* [KR Core MedicationRequest Profile](StructureDefinition-krcore-medicationrequest.md)을 적용한 리소스 인스턴스 내에서, `MedicationRequest.medicationCodeableConcept`를 사용하여 약품 제품명을 표현하는 경우에, 동일한 리소스 인스턴스 내에서 **반드시(SHALL)** 약품 성분명을 함께 표현해야 하며, 이를 위해 **반드시(SHALL)** 본 Extension을 사용해야 한다.
* KR Core MedicationRequest Profile을 적용한 리소스 인스턴스가 `MedicationRequest.medicationReference`를 사용하여 약품 제품명과 약품 성분명 정보를 간접적으로 제공한 경우에는, **가능한 한(SHOULD)** 본 Extension을 사용하지 않는다.
 |
| [KR Core Road Name Address Extension](StructureDefinition-krcore-roadNameAddress.md) | KR Core Road Name Address Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 한국의 도로명 주소 정보를 표현하는데 사용되며, 이 경우**가능한 한(SHOULD)**본 Extension을 적용한다. |
| [KR Core Test Request DateTime Extension](StructureDefinition-krcore-testRequestDateTime.md) | KR Core Test Request DateTime Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 검사의뢰일 정보를 표현하는데 사용되며, 이 경우 아래의 조건에 따라 본 Extension을 적용한다.※ 사용조건* [KR Core DiagnosticReport Profile for Functional Tests](StructureDefinition-krcore-diagnosticreport-function-tests.md)를 적용한 리소스 인스턴스는 **반드시(SHALL)** 본 Extension을 사용해서 기능검사 일자를 표현한다.
* [KR Core DiagnosticReport Profile for Pathology Results](StructureDefinition-krcore-diagnosticreport-pathology-results.md)를 적용한 리소스 인스턴스는 **반드시(SHALL)** 본 Extension을 사용해서 병리검사 의뢰일을 표현한다.
* 그 외 FHIR Diagnostic 리소스 인스턴스 내에 검사의뢰일 또는 검사일 정보를 표현하는 경우, **가능한 한(SHOULD)** 본 Extension을 사용한다.
 |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [ATC Codes](ValueSet-krcore-atc-codes.md) | 모든 ATC 코드를 포함한 코드집합 |
| [KR Core Condition Category Codes](ValueSet-krcore-condition-category-codes.md) | KR Core 진단 및 주호소 범주 코드집합 |
| [KR Core Diagnostic Imaging Codes](ValueSet-krcore-diagnostic-imaging-codes.md) | KR Core 진단영상검사 코드집합 |
| [KR Core Doctor Qualification Codes](ValueSet-krcore-doctor-qualification-codes.md) | KR Core 진료의 면허(자격) 종별 코드집합 |
| [KR Core EDI Material Codes](ValueSet-krcore-edi-material-codes.md) | KR Core EDI 치료재료 코드집합 |
| [KR Core EDI Medication Codes](ValueSet-krcore-edi-medication-codes.md) | KR Core EDI 약제 코드집합 |
| [KR Core EDI Procedure Codes](ValueSet-krcore-edi-procedure-codes.md) | KR Core EDI 진료행위 코드집합 |
| [KR Core Insurance Types Codes](ValueSet-krcore-insurance-types-codes.md) | KR Core 건강보험유형 구분 코드집합 |
| [KR Core KCD8 Codes](ValueSet-krcore-kcd8-codes.md) | KR Core KCD-8 코드집합 |
| [KR Core Korea Drug Codes](ValueSet-krcore-korea-drug-codes.md) | KR Core KD 코드집합 |
| [KR Core LOINC Codes](ValueSet-krcore-loinc-codes.md) | KR Core LOINC 코드집합 |
| [KR Core Laboratory Codes](ValueSet-krcore-laboratory-codes.md) | KR Core 진단검사 코드집합 |
| [KR Core Medical Department Codes](ValueSet-krcore-medicaldepartment-codes.md) | KR Core 의료인 진료과 코드집합 |
| [KR Core Organization Type Codes](ValueSet-krcore-healthcare-organization-type-codes.md) | KR Core 요양기관 종별 구분 코드집합 |
| [KR Core Pathology Codes](ValueSet-krcore-pathology-codes.md) | KR Core 병리검사 코드집합 |
| [KR Core Procedure Category Codes](ValueSet-krcore-procedure-category-codes.md) | KR Core Procedure Category 코드집합 |
| [KR Core Procedure Codes](ValueSet-krcore-procedure-codes.md) | KR Core 진료행위 코드집합 |
| [KR Core SNOMED CT Codes](ValueSet-krcore-snomed-ct-codes.md) | KR Core SNOMED CT 코드집합 |
| [KR Core Vaccination Type Codes](ValueSet-krcore-vcnt-type-codes.md) | KR Core 예방접종명 코드집합 |
| [KR Core Vital Signs Codes](ValueSet-krcore-vital-signs-codes.md) | KR Core 활력징후 및 신체 계측 항목 코드집합 |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HIRA EDI Material](CodeSystem-hira-edi-material.md) | 건강보험심사평가원 EDI 치료재료 코드체계 |
| [HIRA EDI Medication](CodeSystem-hira-edi-medication.md) | 건강보험심사평가원 EDI 약제 코드체계 |
| [HIRA EDI Procedure](CodeSystem-hira-edi-procedure.md) | 건강보험심사평가원 EDI 진료행위 코드체계 |
| [HIRA Healthcare Organization Types](CodeSystem-hira-healthcare-organization-types.md) | 건강보험심사평가원 요양종별 코드체계 |
| [HIRA Insurance Types](CodeSystem-hira-insurance-types.md) | 건강보험심사평가원 보험자구분 코드체계 |
| [HIRA Medical Department](CodeSystem-hira-medical-department.md) | 건강보험심사평가원 진료과목 코드체계 |
| [KOSTAT KCD-8](CodeSystem-kostat-kcd-8.md) | 통계청 제8차 한국표준질병·사인분류표 코드체계 |
| [KPIS Korea Drug Code](CodeSystem-kpis-kdcode.md) | 의약품관리종합정보센터 KD 코드체계 |
| [KR Core Condition Category Types](CodeSystem-krcore-condition-category-types.md) | KR Core 진단 및 주호소 범주 코드체계 |
| [KR Core Procedure Category Types](CodeSystem-krcore-procedure-category-types.md) | KR Core 수술 및 처치 범주 코드체계 |
| [KR Core Vaccination Types](CodeSystem-krcore-vcnt-types.md) | KR Core 예방접종 유형 코드체계 |
| [MOHW Practitioner Qualification Types](CodeSystem-mohw-practitioner-qualification-types.md) | 보건복지부 면허종별/자격종별 코드체계 |

### Terminology: Naming Systems 

These define identifier and/or code system identities used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [ns-hira-edi-material](NamingSystem-ns-hira-edi-material.md) | 건강보험심사평가원 EDI 치료재료 코드 명명체계 |
| [ns-hira-edi-medication](NamingSystem-ns-hira-edi-medication.md) | 건강보험심사평가원 EDI 약제 코드 명명체계 |
| [ns-hira-edi-procedure](NamingSystem-ns-hira-edi-procedure.md) | 건강보험심사평가원 EDI 진료행위 코드 명명체계 |
| [ns-hira-healthcare-organization-identifier](NamingSystem-ns-hira-healthcare-organization-identifier.md) | 건강보험심사평가원 요양기관 식별자 명명체계 |
| [ns-hira-healthcare-organization-types](NamingSystem-ns-hira-healthcare-organization-types.md) | 건강보험심사평가원 요양종별 코드 명명체계 |
| [ns-hira-insurance-types](NamingSystem-ns-hira-insurance-types.md) | 건강보험심사평가원 보험자구분 코드 명명체계 |
| [ns-hira-medical-department](NamingSystem-ns-hira-medical-department.md) | 건강보험심사평가원 진료과목 코드 명명체계 |
| [ns-kostat-kcd-8](NamingSystem-ns-kostat-kcd-8.md) | 통계청 제8차 한국표준질병·사인분류표 코드 명명체계 |
| [ns-kpis-kdcode](NamingSystem-ns-kpis-kdcode.md) | 의약품관리종합정보센터 KD 코드 명명체계 |
| [ns-mohw-md-license-id](NamingSystem-ns-mohw-md-license-id.md) | 보건복지부 진료의 면허 식별자 명명체계 |
| [ns-mohw-practitioner-qualification-types](NamingSystem-ns-mohw-practitioner-qualification-types.md) | 보건복지부 자격종별 코드 명명체계 |

