# KR Core Laboratory Codes - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Laboratory Codes**

## ValueSet: KR Core Laboratory Codes 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-laboratory-codes | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KR_Core_Laboratory_Codes |

 
KR Core 진단검사 코드집합 

 **References** 

* [KR Core DiagnosticReport Profile for Laboratory Results](StructureDefinition-krcore-diagnosticreport-laboratory-results.md)
* [KR Core Observation Profile for Laboratory Result](StructureDefinition-krcore-observation-laboratory-result.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "krcore-laboratory-codes",
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-laboratory-codes",
  "version" : "2.0.0",
  "name" : "KR_Core_Laboratory_Codes",
  "title" : "KR Core Laboratory Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core 진단검사 코드집합",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-edi-procedure-codes"
        ]
      },
      {
        "valueSet" : [
          "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-loinc-codes"
        ]
      }
    ]
  }
}

```
