# KR Core Test Request DateTime Extension - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Test Request DateTime Extension**

## Extension: KR Core Test Request DateTime Extension 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-testRequestDateTime | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_TestRequestDateTime_Extension |

KR Core Test Request DateTime Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 검사의뢰일 정보를 표현하는데 사용되며, 이 경우 아래의 조건에 따라 본 Extension을 적용한다.

※ 사용조건

* [KR Core DiagnosticReport Profile for Functional Tests](StructureDefinition-krcore-diagnosticreport-function-tests.md)를 적용한 리소스 인스턴스는 **반드시(SHALL)** 본 Extension을 사용해서 기능검사 일자를 표현한다.
* [KR Core DiagnosticReport Profile for Pathology Results](StructureDefinition-krcore-diagnosticreport-pathology-results.md)를 적용한 리소스 인스턴스는 **반드시(SHALL)** 본 Extension을 사용해서 병리검사 의뢰일을 표현한다.
* 그 외 FHIR Diagnostic 리소스 인스턴스 내에 검사의뢰일 또는 검사일 정보를 표현하는 경우, **가능한 한(SHOULD)** 본 Extension을 사용한다.

**KR CDI V2 병리검사** 클래스에서 정의한 **병리검사 의뢰일** 항목과 **KR CDI V2 기능검사** 클래스에서 정의한 **기능검사 일자** 항목을 표현하기 위해 정의한 Extension.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [KR Core DiagnosticReport Profile for Functional Tests](StructureDefinition-krcore-diagnosticreport-function-tests.md) and [KR Core DiagnosticReport Profile for Pathology Results](StructureDefinition-krcore-diagnosticreport-pathology-results.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-testRequestDateTime)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-testRequestDateTime.csv), [Excel](StructureDefinition-krcore-testRequestDateTime.xlsx), [Schematron](StructureDefinition-krcore-testRequestDateTime.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-testRequestDateTime",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-testRequestDateTime",
  "version" : "2.0.0",
  "name" : "KRCore_TestRequestDateTime_Extension",
  "title" : "KR Core Test Request DateTime Extension",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Test Request DateTime Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 검사의뢰일 정보를 표현하는데 사용되며, 이 경우 아래의 조건에 따라 본 Extension을 적용한다.\n\n※ 사용조건\n+ [KR Core DiagnosticReport Profile for Functional Tests](StructureDefinition-krcore-diagnosticreport-function-tests.html)를 적용한 리소스 인스턴스는 **반드시(SHALL)** 본 Extension을 사용해서 기능검사 일자를 표현한다.\n+ [KR Core DiagnosticReport Profile for Pathology Results](StructureDefinition-krcore-diagnosticreport-pathology-results.html)를 적용한 리소스 인스턴스는 **반드시(SHALL)** 본 Extension을 사용해서 병리검사 의뢰일을 표현한다.\n+ 그 외 FHIR Diagnostic 리소스 인스턴스 내에 검사의뢰일 또는 검사일 정보를 표현하는 경우, **가능한 한(SHOULD)** 본 Extension을 사용한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 병리검사** 클래스에서 정의한 *병리검사 의뢰일* 항목과 **KR CDI V2 기능검사** 클래스에서 정의한 *기능검사 일자* 항목을 표현하기 위해 정의한 Extension.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "DiagnosticReport"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "KR Core Test Request DateTime Extension",
        "definition" : "KR Core Test Request DateTime Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 검사의뢰일 정보를 표현하는데 사용되며, 이 경우 아래의 조건에 따라 본 Extension을 적용한다.\n\n※ 사용조건\n+ [KR Core DiagnosticReport Profile for Functional Tests](StructureDefinition-krcore-diagnosticreport-function-tests.html)를 적용한 리소스 인스턴스는 **반드시(SHALL)** 본 Extension을 사용해서 기능검사 일자를 표현한다.\n+ [KR Core DiagnosticReport Profile for Pathology Results](StructureDefinition-krcore-diagnosticreport-pathology-results.html)를 적용한 리소스 인스턴스는 **반드시(SHALL)** 본 Extension을 사용해서 병리검사 의뢰일을 표현한다.\n+ 그 외 FHIR Diagnostic 리소스 인스턴스 내에 검사의뢰일 또는 검사일 정보를 표현하는 경우, **가능한 한(SHOULD)** 본 Extension을 사용한다."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-testRequestDateTime"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
