# KR Core Observation Profile for Laboratory Result - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Observation Profile for Laboratory Result**

## Resource Profile: KR Core Observation Profile for Laboratory Result 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-observation-laboratory-result | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_Observation_LaboratoryResult |

 
KR Core Observation Profile for Laboratory Result는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진단검사 중 검사 관련 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 진단검사 중 검사 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. 
※ 참고
본 Profile은 KR CDI V2 병리검사 정보를 직접적으로 다루고 있지는 않지만, FHIR Observation 리소스를 사용해 병리검사 세부 결과를 표현할 경우, Observation.category 값을 일반적으로`laboratory`로 설정한다. 이에 따라 본 Profile은 병리검사 세부 결과 표현 시 구조적 참고 자료로 활용할 수 있다. 

 
**KR CDI V2 진단검사**클래스에서 정의한 검사 관련 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile. 

**Usages:**

* Refer to this Profile: [KR Core DiagnosticReport Profile for Laboratory Results](StructureDefinition-krcore-diagnosticreport-laboratory-results.md)
* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-observation-laboratory-result)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-observation-laboratory-result.csv), [Excel](StructureDefinition-krcore-observation-laboratory-result.xlsx), [Schematron](StructureDefinition-krcore-observation-laboratory-result.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-observation-laboratory-result",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-observation-laboratory-result",
  "version" : "2.0.0",
  "name" : "KRCore_Observation_LaboratoryResult",
  "title" : "KR Core Observation Profile for Laboratory Result",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Observation Profile for Laboratory Result는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 진단검사 중 검사 관련 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n진단검사 중 검사 관련 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.\n\n\n※ 참고<br />\n본 Profile은 KR CDI V2 병리검사 정보를 직접적으로 다루고 있지는 않지만, FHIR Observation 리소스를 사용해 병리검사 세부 결과를 표현할 경우, Observation.category 값을 일반적으로 `laboratory`로 설정한다.\n이에 따라 본 Profile은 병리검사 세부 결과 표현 시 구조적 참고 자료로 활용할 수 있다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 진단검사** 클래스에서 정의한 검사 관련 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "KR Core Observation Profile for Laboratory Result"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "short" : "진단검사 측정 상태: registered | preliminary | final | amended +"
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "관찰 및 측정 범주",
        "min" : 1,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationCategory"
            }
          ],
          "strength" : "required",
          "description" : "Codes for high level observation categories.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-category"
        }
      },
      {
        "id" : "Observation.category:Laboratory",
        "path" : "Observation.category",
        "sliceName" : "Laboratory",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "laboratory"
            }
          ]
        }
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "진단검사 측정 항목 정보",
        "alias" : ["KRCDI: 진단검사명"],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-laboratory-codes"
        }
      },
      {
        "id" : "Observation.code.coding.system",
        "path" : "Observation.code.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding.code",
        "path" : "Observation.code.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "short" : "진단검사 대상 환자",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "short" : "진단검사 일시"
      },
      {
        "id" : "Observation.issued",
        "path" : "Observation.issued",
        "short" : "진단검사 보고일시",
        "alias" : ["KRCDI: 진단검사 보고일시"],
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "short" : "검사 책임자",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner",
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner-role",
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-organization",
              "http://hl7.org/fhir/StructureDefinition/CareTeam",
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-patient",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "진단검사 측정 결과",
        "alias" : ["KRCDI: 진단검사 결과"],
        "mustSupport" : true
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "short" : "검체 정보 참조",
        "alias" : ["KRCDI: 검체 종류"],
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-specimen"
            ]
          }
        ]
      },
      {
        "id" : "Observation.referenceRange",
        "path" : "Observation.referenceRange",
        "short" : "진단검사 측정 결과 참고 구간",
        "alias" : ["KRCDI: 참고 구간"],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "short" : "세부 진단검사 측정 정보",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component.code",
        "path" : "Observation.component.code",
        "short" : "세부 진단검사 측정 항목명",
        "alias" : ["KRCDI: 진단검사명"],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-laboratory-codes"
        }
      },
      {
        "id" : "Observation.component.code.coding.system",
        "path" : "Observation.component.code.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component.code.coding.code",
        "path" : "Observation.component.code.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "세부 진단검사 측정 결과",
        "alias" : ["KRCDI: 진단검사 결과"],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component.referenceRange",
        "path" : "Observation.component.referenceRange",
        "short" : "세부 진단검사 측정 결과 참고 구간",
        "alias" : ["KRCDI: 참고 구간"],
        "mustSupport" : true
      }
    ]
  }
}

```
