# KR Core Medication Ingredient Extension - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Medication Ingredient Extension**

## Extension: KR Core Medication Ingredient Extension 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medicationIngredient | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_MedicationIngredient_Extension |

KR Core Medication Ingredient Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 처방정보 내에서 약품 성분명 정보를 표현하는데 사용되며, 이 경우 아래의 조건에 따라 본 Extension을 적용한다.

※ 사용조건

* [KR Core MedicationRequest Profile](StructureDefinition-krcore-medicationrequest.md)을 적용한 리소스 인스턴스 내에서, `MedicationRequest.medicationCodeableConcept`를 사용하여 약품 제품명을 표현하는 경우에, 동일한 리소스 인스턴스 내에서 **반드시(SHALL)** 약품 성분명을 함께 표현해야 하며, 이를 위해 **반드시(SHALL)** 본 Extension을 사용해야 한다.
* KR Core MedicationRequest Profile을 적용한 리소스 인스턴스가 `MedicationRequest.medicationReference`를 사용하여 약품 제품명과 약품 성분명 정보를 간접적으로 제공한 경우에는, **가능한 한(SHOULD)** 본 Extension을 사용하지 않는다.

**KR CDI V2 약물 정보** 클래스에서 정의한 **약품 성분명** 항목을 표현하기 위해 정의한 Extension.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [KR Core MedicationRequest Profile](StructureDefinition-krcore-medicationrequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-medicationIngredient)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-medicationIngredient.csv), [Excel](StructureDefinition-krcore-medicationIngredient.xlsx), [Schematron](StructureDefinition-krcore-medicationIngredient.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-medicationIngredient",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medicationIngredient",
  "version" : "2.0.0",
  "name" : "KRCore_MedicationIngredient_Extension",
  "title" : "KR Core Medication Ingredient Extension",
  "status" : "active",
  "date" : "2026-01-08T09:47:13+00:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Medication Ingredient Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 처방정보 내에서 약품 성분명 정보를 표현하는데 사용되며, 이 경우 아래의 조건에 따라 본 Extension을 적용한다.\n\n※ 사용조건\n+ [KR Core MedicationRequest Profile](StructureDefinition-krcore-medicationrequest.html)을 적용한 리소스 인스턴스 내에서, `MedicationRequest.medicationCodeableConcept`를 사용하여 약품 제품명을 표현하는 경우에, \n동일한 리소스 인스턴스 내에서 **반드시(SHALL)** 약품 성분명을 함께 표현해야 하며, 이를 위해 **반드시(SHALL)** 본 Extension을 사용해야 한다.\n+ KR Core MedicationRequest Profile을 적용한 리소스 인스턴스가 `MedicationRequest.medicationReference`를 사용하여 약품 제품명과 약품 성분명 정보를 간접적으로 제공한 경우에는, \n**가능한 한(SHOULD)** 본 Extension을 사용하지 않는다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 약물 정보** 클래스에서 정의한 *약품 성분명* 항목을 표현하기 위해 정의한 Extension.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationRequest.medication.ofType(CodeableConcept)"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "KR Core Medication Ingredient Extension",
        "definition" : "KR Core Medication Ingredient Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 처방정보 내에서 약품 성분명 정보를 표현하는데 사용되며, 이 경우 아래의 조건에 따라 본 Extension을 적용한다.\n\n※ 사용조건\n+ [KR Core MedicationRequest Profile](StructureDefinition-krcore-medicationrequest.html)을 적용한 리소스 인스턴스 내에서, `MedicationRequest.medicationCodeableConcept`를 사용하여 약품 제품명을 표현하는 경우에, \n동일한 리소스 인스턴스 내에서 **반드시(SHALL)** 약품 성분명을 함께 표현해야 하며, 이를 위해 **반드시(SHALL)** 본 Extension을 사용해야 한다.\n+ KR Core MedicationRequest Profile을 적용한 리소스 인스턴스가 `MedicationRequest.medicationReference`를 사용하여 약품 제품명과 약품 성분명 정보를 간접적으로 제공한 경우에는, \n**가능한 한(SHOULD)** 본 Extension을 사용하지 않는다."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medicationIngredient"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "약품 성분 코드",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-atc-codes"
        }
      },
      {
        "id" : "Extension.value[x].coding",
        "path" : "Extension.value[x].coding",
        "mustSupport" : true
      },
      {
        "id" : "Extension.value[x].coding.system",
        "path" : "Extension.value[x].coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Extension.value[x].coding.code",
        "path" : "Extension.value[x].coding.code",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
