# KR Core Insurance Types Extension - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Insurance Types Extension**

## Extension: KR Core Insurance Types Extension 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-insuranceTypes | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_InsuranceTypes_Extension |

KR Core Insurance Types Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 환자의 건강보험유형 정보를 표현하는데 사용되며, 이 경우 **반드시(SHALL)** 본 Extension을 적용한다.

※ 침고사항

* 환자의 건강보험유형은 진료 시점에 종속되므로, FHIR Patient 리소스 인스턴스가 아닌 FHIR Encounter 리소스 인스턴스에 본 Extension을 사용한다.

**KR CDI V2 환자 정보** 클래스에서 정의한 **건강보험유형** 항목을 표현하기 위해 정의한 Extension.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [KR Core Encounter Profile](StructureDefinition-krcore-encounter.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-insuranceTypes)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-insuranceTypes.csv), [Excel](StructureDefinition-krcore-insuranceTypes.xlsx), [Schematron](StructureDefinition-krcore-insuranceTypes.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-insuranceTypes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-insuranceTypes",
  "version" : "2.0.0",
  "name" : "KRCore_InsuranceTypes_Extension",
  "title" : "KR Core Insurance Types Extension",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Insurance Types Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 환자의 건강보험유형 정보를 표현하는데 사용되며, 이 경우 **반드시(SHALL)** 본 Extension을 적용한다.\n\n※ 침고사항\n+ 환자의 건강보험유형은 진료 시점에 종속되므로, FHIR Patient 리소스 인스턴스가 아닌 FHIR Encounter 리소스 인스턴스에 본 Extension을 사용한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 환자 정보** 클래스에서 정의한 *건강보험유형* 항목을 표현하기 위해 정의한 Extension.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Encounter"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "KR Core Insurance Types Extension",
        "definition" : "KR Core Insurance Types Extension은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 환자의 건강보험유형 정보를 표현하는데 사용되며, 이 경우 **반드시(SHALL)** 본 Extension을 적용한다.\n\n※ 침고사항\n+ 환자의 건강보험유형은 진료 시점에 종속되므로, FHIR Patient 리소스 인스턴스가 아닌 FHIR Encounter 리소스 인스턴스에 본 Extension을 사용한다."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-insuranceTypes"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "환자 건강보험 유형",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-insurance-types-codes"
        }
      },
      {
        "id" : "Extension.value[x].coding",
        "path" : "Extension.value[x].coding",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Extension.value[x].coding.system",
        "path" : "Extension.value[x].coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Extension.value[x].coding.code",
        "path" : "Extension.value[x].coding.code",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
