# KR Core Immunization Profile - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Immunization Profile**

## Resource Profile: KR Core Immunization Profile 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-immunization | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_Immunization |

 
KR Core Immunization Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 예방접종 내역 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 예방접종 내역 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. 

 
**KR CDI V2 예방접종 내역**클래스에서 정의한 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile. 

**Usages:**

* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-immunization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-immunization.csv), [Excel](StructureDefinition-krcore-immunization.xlsx), [Schematron](StructureDefinition-krcore-immunization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-immunization",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-immunization",
  "version" : "2.0.0",
  "name" : "KRCore_Immunization",
  "title" : "KR Core Immunization Profile",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Immunization Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 예방접종 내역 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n예방접종 내역 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 예방접종 내역** 클래스에서 정의한 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Immunization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Immunization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Immunization",
        "path" : "Immunization",
        "short" : "KR Core Immunization Profile"
      },
      {
        "id" : "Immunization.status",
        "path" : "Immunization.status",
        "short" : "예방접종 상태: completed | entered-in-error | not-done",
        "alias" : ["KRCDI: 예방접종 상태"],
        "example" : [
          {
            "label" : "Value (Preferred)",
            "valueCode" : "completed"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Immunization.vaccineCode",
        "path" : "Immunization.vaccineCode",
        "short" : "예방접종 식별 코드",
        "mustSupport" : true
      },
      {
        "id" : "Immunization.vaccineCode.coding",
        "path" : "Immunization.vaccineCode.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Immunization.vaccineCode.coding:VcntType",
        "path" : "Immunization.vaccineCode.coding",
        "sliceName" : "VcntType",
        "short" : "예방접종명",
        "alias" : ["KRCDI: 예방접종명"],
        "min" : 1,
        "max" : "*",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-vcnt-type-codes"
        }
      },
      {
        "id" : "Immunization.vaccineCode.coding:VcntType.system",
        "path" : "Immunization.vaccineCode.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Immunization.vaccineCode.coding:VcntType.code",
        "path" : "Immunization.vaccineCode.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Immunization.vaccineCode.coding:KDCode",
        "path" : "Immunization.vaccineCode.coding",
        "sliceName" : "KDCode",
        "short" : "예방접종 약품명",
        "alias" : ["KRCDI: 예방접종 약품명"],
        "min" : 0,
        "max" : "*",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-korea-drug-codes"
        }
      },
      {
        "id" : "Immunization.vaccineCode.coding:KDCode.system",
        "path" : "Immunization.vaccineCode.coding.system",
        "min" : 1
      },
      {
        "id" : "Immunization.vaccineCode.coding:KDCode.code",
        "path" : "Immunization.vaccineCode.coding.code",
        "min" : 1
      },
      {
        "id" : "Immunization.patient",
        "path" : "Immunization.patient",
        "short" : "예방접종 대상 환자",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Immunization.occurrence[x]",
        "path" : "Immunization.occurrence[x]",
        "short" : "예방접종 일시",
        "alias" : ["KRCDI: 예방접종 일자"],
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Immunization.protocolApplied",
        "path" : "Immunization.protocolApplied",
        "short" : "예방접종 프로토콜"
      },
      {
        "id" : "Immunization.protocolApplied.doseNumber[x]",
        "path" : "Immunization.protocolApplied.doseNumber[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Immunization.protocolApplied.doseNumber[x]:doseNumberPositiveInt",
        "path" : "Immunization.protocolApplied.doseNumber[x]",
        "sliceName" : "doseNumberPositiveInt",
        "short" : "예방접종 차수",
        "alias" : ["KRCDI: 예방접종 차수"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ]
      }
    ]
  }
}

```
